/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.enterprise.inject.spi.InjectionPoint;
import org.ops4j.pax.cdi.api.OsgiService;
import org.ops4j.pax.cdi.extension.impl.compat.PrototypeScopeUtils;
import org.ops4j.pax.swissbox.tracker.ServiceLookup;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionPointOsgiUtils {
    private static Logger log = LoggerFactory.getLogger(InjectionPointOsgiUtils.class);

    private InjectionPointOsgiUtils() {
    }

    public static boolean isServiceAvailable(InjectionPoint ip) {
        return InjectionPointOsgiUtils.getServiceReference(ip) != null;
    }

    public static ServiceReference getServiceReference(InjectionPoint ip) {
        OsgiService qualifier = (OsgiService)ip.getAnnotated().getAnnotation(OsgiService.class);
        Type serviceType = ip.getType();
        Class klass = (Class)serviceType;
        String filter = InjectionPointOsgiUtils.getFilter(klass, qualifier);
        BundleContext bc = InjectionPointOsgiUtils.getBundleContext(ip);
        return ServiceLookup.getServiceReference((BundleContext)bc, (String)klass.getName(), (long)qualifier.timeout(), (String)filter);
    }

    public static Object lookupService(BundleContext bc, InjectionPoint ip) {
        Class klass = (Class)ip.getType();
        OsgiService os = (OsgiService)ip.getAnnotated().getAnnotation(OsgiService.class);
        String filter = InjectionPointOsgiUtils.getFilter(klass, os);
        int timeout = os.timeout() == -1 ? 1 : os.timeout();
        ServiceReference serviceRef = ServiceLookup.getServiceReference((BundleContext)bc, (String)klass.getName(), (long)timeout, (String)filter);
        return PrototypeScopeUtils.createServiceObjectsWrapper(bc, serviceRef).getService();
    }

    public static Object lookupService(InjectionPoint ip) {
        Class klass = (Class)ip.getType();
        OsgiService os = (OsgiService)ip.getAnnotated().getAnnotation(OsgiService.class);
        BundleContext bc = InjectionPointOsgiUtils.getBundleContext(ip);
        String filter = InjectionPointOsgiUtils.getFilter(klass, os);
        int timeout = os.timeout() == -1 ? 1 : os.timeout();
        ServiceReference serviceRef = ServiceLookup.getServiceReference((BundleContext)bc, (String)klass.getName(), (long)timeout, (String)filter);
        return bc.getServiceObjects(serviceRef).getService();
    }

    public static String getFilter(Class<?> serviceType, OsgiService qualifier) {
        String objectClassClause = "(objectClass=" + serviceType.getName() + ")";
        String filter = "(&" + objectClassClause + qualifier.filter() + ")";
        log.debug("filter = " + filter);
        return filter;
    }

    public static String getFilter(InjectionPoint ip) {
        Class<?> klass = InjectionPointOsgiUtils.getServiceType(ip);
        OsgiService os = (OsgiService)ip.getAnnotated().getAnnotation(OsgiService.class);
        return InjectionPointOsgiUtils.getFilter(klass, os);
    }

    public static Type getInstanceType(InjectionPoint ip) {
        ParameterizedType parameterizedType;
        Type[] argTypes;
        if (ip.getType() instanceof ParameterizedType && (argTypes = (parameterizedType = (ParameterizedType)ip.getType()).getActualTypeArguments()).length > 0) {
            Type instanceType = argTypes[0];
            return instanceType;
        }
        return null;
    }

    public static Class<?> getServiceType(InjectionPoint ip) {
        Type serviceType = InjectionPointOsgiUtils.getInstanceType(ip);
        if (serviceType == null) {
            serviceType = ip.getType();
        }
        return (Class)serviceType;
    }

    public static BundleContext getBundleContext(InjectionPoint ip) {
        return InjectionPointOsgiUtils.getBundleContext(ip.getMember().getDeclaringClass());
    }

    public static BundleContext getBundleContext(Class<?> klass) {
        BundleContext bc = null;
        try {
            BundleReference bundleRef = (BundleReference)BundleReference.class.cast(klass.getClassLoader());
            bc = bundleRef.getBundle().getBundleContext();
        }
        catch (ClassCastException exc) {
            log.error("class " + klass.getName() + " is not loaded from an OSGi bundle");
            throw exc;
        }
        return bc;
    }
}

