/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath20.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.compiler.api.ExpressionCompiler;
import org.apache.ode.bpel.compiler.bom.Expression;
import org.apache.ode.bpel.elang.xpath10.compiler.XPathMessages;
import org.apache.ode.bpel.elang.xpath10.compiler.XslCompilationErrorListener;
import org.apache.ode.bpel.elang.xpath20.compiler.JaxpFunctionResolver;
import org.apache.ode.bpel.elang.xpath20.compiler.JaxpVariableResolver;
import org.apache.ode.bpel.elang.xpath20.compiler.WrappedResolverException;
import org.apache.ode.bpel.elang.xpath20.compiler.XPath20ExpressionCompilerBPEL20;
import org.apache.ode.bpel.elang.xpath20.o.OXPath20ExpressionBPEL20;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OLValueExpression;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.w3c.dom.Node;

public class XPath20ExpressionCompilerImpl
implements ExpressionCompiler {
    protected static final Log __log = LogFactory.getLog(XPath20ExpressionCompilerBPEL20.class);
    protected String _bpelNS;
    protected QName _qnLinkStatus;
    protected QName _qnVarProp;
    protected QName _qnVarData;
    protected QName _qnXslTransform;
    protected final XPathMessages __msgs = MessageBundle.getMessages(XPathMessages.class);
    protected Map<String, String> _properties = new HashMap<String, String>();
    protected CompilerContext _compilerContext;

    public XPath20ExpressionCompilerImpl(String bpelNS) {
        this._bpelNS = bpelNS;
        this._qnLinkStatus = new QName(this._bpelNS, "getLinkStatus");
        this._qnVarProp = new QName(this._bpelNS, "getVariableProperty");
        this._qnVarData = new QName(this._bpelNS, "getVariableData");
        this._qnXslTransform = new QName(this._bpelNS, "doXslTransform");
        this._properties.put("runtime-class", "org.apache.ode.bpel.elang.xpath20.runtime.XPath20ExpressionRuntime");
        TransformerFactoryImpl trsf = new TransformerFactoryImpl();
        XslTransformHandler.getInstance().setTransformerFactory((TransformerFactory)trsf);
    }

    @Override
    public void setCompilerContext(CompilerContext compilerContext) {
        this._compilerContext = compilerContext;
        XslCompilationErrorListener xe = new XslCompilationErrorListener(compilerContext);
        XslTransformHandler.getInstance().setErrorListener(xe);
    }

    @Override
    public OExpression compileJoinCondition(Object source) throws CompilationException {
        return this._compile((Expression)source, true);
    }

    @Override
    public OExpression compile(Object source) throws CompilationException {
        return this._compile((Expression)source, false);
    }

    @Override
    public OLValueExpression compileLValue(Object source) throws CompilationException {
        return (OLValueExpression)this._compile((Expression)source, false);
    }

    private OExpression _compile(Expression xpath, boolean isJoinCondition) throws CompilationException {
        OXPath20ExpressionBPEL20 oexp = new OXPath20ExpressionBPEL20(this._compilerContext.getOProcess(), this._qnVarData, this._qnVarProp, this._qnLinkStatus, this._qnXslTransform, isJoinCondition);
        oexp.namespaceCtx = xpath.getNamespaceContext();
        this.doJaxpCompile(oexp, xpath);
        return oexp;
    }

    private void doJaxpCompile(OXPath20ExpressionBPEL20 out, Expression source) throws CompilationException {
        Node node = source.getExpression();
        if (node == null) {
            throw new CompilationException(this.__msgs.errEmptyExpression(source.getURI(), new QName(source.getElement().getNamespaceURI(), source.getElement().getNodeName())));
        }
        if (node.getNodeType() != 3) {
            throw new CompilationException(this.__msgs.errUnexpectedNodeTypeForXPath(DOMUtils.domToString(node)));
        }
        String xpathStr = node.getNodeValue();
        if ((xpathStr = xpathStr.trim()).length() == 0) {
            throw new CompilationException(this.__msgs.warnXPath20Syntax(DOMUtils.domToString(node), "empty string"));
        }
        out.xpath = xpathStr;
        try {
            __log.debug((Object)("Compiling expression " + xpathStr));
            XPathFactoryImpl xpf = new XPathFactoryImpl();
            JaxpFunctionResolver funcResolver = new JaxpFunctionResolver(this._compilerContext, out, source.getNamespaceContext(), this._bpelNS);
            JaxpVariableResolver varResolver = new JaxpVariableResolver(this._compilerContext, out);
            XPath xpe = xpf.newXPath();
            xpe.setXPathFunctionResolver(funcResolver);
            xpe.setXPathVariableResolver(varResolver);
            xpe.setNamespaceContext(source.getNamespaceContext());
            XPathExpression expr = xpe.compile(xpathStr);
            try {
                expr.evaluate(node);
            }
            catch (XPathExpressionException xpee) {
                // empty catch block
            }
            for (String varExpr : this.extractVariableExprs(xpathStr)) {
                expr = xpe.compile(varExpr);
                try {
                    expr.evaluate(node);
                }
                catch (XPathExpressionException xpee) {}
            }
            for (String functionExpr : this.extractFunctionExprs(xpathStr)) {
                expr = xpe.compile(functionExpr);
                try {
                    expr.evaluate(node);
                }
                catch (XPathExpressionException xpee) {}
            }
        }
        catch (XPathExpressionException e) {
            __log.debug((Object)e);
            __log.info((Object)("Couldn't validate properly expression " + xpathStr));
        }
        catch (WrappedResolverException wre) {
            if (wre._compilationMsg != null) {
                throw new CompilationException(wre._compilationMsg, (Throwable)wre);
            }
            if (wre.getCause() instanceof CompilationException) {
                throw (CompilationException)wre.getCause();
            }
            throw wre;
        }
    }

    private List<String> extractVariableExprs(String xpathStr) {
        ArrayList<String> variableExprs = new ArrayList<String>();
        int firstVariable = xpathStr.indexOf("$");
        int lastVariable = xpathStr.lastIndexOf("$");
        int firstFunction = xpathStr.indexOf("(");
        StringBuffer variableExpr = new StringBuffer();
        if (firstVariable > 0 && firstFunction > 0 || firstVariable < lastVariable) {
            boolean quoted = false;
            boolean doubleQuoted = false;
            boolean variable = false;
            Name11Checker nameChecker = Name11Checker.getInstance();
            for (int index = 0; index < xpathStr.length(); ++index) {
                char ch = xpathStr.charAt(index);
                if (ch == '\'') {
                    boolean bl = quoted = !quoted;
                }
                if (ch == '\"') {
                    boolean bl = doubleQuoted = !doubleQuoted;
                }
                if (quoted || doubleQuoted) continue;
                if (ch == '$') {
                    variable = true;
                    variableExpr.setLength(0);
                    variableExpr.append(ch);
                    continue;
                }
                if (!variable) continue;
                variableExpr.append(ch);
                if (ch == ':' || index != xpathStr.length() && nameChecker.isQName(variableExpr.substring(1))) continue;
                variable = false;
                variableExpr.setLength(variableExpr.length() - 1);
                variableExprs.add(variableExpr.toString());
                variableExpr.setLength(0);
            }
            if (variableExpr.length() > 0) {
                variableExprs.add(variableExpr.toString());
            }
        }
        return variableExprs;
    }

    private List<String> extractFunctionExprs(String xpathStr) {
        ArrayList<String> functionExprs = new ArrayList<String>();
        String FUNCTION_REGEX = "(\\w+:)?\\w+\\((.+)?\\)";
        int firstFunction = xpathStr.indexOf("(");
        int lastFunction = xpathStr.lastIndexOf("(");
        if (firstFunction > 0 && firstFunction < lastFunction) {
            Pattern regex = Pattern.compile("(\\w+:)?\\w+\\((.+)?\\)");
            Matcher matcher = regex.matcher(xpathStr);
            while (matcher.find()) {
                String function = matcher.group();
                functionExprs.add(function);
            }
        }
        return functionExprs;
    }

    @Override
    public Map<String, String> getProperties() {
        return this._properties;
    }
}

