/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.migration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.migration.CorrelationKeyMigration;
import org.apache.ode.bpel.engine.migration.CorrelationKeySetDataMigration;
import org.apache.ode.bpel.engine.migration.CorrelationKeySetMigration;
import org.apache.ode.bpel.engine.migration.CorrelatorsMigration;
import org.apache.ode.bpel.engine.migration.Migration;
import org.apache.ode.bpel.engine.migration.OutstandingRequestsMigration;

public class MigrationHandler {
    private static final Log __log = LogFactory.getLog(MigrationHandler.class);
    public static final int CURRENT_SCHEMA_VERSION = 6;
    private Contexts _contexts;
    private List<MigrationLink> migrationLinks = new ArrayList<MigrationLink>(){
        {
            this.add(new MigrationLink(1, 2, new Migration[]{new CorrelatorsMigration(), new CorrelationKeyMigration()}));
            this.add(new MigrationLink(2, 3, new Migration[]{new CorrelationKeySetMigration()}));
            this.add(new MigrationLink(4, 3, new Migration[]{new CorrelationKeySetMigration()}));
            this.add(new MigrationLink(3, 5, new Migration[]{new CorrelationKeySetDataMigration()}));
            this.add(new MigrationLink(5, 6, new Migration[]{new OutstandingRequestsMigration()}));
        }
    };

    public MigrationHandler(Contexts _contexts) {
        this._contexts = _contexts;
    }

    public boolean migrate(final Set<BpelProcess> registeredProcesses, int migrationTransactionTimeout) {
        int version;
        if (this._contexts.dao.getConnection() == null) {
            __log.debug((Object)"No datasource available, stopping migration. Probably running fully in-memory.");
            return true;
        }
        try {
            version = this.getDbVersion();
        }
        catch (Throwable e) {
            __log.info((Object)"The ODE_SCHEMA_VERSION database table doesn't exist. Unless you need to migrate your datafrom a past version, this message can be safely ignored.");
            return false;
        }
        if (version == -1) {
            __log.info((Object)"No schema version available from the database, migrations will be skipped.");
            return true;
        }
        if (version == 6) {
            return true;
        }
        try {
            boolean success = this._contexts.scheduler.execTransaction(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    ArrayList migrations = new ArrayList();
                    MigrationHandler.this.findMigrations(version, 6, migrations);
                    if (migrations.size() == 0) {
                        __log.error((Object)("Don't know how to migrate from " + version + " to " + 6 + ", aborting"));
                        return false;
                    }
                    boolean success = true;
                    for (Migration mig : migrations) {
                        __log.debug((Object)("Running migration " + mig));
                        success = mig.migrate(registeredProcesses, ((MigrationHandler)MigrationHandler.this)._contexts.dao.getConnection()) && success;
                    }
                    if (!success) {
                        ((MigrationHandler)MigrationHandler.this)._contexts.scheduler.setRollbackOnly();
                    } else {
                        MigrationHandler.this.setDbVersion(6);
                    }
                    return success;
                }
            }, migrationTransactionTimeout);
            return success;
        }
        catch (Exception e) {
            __log.error((Object)"An error occured while migrating your database to a newer version of ODE, changes have been aborted", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean findMigrations(int source, int target, List<Migration> ms) {
        List<MigrationLink> l = this.findLinksTo(target);
        for (MigrationLink link : l) {
            if (link.source != source && !this.findMigrations(source, link.source, ms)) continue;
            ms.addAll(Arrays.asList(link.migrations));
            return true;
        }
        return false;
    }

    private List<MigrationLink> findLinksTo(int target) {
        ArrayList<MigrationLink> mls = new ArrayList<MigrationLink>();
        for (MigrationLink ml : this.migrationLinks) {
            if (ml.target != target) continue;
            mls.add(ml);
        }
        return mls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDbVersion() {
        int version = -1;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = null;
            stmt = conn.prepareStatement("SELECT VERSION FROM ODE_SCHEMA_VERSION");
            rs = stmt.executeQuery();
            if (rs.next()) {
                version = rs.getInt("VERSION");
            }
        }
        catch (Exception e) {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                throw new RuntimeException(e2);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDbVersion(int version) {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = null;
            stmt = conn.createStatement();
            int res = stmt.executeUpdate("UPDATE ODE_SCHEMA_VERSION SET VERSION = " + version);
            if (res == 0) {
                throw new RuntimeException("Couldn't update schema version.");
            }
        }
        catch (Exception e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                throw new RuntimeException(e2);
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class MigrationLink {
        int source;
        int target;
        Migration[] migrations;

        public MigrationLink(int source, int target, Migration[] migrations) {
            this.source = source;
            this.target = target;
            this.migrations = migrations;
        }
    }
}

