/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.o.OEventHandler;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelJacobRunnable;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.PartnerLinkInstance;
import org.apache.ode.bpel.runtime.SCOPE;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.Selector;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.bpel.runtime.channels.EventHandlerControlChannel;
import org.apache.ode.bpel.runtime.channels.EventHandlerControlChannelListener;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannel;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.runtime.channels.PickResponseChannel;
import org.apache.ode.bpel.runtime.channels.PickResponseChannelListener;
import org.apache.ode.bpel.runtime.channels.TerminationChannel;
import org.apache.ode.bpel.runtime.channels.TerminationChannelListener;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.SynchChannel;
import org.w3c.dom.Element;

class EH_EVENT
extends BpelJacobRunnable {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(EH_EVENT.class);
    private EventHandlerControlChannel _ehc;
    private TerminationChannel _tc;
    private ParentScopeChannel _psc;
    private ScopeFrame _scopeFrame;
    private OEventHandler.OEvent _oevent;
    private Set<CompensationHandler> _comps = new HashSet<CompensationHandler>();
    private FaultData _fault;
    private Set<ActivityInfo> _active = new HashSet<ActivityInfo>();
    private boolean _stopped;
    private boolean _terminated;
    private boolean _childrenTerminated;

    EH_EVENT(ParentScopeChannel psc, TerminationChannel tc, EventHandlerControlChannel ehc, OEventHandler.OEvent o, ScopeFrame scopeFrame) {
        this._scopeFrame = scopeFrame;
        this._oevent = o;
        this._tc = tc;
        this._psc = psc;
        this._ehc = ehc;
    }

    @Override
    public void run() {
        EH_EVENT.instance(new SELECT());
    }

    private void terminateActive() {
        if (!this._childrenTerminated) {
            for (ActivityInfo tact : this._active) {
                EH_EVENT.replication(tact.self).terminate();
            }
            this._childrenTerminated = true;
        }
    }

    private class WAITING
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 1L;
        private PickResponseChannel _pickResponseChannel;

        private WAITING(PickResponseChannel pickResponseChannel) {
            this._pickResponseChannel = pickResponseChannel;
        }

        @Override
        public void run() {
            if (!EH_EVENT.this._active.isEmpty() || this._pickResponseChannel != null) {
                HashSet<ChannelListener> mlset = new HashSet<ChannelListener>();
                if (!EH_EVENT.this._terminated) {
                    mlset.add(new TerminationChannelListener(EH_EVENT.this._tc){
                        private static final long serialVersionUID = 7666910462948788042L;

                        @Override
                        public void terminate() {
                            EH_EVENT.this.terminateActive();
                            EH_EVENT.this._terminated = true;
                            if (WAITING.this._pickResponseChannel != null) {
                                WAITING.this.getBpelRuntimeContext().cancel(WAITING.this._pickResponseChannel);
                            }
                            1.instance(WAITING.this);
                        }
                    });
                }
                if (!EH_EVENT.this._stopped) {
                    mlset.add(new EventHandlerControlChannelListener(EH_EVENT.this._ehc){
                        private static final long serialVersionUID = -1050788954724647970L;

                        @Override
                        public void stop() {
                            EH_EVENT.this._stopped = true;
                            if (WAITING.this._pickResponseChannel != null) {
                                WAITING.this.getBpelRuntimeContext().cancel(WAITING.this._pickResponseChannel);
                            }
                            2.instance(WAITING.this);
                        }
                    });
                }
                for (final ActivityInfo ai : EH_EVENT.this._active) {
                    mlset.add(new ParentScopeChannelListener(ai.parent){
                        private static final long serialVersionUID = 5341207762415360982L;

                        @Override
                        public void compensate(OScope scope, SynchChannel ret) {
                            EH_EVENT.this._psc.compensate(scope, ret);
                            3.instance(WAITING.this);
                        }

                        @Override
                        public void completed(FaultData faultData, Set<CompensationHandler> compensations) {
                            EH_EVENT.this._active.remove(ai);
                            EH_EVENT.this._comps.addAll(compensations);
                            if (faultData != null && EH_EVENT.this._fault == null) {
                                EH_EVENT.this._fault = faultData;
                                EH_EVENT.this.terminateActive();
                                if (WAITING.this._pickResponseChannel != null) {
                                    WAITING.this.getBpelRuntimeContext().cancel(WAITING.this._pickResponseChannel);
                                }
                                EH_EVENT.this._psc.completed(EH_EVENT.this._fault, EH_EVENT.this._comps);
                            } else {
                                3.instance(WAITING.this);
                            }
                        }

                        @Override
                        public void cancelled() {
                            this.completed(null, CompensationHandler.emptySet());
                        }

                        @Override
                        public void failure(String reason, Element data) {
                            this.completed(null, CompensationHandler.emptySet());
                        }
                    });
                }
                if (this._pickResponseChannel != null) {
                    mlset.add(new PickResponseChannelListener(this._pickResponseChannel){
                        private static final long serialVersionUID = -4929999153478677288L;

                        @Override
                        public void onRequestRcvd(int selectorIdx, String mexId) {
                            Element msgEl;
                            ScopeFrame ehScopeFrame = new ScopeFrame(EH_EVENT.this._oevent, WAITING.this.getBpelRuntimeContext().createScopeInstance(((EH_EVENT)EH_EVENT.this)._scopeFrame.scopeInstanceId, EH_EVENT.this._oevent), EH_EVENT.this._scopeFrame, EH_EVENT.this._comps, EH_EVENT.this._fault);
                            if (((EH_EVENT)EH_EVENT.this)._oevent.variable != null && (msgEl = WAITING.this.getBpelRuntimeContext().getMyRequest(mexId)) != null) {
                                try {
                                    VariableInstance vinst = ehScopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.variable);
                                    WAITING.this.getBpelRuntimeContext().writeVariable(vinst, msgEl);
                                    VariableModificationEvent se = new VariableModificationEvent(vinst.declaration.name);
                                    se.setNewValue(msgEl);
                                    EH_EVENT.this._scopeFrame.fillEventInfo(se);
                                    if (((EH_EVENT)EH_EVENT.this)._oevent.debugInfo != null) {
                                        se.setLineNo(((EH_EVENT)EH_EVENT.this)._oevent.debugInfo.startLine);
                                    }
                                    WAITING.this.getBpelRuntimeContext().sendEvent(se);
                                }
                                catch (Exception ex) {
                                    __log.fatal((Object)ex);
                                    throw new InvalidProcessException(ex);
                                }
                            }
                            try {
                                for (OScope.CorrelationSet cset : ((EH_EVENT)EH_EVENT.this)._oevent.initCorrelations) {
                                    WAITING.this.initializeCorrelation(ehScopeFrame.resolve(cset), ehScopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.variable));
                                }
                                for (OScope.CorrelationSet cset : ((EH_EVENT)EH_EVENT.this)._oevent.joinCorrelations) {
                                    WAITING.this.initializeCorrelation(ehScopeFrame.resolve(cset), ehScopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.variable));
                                }
                                if (((EH_EVENT)EH_EVENT.this)._oevent.partnerLink.hasPartnerRole()) {
                                    String partnersSessionId;
                                    Element fromEpr;
                                    if (!(WAITING.this.getBpelRuntimeContext().isPartnerRoleEndpointInitialized(ehScopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink)) && ((EH_EVENT)EH_EVENT.this)._oevent.partnerLink.initializePartnerRole || (fromEpr = WAITING.this.getBpelRuntimeContext().getSourceEPR(mexId)) == null)) {
                                        WAITING.this.getBpelRuntimeContext().writeEndpointReference(ehScopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink), fromEpr);
                                    }
                                    if ((partnersSessionId = WAITING.this.getBpelRuntimeContext().getSourceSessionId(mexId)) != null) {
                                        WAITING.this.getBpelRuntimeContext().initializePartnersSessionId(ehScopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink), partnersSessionId);
                                    }
                                }
                                WAITING.this.getBpelRuntimeContext().cancelOutstandingRequests(WAITING.this._pickResponseChannel.export());
                                WAITING.this.getBpelRuntimeContext().processOutstandingRequest(EH_EVENT.this._scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink), ((EH_EVENT)EH_EVENT.this)._oevent.operation.getName(), ((EH_EVENT)EH_EVENT.this)._oevent.messageExchangeId, mexId);
                            }
                            catch (FaultException e) {
                                __log.error((Object)e);
                                if (EH_EVENT.this._fault == null) {
                                    EH_EVENT.this._fault = WAITING.this.createFault(e.getQName(), EH_EVENT.this._oevent);
                                    EH_EVENT.this.terminateActive();
                                }
                                4.instance(new WAITING(null));
                                return;
                            }
                            ActivityInfo child = new ActivityInfo(WAITING.this.genMonotonic(), ((EH_EVENT)EH_EVENT.this)._oevent.activity, this.newChannel(TerminationChannel.class), this.newChannel(ParentScopeChannel.class));
                            EH_EVENT.this._active.add(child);
                            LinkFrame lf = new LinkFrame(null);
                            ScopeFrame innerScopeFrame = new ScopeFrame((OScope)((EH_EVENT)EH_EVENT.this)._oevent.activity, WAITING.this.getBpelRuntimeContext().createScopeInstance(((EH_EVENT)EH_EVENT.this)._scopeFrame.scopeInstanceId, (OScope)((EH_EVENT)EH_EVENT.this)._oevent.activity), ehScopeFrame, EH_EVENT.this._comps, EH_EVENT.this._fault);
                            4.instance(new SCOPE(child, innerScopeFrame, lf));
                            if (EH_EVENT.this._childrenTerminated) {
                                4.replication(child.self).terminate();
                            }
                            if (EH_EVENT.this._terminated || EH_EVENT.this._stopped || EH_EVENT.this._fault != null) {
                                4.instance(new WAITING(null));
                            } else {
                                4.instance(new SELECT());
                            }
                        }

                        @Override
                        public void onTimeout() {
                            4.instance(new WAITING(null));
                        }

                        @Override
                        public void onCancel() {
                            4.instance(new WAITING(null));
                        }
                    });
                }
                WAITING.object(false, mlset);
            } else {
                EH_EVENT.this._psc.completed(EH_EVENT.this._fault, EH_EVENT.this._comps);
            }
        }
    }

    class SELECT
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 1L;

        SELECT() {
        }

        @Override
        public void run() {
            try {
                PickResponseChannel pickResponseChannel = this.newChannel(PickResponseChannel.class);
                CorrelationKeySet keySet = new CorrelationKeySet();
                PartnerLinkInstance pLinkInstance = EH_EVENT.this._scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink);
                for (OScope.CorrelationSet cset : ((EH_EVENT)EH_EVENT.this)._oevent.joinCorrelations) {
                    if (!this.getBpelRuntimeContext().isCorrelationInitialized(EH_EVENT.this._scopeFrame.resolve(cset))) continue;
                    keySet.add(this.getBpelRuntimeContext().readCorrelation(EH_EVENT.this._scopeFrame.resolve(cset)));
                }
                for (OScope.CorrelationSet cset : ((EH_EVENT)EH_EVENT.this)._oevent.matchCorrelations) {
                    if (!this.getBpelRuntimeContext().isCorrelationInitialized(EH_EVENT.this._scopeFrame.resolve(cset))) {
                        throw new FaultException(((EH_EVENT)EH_EVENT.this)._oevent.getOwner().constants.qnCorrelationViolation, "Correlation not initialized.");
                    }
                    keySet.add(this.getBpelRuntimeContext().readCorrelation(EH_EVENT.this._scopeFrame.resolve(cset)));
                }
                if (keySet.isEmpty()) {
                    String sessionId = this.getBpelRuntimeContext().fetchMySessionId(pLinkInstance);
                    keySet.add(new CorrelationKey("-1", new String[]{sessionId}));
                }
                Selector selector = new Selector(0, pLinkInstance, ((EH_EVENT)EH_EVENT.this)._oevent.operation.getName(), ((EH_EVENT)EH_EVENT.this)._oevent.operation.getOutput() == null, ((EH_EVENT)EH_EVENT.this)._oevent.messageExchangeId, keySet, ((EH_EVENT)EH_EVENT.this)._oevent.route);
                this.getBpelRuntimeContext().select(pickResponseChannel, null, false, new Selector[]{selector});
                SELECT.instance(new WAITING(pickResponseChannel));
            }
            catch (FaultException e) {
                __log.error((Object)e);
                if (EH_EVENT.this._fault == null) {
                    EH_EVENT.this._fault = this.createFault(e.getQName(), EH_EVENT.this._oevent);
                }
                EH_EVENT.this.terminateActive();
                SELECT.instance(new WAITING(null));
            }
        }
    }
}

