/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.bpel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.dao.bpel.CorrelationSetDAO;
import org.apache.ode.dao.bpel.ProcessDAO;
import org.apache.ode.dao.bpel.ProcessInstanceDAO;
import org.apache.ode.dao.bpel.ScopeDAO;
import org.apache.ode.dao.jpa.bpel.CorrSetProperty;
import org.apache.ode.dao.jpa.bpel.ScopeDAOImpl;

@Entity
@Table(name="BPEL_CORRELATION_SET")
@NamedQueries(value={@NamedQuery(name="DELETE_CORRELATION_SETS_BY_IDS", query="delete from CorrelationSetDAOImpl as c where c._correlationSetId in (:ids)"), @NamedQuery(name="SELECT_CORRELATION_SETS_BY_INSTANCES", query="select c from CorrelationSetDAOImpl as c left join fetch c._scope left join fetch c._props where c._scope._processInstance._instanceId in (:instances)"), @NamedQuery(name="SELECT_CORRELATION_SET_IDS_BY_PROCESS", query="select c._correlationSetId from CorrelationSetDAOImpl as c where c._scope._processInstance._process = :process"), @NamedQuery(name="SELECT_CORRELATION_SET_IDS_BY_INSTANCE", query="select c._correlationSetId from CorrelationSetDAOImpl as c where c._scope._processInstance = :instance"), @NamedQuery(name="SELECT_ACTIVE_SETS", query="select c from CorrelationSetDAOImpl as c left join fetch c._scope where c._scope._processInstance._state = (:state)")})
public class CorrelationSetDAOImpl
implements CorrelationSetDAO {
    public static final String DELETE_CORRELATION_SETS_BY_IDS = "DELETE_CORRELATION_SETS_BY_IDS";
    public static final String SELECT_CORRELATION_SETS_BY_INSTANCES = "SELECT_CORRELATION_SETS_BY_INSTANCES";
    public static final String SELECT_CORRELATION_SET_IDS_BY_PROCESS = "SELECT_CORRELATION_SET_IDS_BY_PROCESS";
    public static final String SELECT_CORRELATION_SET_IDS_BY_INSTANCE = "SELECT_CORRELATION_SET_IDS_BY_INSTANCE";
    public static final String SELECT_ACTIVE_SETS = "SELECT_ACTIVE_SETS";
    @Id
    @Column(name="CORRELATION_SET_ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long _correlationSetId;
    @Basic
    @Column(name="NAME")
    private String _name;
    @Basic
    @Column(name="CORRELATION_KEY")
    private String _correlationKey;
    @OneToMany(targetEntity=CorrSetProperty.class, mappedBy="_corrSet", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Collection<CorrSetProperty> _props = new ArrayList<CorrSetProperty>();
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="SCOPE_ID")
    private ScopeDAOImpl _scope;

    public CorrelationSetDAOImpl() {
    }

    public CorrelationSetDAOImpl(ScopeDAOImpl scope, String name) {
        this._name = name;
        this._scope = scope;
    }

    @Override
    public Long getCorrelationSetId() {
        return this._correlationSetId;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Map<QName, String> getProperties() {
        HashMap<QName, String> map = new HashMap<QName, String>();
        for (CorrSetProperty prop : this._props) {
            map.put(QName.valueOf(prop.getPropertyKey()), prop.getPropertyValue());
        }
        return map;
    }

    @Override
    public ScopeDAO getScope() {
        return this._scope;
    }

    @Override
    public CorrelationKey getValue() {
        if (this._correlationKey == null) {
            return null;
        }
        return new CorrelationKey(this._correlationKey);
    }

    @Override
    public void setValue(QName[] names, CorrelationKey values) {
        this._correlationKey = values.toCanonicalString();
        if (names != null) {
            for (int m = 0; m < names.length; ++m) {
                CorrSetProperty prop = new CorrSetProperty(names[m].toString(), values.getValues()[m]);
                this._props.add(prop);
                prop.setCorrSet(this);
            }
        }
    }

    @Override
    public ProcessDAO getProcess() {
        return this._scope.getProcessInstance().getProcess();
    }

    @Override
    public ProcessInstanceDAO getInstance() {
        return this._scope.getProcessInstance();
    }

    @Deprecated
    public Long get_correlationSetId() {
        return this._correlationSetId;
    }

    @Deprecated
    public void set_correlationSetId(Long correlationSetId) {
        this._correlationSetId = correlationSetId;
    }
}

