/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.console.json;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.DOMUtils;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.jboss.soa.bpel.console.json.ResultAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlToJson {
    private static Log log = LogFactory.getLog(XmlToJson.class);

    public static String parse(InputStream in) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(in);
            Element root = doc.getDocumentElement();
            XmlToJson.normalize(root);
            log.debug((Object)("The xml message is: " + DOMUtils.domToString(root)));
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(bout);
            Configuration configuration = new Configuration();
            configuration.setIgnoreNamespaces(true);
            MappedNamespaceConvention con = new MappedNamespaceConvention(configuration);
            ResultAdapter streamWriter = new ResultAdapter(con, writer);
            DOMSource source = new DOMSource(root);
            SAXResult output = new SAXResult(streamWriter);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, output);
            streamWriter.flush();
            ((Writer)writer).flush();
            return new String(bout.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException("XMLToJson failed", e);
        }
    }

    private static void normalize(Node root) {
        NodeList childNodes = root.getChildNodes();
        ArrayList<Node> tobeRemoved = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            short type = node.getNodeType();
            if (1 == type) {
                XmlToJson.normalize(node);
                continue;
            }
            if (3 != type || childNodes.getLength() <= 1) continue;
            tobeRemoved.add(node);
        }
        for (Node n : tobeRemoved) {
            root.removeChild(n);
        }
    }

    public static void main(String[] args) {
        String xml = "<message>\n  <ID>\n    <id>1</id>\n  </ID>\n  <Message>Hello World</Message>\n</message>";
        System.out.println(XmlToJson.parse(new ByteArrayInputStream(xml.getBytes())));
        String xml2 = "<message><parameters><sim:helloMessage xmlns:sim=\"http://www.jboss.org/bpel/examples/simple_correlation/\"><sim:sessionId><sim:id>12</sim:id></sim:sessionId><sim:parameter>Hello2</sim:parameter></sim:helloMessage></parameters></message>";
        System.out.println(XmlToJson.parse(new ByteArrayInputStream(xml2.getBytes())));
    }
}

