/*
 * Decompiled with CFR 0.152.
 */
package org.riftsaw.engine.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.ode.dao.bpel.BpelDAOConnection;
import org.apache.ode.dao.bpel.BpelDAOConnectionFactory;
import org.apache.ode.dao.jpa.JpaOperator;
import org.apache.ode.dao.jpa.bpel.BpelDAOConnectionImpl;
import org.apache.ode.dao.jpa.hibernate.HibernateUtil;
import org.apache.ode.dao.jpa.hibernate.JpaOperatorImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class BpelDAOConnectionFactoryImpl
implements BpelDAOConnectionFactory {
    private JpaOperator _operator = new JpaOperatorImpl();
    private EntityManagerFactory _emf;
    private TransactionManager _txm;
    private DataSource _ds;
    private ServiceRegistration _reg;

    @Override
    public void init(Properties odeConfig, TransactionManager txm, Object env) {
        this._txm = txm;
        this._ds = (DataSource)env;
        Bundle thisBundle = FrameworkUtil.getBundle(this.getClass());
        BundleContext context = thisBundle.getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(PersistenceProvider.class.getName());
        PersistenceProvider persistenceProvider = (PersistenceProvider)context.getService(serviceReference);
        Map emfProperties = HibernateUtil.buildConfig("dao.factory.", odeConfig, this._txm, this._ds);
        this._emf = persistenceProvider.createEntityManagerFactory("ode-bpel", emfProperties);
        odeConfig.put("ode.emf", this._emf);
        Hashtable<String, Boolean> serviceProperties = new Hashtable<String, Boolean>();
        ((Dictionary)serviceProperties).put("ode.emf", true);
        this._reg = context.registerService(EntityManagerFactory.class.getName(), (Object)this._emf, serviceProperties);
    }

    @Override
    public BpelDAOConnection getConnection() {
        ThreadLocal<BpelDAOConnectionImpl> currentConnection = BpelDAOConnectionImpl.getThreadLocal();
        BpelDAOConnectionImpl conn = currentConnection.get();
        if (conn != null && HibernateUtil.isOpen(conn)) {
            return conn;
        }
        EntityManager em = this._emf.createEntityManager();
        conn = new BpelDAOConnectionImpl(em, this._txm, this._operator);
        currentConnection.set(conn);
        return conn;
    }

    @Override
    public void shutdown() {
        try {
            this._reg.unregister();
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        this._emf.close();
    }
}

