/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.spi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.Callable;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.xbean.osgi.bundle.util.DelegatingBundle;
import org.ops4j.lang.Ops4jException;
import org.ops4j.pax.cdi.api.ContainerInitialized;
import org.ops4j.pax.cdi.api.ServicesPublished;
import org.ops4j.pax.cdi.spi.BeanBundles;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.ops4j.pax.cdi.spi.CdiContainerType;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.ops4j.pax.swissbox.core.ContextClassLoaderUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCdiContainer
implements CdiContainer {
    private static Logger log = LoggerFactory.getLogger(AbstractCdiContainer.class);
    private Bundle bundle;
    private CdiContainerType containerType;
    private ServiceRegistration<CdiContainer> cdiContainerReg;
    private ServiceRegistration<BeanManager> beanManagerReg;
    private boolean started;
    private Collection<Bundle> extensionBundles;
    private Collection<Bundle> additionalBundles;
    private BundleClassLoader contextClassLoader;

    protected AbstractCdiContainer(CdiContainerType containerType, Bundle bundle, Collection<Bundle> extensionBundles, Collection<Bundle> additionalBundles) {
        this.containerType = containerType;
        this.bundle = bundle;
        this.extensionBundles = extensionBundles;
        this.additionalBundles = additionalBundles;
    }

    @Override
    public synchronized void start(Object environment) {
        if (!this.started) {
            log.info("Starting CDI container for bundle {}", (Object)this.getBundle());
            this.doStart(environment);
            BeanBundles.addBundle(this.getContextClassLoader(), this.getBundle());
            this.finishStartup();
            this.started = true;
        }
    }

    @Override
    public synchronized void stop() {
        if (this.started) {
            log.info("Stopping CDI container for bundle {}", (Object)this.getBundle());
            BeanBundles.removeBundle(this.getContextClassLoader(), this.getBundle());
            this.doStop();
            this.unregister(this.cdiContainerReg);
            this.unregister(this.beanManagerReg);
            this.started = false;
        }
    }

    private <S> void unregister(ServiceRegistration<S> registration) {
        if (registration != null) {
            try {
                registration.unregister();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected abstract void doStart(Object var1);

    protected abstract void doStop();

    protected void buildContextClassLoader() {
        ArrayList<Bundle> delegateBundles = new ArrayList<Bundle>();
        delegateBundles.add(this.bundle);
        delegateBundles.addAll(this.additionalBundles);
        delegateBundles.addAll(this.extensionBundles);
        DelegatingBundle delegatingBundle = new DelegatingBundle(delegateBundles);
        this.contextClassLoader = new BundleClassLoader((Bundle)delegatingBundle);
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    protected void finishStartup() {
        try {
            this.cdiContainerReg = (ServiceRegistration)ContextClassLoaderUtils.doWithClassLoader((ClassLoader)this.getContextClassLoader(), (Callable)new Callable<ServiceRegistration<CdiContainer>>(){

                @Override
                public ServiceRegistration<CdiContainer> call() throws Exception {
                    BundleContext bc = AbstractCdiContainer.this.bundle.getBundleContext();
                    BeanManager beanManager = AbstractCdiContainer.this.getBeanManager();
                    beanManager.fireEvent((Object)new ContainerInitialized(), new Annotation[0]);
                    Hashtable<String, Object> props = new Hashtable<String, Object>();
                    ((Dictionary)props).put("bundleId", AbstractCdiContainer.this.bundle.getBundleId());
                    ((Dictionary)props).put("symbolicName", AbstractCdiContainer.this.bundle.getSymbolicName());
                    ServiceRegistration reg = bc.registerService(CdiContainer.class, (Object)AbstractCdiContainer.this, props);
                    AbstractCdiContainer.this.beanManagerReg = bc.registerService(BeanManager.class, (Object)AbstractCdiContainer.this.getBeanManager(), props);
                    beanManager.fireEvent((Object)new ServicesPublished(), new Annotation[0]);
                    return reg;
                }
            });
        }
        catch (Exception exc) {
            log.error("", (Throwable)exc);
            throw new Ops4jException((Throwable)exc);
        }
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public CdiContainerType getContainerType() {
        return this.containerType;
    }
}

