/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.partition;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.partition.PartitionBrokerPlugin;
import org.apache.activemq.partition.dto.Partitioning;
import org.apache.activemq.partition.dto.Target;
import org.apache.activemq.state.ConsumerState;
import org.apache.activemq.state.SessionState;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.util.LRUCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionBroker
extends BrokerFilter {
    protected static final Logger LOG = LoggerFactory.getLogger(PartitionBroker.class);
    protected final PartitionBrokerPlugin plugin;
    protected boolean reloadConfigOnPoll = true;
    protected final ConcurrentHashMap<ConnectionId, ConnectionMonitor> monitors = new ConcurrentHashMap();

    public PartitionBroker(Broker broker, PartitionBrokerPlugin plugin) {
        super(broker);
        this.plugin = plugin;
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("Partition Monitor");
                PartitionBroker.this.onMonitorStart();
                try {
                    PartitionBroker.this.runPartitionMonitor();
                }
                catch (Exception e) {
                    PartitionBroker.this.onMonitorStop();
                }
            }
        });
    }

    protected void onMonitorStart() {
    }

    protected void onMonitorStop() {
    }

    protected void runPartitionMonitor() {
        while (!this.isStopped()) {
            try {
                this.monitorWait();
            }
            catch (InterruptedException e) {
                break;
            }
            if (this.reloadConfigOnPoll) {
                try {
                    this.reloadConfiguration();
                }
                catch (Exception e) {
                    continue;
                }
            }
            for (ConnectionMonitor monitor : this.monitors.values()) {
                this.checkTarget(monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void monitorWait() throws InterruptedException {
        PartitionBroker partitionBroker = this;
        synchronized (partitionBroker) {
            this.wait(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void monitorWakeup() {
        PartitionBroker partitionBroker = this;
        synchronized (partitionBroker) {
            this.notifyAll();
        }
    }

    protected void reloadConfiguration() throws Exception {
    }

    protected void checkTarget(ConnectionMonitor monitor) {
        Target targetDTO = this.pickBestBroker(monitor);
        if (targetDTO == null || targetDTO.ids == null) {
            LOG.debug("No partition target found for connection: " + monitor.context.getConnectionId());
            return;
        }
        if (targetDTO.ids.contains(this.getBrokerName())) {
            LOG.debug("We are a partition target for connection: " + monitor.context.getConnectionId());
            return;
        }
        String connectionString = this.getConnectionString(targetDTO.ids);
        if (connectionString == null) {
            LOG.debug("Could not convert to partition targets to connection string: " + targetDTO.ids);
            return;
        }
        LOG.info("Redirecting connection to: " + connectionString);
        TransportConnection connection = (TransportConnection)monitor.context.getConnection();
        ConnectionControl cc = new ConnectionControl();
        cc.setConnectedBrokers(connectionString);
        cc.setRebalanceConnection(true);
        connection.dispatchAsync(cc);
    }

    protected String getConnectionString(HashSet<String> ids) {
        StringBuilder rc = new StringBuilder();
        for (String id : ids) {
            String url = this.plugin.getBrokerURL(this, id);
            if (url == null) continue;
            if (rc.length() != 0) {
                rc.append(',');
            }
            rc.append(url);
        }
        if (rc.length() == 0) {
            return null;
        }
        return rc.toString();
    }

    protected Target pickBestBroker(ConnectionMonitor monitor) {
        String clientId;
        Target targetDTO;
        String userName;
        String ip;
        Target targetDTO2;
        SocketAddress address;
        TransportConnection connection;
        Transport transport;
        Socket socket;
        if (this.getConfig() == null) {
            return null;
        }
        if (this.getConfig().bySourceIp != null && !this.getConfig().bySourceIp.isEmpty() && (socket = (transport = (connection = (TransportConnection)monitor.context.getConnection()).getTransport()).narrow(Socket.class)) != null && (address = socket.getRemoteSocketAddress()) instanceof InetSocketAddress && (targetDTO2 = this.getConfig().bySourceIp.get(ip = ((InetSocketAddress)address).getAddress().getHostAddress())) != null) {
            return targetDTO2;
        }
        if (this.getConfig().byUserName != null && !this.getConfig().byUserName.isEmpty() && (userName = monitor.context.getUserName()) != null && (targetDTO = this.getConfig().byUserName.get(userName)) != null) {
            return targetDTO;
        }
        if (this.getConfig().byClientId != null && !this.getConfig().byClientId.isEmpty() && (clientId = monitor.context.getClientId()) != null && (targetDTO = this.getConfig().byClientId.get(clientId)) != null) {
            return targetDTO;
        }
        if (this.getConfig().byQueue != null && !this.getConfig().byQueue.isEmpty() || this.getConfig().byTopic != null && !this.getConfig().byTopic.isEmpty()) {
            HashSet<ActiveMQDestination> dests = new HashSet<ActiveMQDestination>();
            for (SessionState session : monitor.context.getConnectionState().getSessionStates()) {
                for (ConsumerState consumer : session.getConsumerStates()) {
                    ActiveMQDestination destination = consumer.getInfo().getDestination();
                    if (destination.isComposite()) {
                        dests.addAll(Arrays.asList(destination.getCompositeDestinations()));
                        continue;
                    }
                    dests.addAll(Collections.singletonList(destination));
                }
            }
            HashMap<Target, Score> targetScores = new HashMap<Target, Score>();
            for (ActiveMQDestination dest : dests) {
                Target target = this.getTarget(dest);
                if (target == null) continue;
                Score score = (Score)targetScores.get(target);
                if (score == null) {
                    score = new Score();
                    targetScores.put(target, score);
                }
                ++score.value;
            }
            if (!targetScores.isEmpty()) {
                Target bestTarget = null;
                int bestScore = 0;
                for (Map.Entry entry : targetScores.entrySet()) {
                    if (((Score)entry.getValue()).value <= bestScore) continue;
                    bestTarget = (Target)entry.getKey();
                }
                return bestTarget;
            }
            Target best = monitor.findBestProducerTarget(this);
            if (best != null) {
                return best;
            }
        }
        return null;
    }

    protected Target getTarget(ActiveMQDestination dest) {
        Partitioning config = this.getConfig();
        if (dest.isQueue() && config.byQueue != null && !config.byQueue.isEmpty()) {
            return config.byQueue.get(dest.getPhysicalName());
        }
        if (dest.isTopic() && config.byTopic != null && !config.byTopic.isEmpty()) {
            return config.byTopic.get(dest.getPhysicalName());
        }
        return null;
    }

    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        if (info.isFaultTolerant()) {
            ConnectionMonitor monitor = new ConnectionMonitor(context);
            this.monitors.put(info.getConnectionId(), monitor);
            super.addConnection(context, info);
            this.checkTarget(monitor);
        } else {
            super.addConnection(context, info);
        }
    }

    @Override
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        super.removeConnection(context, info, error);
        if (info.isFaultTolerant()) {
            this.monitors.remove(info.getConnectionId());
        }
    }

    @Override
    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        ConnectionMonitor monitor = this.monitors.get(producerExchange.getConnectionContext().getConnectionId());
        if (monitor != null) {
            monitor.onSend(producerExchange, messageSend);
        }
    }

    protected Partitioning getConfig() {
        return this.plugin.getConfig();
    }

    static class ConnectionMonitor {
        final ConnectionContext context;
        LRUCache<ActiveMQDestination, Traffic> trafficPerDestination = new LRUCache();

        public ConnectionMonitor(ConnectionContext context) {
            this.context = context;
        }

        public synchronized Target findBestProducerTarget(PartitionBroker broker) {
            Target best = null;
            long bestSize = 0L;
            for (Map.Entry entry : this.trafficPerDestination.entrySet()) {
                Traffic t = (Traffic)entry.getValue();
                if (t.messages < (long)broker.plugin.getMinTransferCount() || t.bytes <= bestSize) continue;
                bestSize = t.bytes;
                Target target = broker.getTarget((ActiveMQDestination)entry.getKey());
                if (target == null) continue;
                best = target;
            }
            return best;
        }

        public synchronized void onSend(ProducerBrokerExchange producerExchange, Message message) {
            ActiveMQDestination dest = message.getDestination();
            Traffic traffic = (Traffic)this.trafficPerDestination.get(dest);
            if (traffic == null) {
                traffic = new Traffic();
                this.trafficPerDestination.put(dest, traffic);
            }
            ++traffic.messages;
            traffic.bytes += (long)message.getSize();
        }
    }

    static class Traffic {
        long messages;
        long bytes;

        Traffic() {
        }
    }

    private static class Score {
        int value;

        private Score() {
        }
    }
}

