/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdispatch.transport.AbstractProtocolCodec;
import org.fusesource.hawtdispatch.util.BufferPools;
import org.fusesource.mqtt.codec.MQTTFrame;

public class MQTTProtocolCodec
extends AbstractProtocolCodec {
    private static final BufferPools BUFFER_POOLS = new BufferPools();
    private int maxMessageLength = 0x6400000;
    private final AbstractProtocolCodec.Action readHeader = new AbstractProtocolCodec.Action(){

        public MQTTFrame apply() throws IOException {
            int length = MQTTProtocolCodec.this.readLength(MQTTProtocolCodec.this.readBuffer, MQTTProtocolCodec.this.readStart + 1);
            if (length >= 0) {
                if (length > MQTTProtocolCodec.this.maxMessageLength) {
                    throw new IOException("The maximum message length was exceeded");
                }
                byte header = MQTTProtocolCodec.this.readBuffer.get(MQTTProtocolCodec.this.readStart);
                MQTTProtocolCodec.this.readStart = MQTTProtocolCodec.this.readEnd;
                if (length > 0) {
                    MQTTProtocolCodec.this.nextDecodeAction = MQTTProtocolCodec.this.readBody(header, length);
                } else {
                    return new MQTTFrame().header(header);
                }
            }
            return null;
        }
    };

    public MQTTProtocolCodec() {
        this.bufferPools = BUFFER_POOLS;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public void setMaxMessageLength(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    protected void encode(Object value) throws IOException {
        MQTTFrame frame = (MQTTFrame)value;
        this.nextWriteBuffer.write(frame.header());
        int remaining = 0;
        for (Buffer buffer : frame.buffers) {
            remaining += buffer.length;
        }
        do {
            byte digit = (byte)(remaining & 0x7F);
            if ((remaining >>>= 7) > 0) {
                digit = (byte)(digit | 0x80);
            }
            this.nextWriteBuffer.write(digit);
        } while (remaining > 0);
        for (Buffer buffer : frame.buffers) {
            this.nextWriteBuffer.write(buffer.data, buffer.offset, buffer.length);
        }
    }

    protected AbstractProtocolCodec.Action initialDecodeAction() {
        return this.readHeader;
    }

    int readLength(ByteBuffer buffer, int pos) throws IOException {
        int limit = buffer.position();
        int length = 0;
        int multiplier = 1;
        while (pos < limit) {
            byte digit = buffer.get(pos);
            length += (digit & 0x7F) * multiplier;
            if ((digit & 0x80) == 0) {
                this.readEnd = pos + 1;
                return length;
            }
            multiplier <<= 7;
            ++pos;
        }
        return -1;
    }

    AbstractProtocolCodec.Action readBody(final byte header, final int length) {
        return new AbstractProtocolCodec.Action(){

            public MQTTFrame apply() throws IOException {
                int limit = MQTTProtocolCodec.this.readBuffer.position();
                if (limit - MQTTProtocolCodec.this.readStart < length) {
                    MQTTProtocolCodec.this.readEnd = limit;
                    return null;
                }
                Buffer body = new Buffer(MQTTProtocolCodec.this.readBuffer.array(), MQTTProtocolCodec.this.readStart, length);
                MQTTProtocolCodec.this.readEnd = MQTTProtocolCodec.this.readStart + length;
                MQTTProtocolCodec.this.readStart = MQTTProtocolCodec.this.readEnd;
                MQTTProtocolCodec.this.nextDecodeAction = MQTTProtocolCodec.this.readHeader;
                return new MQTTFrame(body).header(header);
            }
        };
    }
}

