/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.codec;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQDataBlockDecoder;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBodyFactory;
import org.apache.qpid.framing.AMQProtocolVersionException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ByteArrayDataInput;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.ProtocolInitiation;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;

public class AMQDecoder {
    private AMQDataBlockDecoder _dataBlockDecoder = new AMQDataBlockDecoder();
    private ProtocolInitiation.Decoder _piDecoder = new ProtocolInitiation.Decoder();
    private boolean _expectProtocolInitiation;
    private AMQMethodBodyFactory _bodyFactory;
    private List<ByteArrayInputStream> _remainingBufs = new ArrayList<ByteArrayInputStream>();

    public AMQDecoder(boolean expectProtocolInitiation, AMQVersionAwareProtocolSession session) {
        this._expectProtocolInitiation = expectProtocolInitiation;
        this._bodyFactory = new AMQMethodBodyFactory(session);
    }

    public void setExpectProtocolInitiation(boolean expectProtocolInitiation) {
        this._expectProtocolInitiation = expectProtocolInitiation;
    }

    public ArrayList<AMQDataBlock> decodeBuffer(ByteBuffer buf) throws AMQFrameDecodingException, AMQProtocolVersionException, IOException {
        MarkableDataInput msg;
        ByteArrayInputStream bais;
        ArrayList<AMQDataBlock> dataBlocks = new ArrayList<AMQDataBlock>();
        if (!this._remainingBufs.isEmpty()) {
            bais = new ByteArrayInputStream(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
            this._remainingBufs.add(bais);
            msg = new SimpleDataInputStream(new RemainingByteArrayInputStream());
        } else {
            bais = null;
            msg = new ByteArrayDataInput(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
        }
        boolean enoughData = true;
        while (enoughData) {
            byte[] remaining;
            if (!this._expectProtocolInitiation) {
                enoughData = this._dataBlockDecoder.decodable(msg);
                if (enoughData) {
                    dataBlocks.add(this._dataBlockDecoder.createAndPopulateFrame(this._bodyFactory, msg));
                }
            } else {
                enoughData = this._piDecoder.decodable(msg);
                if (enoughData) {
                    dataBlocks.add(new ProtocolInitiation(msg));
                }
            }
            if (enoughData) continue;
            if (!this._remainingBufs.isEmpty()) {
                this._remainingBufs.remove(this._remainingBufs.size() - 1);
                ListIterator<ByteArrayInputStream> iterator = this._remainingBufs.listIterator();
                while (iterator.hasNext() && iterator.next().available() == 0) {
                    iterator.remove();
                }
            }
            if (bais == null) {
                if (msg.available() == 0) continue;
                remaining = new byte[msg.available()];
                msg.read(remaining);
                this._remainingBufs.add(new ByteArrayInputStream(remaining));
                continue;
            }
            if (bais.available() == 0) continue;
            remaining = new byte[bais.available()];
            bais.read(remaining);
            this._remainingBufs.add(new ByteArrayInputStream(remaining));
        }
        return dataBlocks;
    }

    private static class SimpleDataInputStream
    extends DataInputStream
    implements MarkableDataInput {
        public SimpleDataInputStream(InputStream in) {
            super(in);
        }

        @Override
        public AMQShortString readAMQShortString() throws IOException {
            return EncodingUtils.readAMQShortString(this);
        }
    }

    private class RemainingByteArrayInputStream
    extends InputStream {
        private int _currentListPos;
        private int _markPos;

        private RemainingByteArrayInputStream() {
        }

        @Override
        public int read() throws IOException {
            ByteArrayInputStream currentStream = (ByteArrayInputStream)AMQDecoder.this._remainingBufs.get(this._currentListPos);
            if (currentStream.available() > 0) {
                return currentStream.read();
            }
            if (this._currentListPos == AMQDecoder.this._remainingBufs.size() || ++this._currentListPos == AMQDecoder.this._remainingBufs.size()) {
                return -1;
            }
            ByteArrayInputStream stream = (ByteArrayInputStream)AMQDecoder.this._remainingBufs.get(this._currentListPos);
            stream.mark(0);
            return stream.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            ByteArrayInputStream currentStream;
            if (this._currentListPos == AMQDecoder.this._remainingBufs.size()) {
                return -1;
            }
            int available = (currentStream = (ByteArrayInputStream)AMQDecoder.this._remainingBufs.get(this._currentListPos)).available();
            int read = currentStream.read(b, off, len > available ? available : len);
            if (read < len) {
                int correctRead;
                int subRead;
                if (this._currentListPos++ != AMQDecoder.this._remainingBufs.size()) {
                    ((ByteArrayInputStream)AMQDecoder.this._remainingBufs.get(this._currentListPos)).mark(0);
                }
                if ((subRead = this.read(b, off + (correctRead = read == -1 ? 0 : read), len - correctRead)) == -1) {
                    return read;
                }
                return correctRead + subRead;
            }
            return len;
        }

        @Override
        public int available() throws IOException {
            int total = 0;
            for (int i = this._currentListPos; i < AMQDecoder.this._remainingBufs.size(); ++i) {
                total += ((ByteArrayInputStream)AMQDecoder.this._remainingBufs.get(i)).available();
            }
            return total;
        }

        @Override
        public void mark(int readlimit) {
            this._markPos = this._currentListPos;
            ByteArrayInputStream stream = (ByteArrayInputStream)AMQDecoder.this._remainingBufs.get(this._currentListPos);
            if (stream != null) {
                stream.mark(readlimit);
            }
        }

        @Override
        public void reset() throws IOException {
            this._currentListPos = this._markPos;
            int size = AMQDecoder.this._remainingBufs.size();
            if (this._currentListPos < size) {
                ((ByteArrayInputStream)AMQDecoder.this._remainingBufs.get(this._currentListPos)).reset();
            }
            for (int i = this._currentListPos + 1; i < size; ++i) {
                ((ByteArrayInputStream)AMQDecoder.this._remainingBufs.get(i)).reset();
            }
        }
    }
}

