/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.DtxStartBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class DtxStartBodyImpl
extends AMQMethodBody_0_9
implements DtxStartBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new DtxStartBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 100;
    public static final int METHOD_ID = 20;
    private final AMQShortString _dtxIdentifier;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public DtxStartBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._dtxIdentifier = this.readAMQShortString(buffer);
    }

    public DtxStartBodyImpl(AMQShortString dtxIdentifier) {
        this._dtxIdentifier = dtxIdentifier;
    }

    @Override
    public int getClazz() {
        return 100;
    }

    @Override
    public int getMethod() {
        return 20;
    }

    @Override
    public final AMQShortString getDtxIdentifier() {
        return this._dtxIdentifier;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        return size += this.getSizeOf(this._dtxIdentifier);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeAMQShortString(buffer, this._dtxIdentifier);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchDtxStart(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[DtxStartBodyImpl: ");
        buf.append("dtxIdentifier=");
        buf.append(this.getDtxIdentifier());
        buf.append("]");
        return buf.toString();
    }
}

