/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FileOpenBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class FileOpenBodyImpl
extends AMQMethodBody_0_9
implements FileOpenBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new FileOpenBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 70;
    public static final int METHOD_ID = 40;
    private final AMQShortString _identifier;
    private final long _contentSize;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public FileOpenBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._identifier = this.readAMQShortString(buffer);
        this._contentSize = this.readLong(buffer);
    }

    public FileOpenBodyImpl(AMQShortString identifier, long contentSize) {
        this._identifier = identifier;
        this._contentSize = contentSize;
    }

    @Override
    public int getClazz() {
        return 70;
    }

    @Override
    public int getMethod() {
        return 40;
    }

    @Override
    public final AMQShortString getIdentifier() {
        return this._identifier;
    }

    @Override
    public final long getContentSize() {
        return this._contentSize;
    }

    @Override
    protected int getBodySize() {
        int size = 8;
        return size += this.getSizeOf(this._identifier);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeAMQShortString(buffer, this._identifier);
        this.writeLong(buffer, this._contentSize);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchFileOpen(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[FileOpenBodyImpl: ");
        buf.append("identifier=");
        buf.append(this.getIdentifier());
        buf.append(", ");
        buf.append("contentSize=");
        buf.append(this.getContentSize());
        buf.append("]");
        return buf.toString();
    }
}

