/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ConnectionRedirectBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class ConnectionRedirectBodyImpl
extends AMQMethodBody_8_0
implements ConnectionRedirectBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new ConnectionRedirectBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 50;
    private final AMQShortString _host;
    private final AMQShortString _knownHosts;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ConnectionRedirectBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._host = this.readAMQShortString(buffer);
        this._knownHosts = this.readAMQShortString(buffer);
    }

    public ConnectionRedirectBodyImpl(AMQShortString host, AMQShortString knownHosts) {
        this._host = host;
        this._knownHosts = knownHosts;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return 50;
    }

    @Override
    public final AMQShortString getHost() {
        return this._host;
    }

    @Override
    public final AMQShortString getKnownHosts() {
        return this._knownHosts;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        size += this.getSizeOf(this._host);
        return size += this.getSizeOf(this._knownHosts);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeAMQShortString(buffer, this._host);
        this.writeAMQShortString(buffer, this._knownHosts);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchConnectionRedirect(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionRedirectBodyImpl: ");
        buf.append("host=");
        buf.append(this.getHost());
        buf.append(", ");
        buf.append("knownHosts=");
        buf.append(this.getKnownHosts());
        buf.append("]");
        return buf.toString();
    }
}

