/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ConnectionStartOkBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class ConnectionStartOkBodyImpl
extends AMQMethodBody_8_0
implements ConnectionStartOkBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new ConnectionStartOkBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 11;
    private final FieldTable _clientProperties;
    private final AMQShortString _mechanism;
    private final byte[] _response;
    private final AMQShortString _locale;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ConnectionStartOkBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._clientProperties = this.readFieldTable(buffer);
        this._mechanism = this.readAMQShortString(buffer);
        this._response = this.readBytes(buffer);
        this._locale = this.readAMQShortString(buffer);
    }

    public ConnectionStartOkBodyImpl(FieldTable clientProperties, AMQShortString mechanism, byte[] response, AMQShortString locale) {
        this._clientProperties = clientProperties;
        this._mechanism = mechanism;
        this._response = response;
        this._locale = locale;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return 11;
    }

    @Override
    public final FieldTable getClientProperties() {
        return this._clientProperties;
    }

    @Override
    public final AMQShortString getMechanism() {
        return this._mechanism;
    }

    @Override
    public final byte[] getResponse() {
        return this._response;
    }

    @Override
    public final AMQShortString getLocale() {
        return this._locale;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        size += this.getSizeOf(this._clientProperties);
        size += this.getSizeOf(this._mechanism);
        size += this.getSizeOf(this._response);
        return size += this.getSizeOf(this._locale);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeFieldTable(buffer, this._clientProperties);
        this.writeAMQShortString(buffer, this._mechanism);
        this.writeBytes(buffer, this._response);
        this.writeAMQShortString(buffer, this._locale);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchConnectionStartOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionStartOkBodyImpl: ");
        buf.append("clientProperties=");
        buf.append(this.getClientProperties());
        buf.append(", ");
        buf.append("mechanism=");
        buf.append(this.getMechanism());
        buf.append(", ");
        buf.append("response=");
        buf.append(this.getResponse() == null ? "null" : Arrays.toString(this.getResponse()));
        buf.append(", ");
        buf.append("locale=");
        buf.append(this.getLocale());
        buf.append("]");
        return buf.toString();
    }
}

