/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

public enum ExecutionErrorCode {
    UNAUTHORIZED_ACCESS(403),
    NOT_FOUND(404),
    RESOURCE_LOCKED(405),
    PRECONDITION_FAILED(406),
    RESOURCE_DELETED(408),
    ILLEGAL_STATE(409),
    COMMAND_INVALID(503),
    RESOURCE_LIMIT_EXCEEDED(506),
    NOT_ALLOWED(530),
    ILLEGAL_ARGUMENT(531),
    NOT_IMPLEMENTED(540),
    INTERNAL_ERROR(541),
    INVALID_ARGUMENT(542);

    private final int value;

    private ExecutionErrorCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ExecutionErrorCode get(int value) {
        switch (value) {
            case 403: {
                return UNAUTHORIZED_ACCESS;
            }
            case 404: {
                return NOT_FOUND;
            }
            case 405: {
                return RESOURCE_LOCKED;
            }
            case 406: {
                return PRECONDITION_FAILED;
            }
            case 408: {
                return RESOURCE_DELETED;
            }
            case 409: {
                return ILLEGAL_STATE;
            }
            case 503: {
                return COMMAND_INVALID;
            }
            case 506: {
                return RESOURCE_LIMIT_EXCEEDED;
            }
            case 530: {
                return NOT_ALLOWED;
            }
            case 531: {
                return ILLEGAL_ARGUMENT;
            }
            case 540: {
                return NOT_IMPLEMENTED;
            }
            case 541: {
                return INTERNAL_ERROR;
            }
            case 542: {
                return INVALID_ARGUMENT;
            }
        }
        throw new IllegalArgumentException("no such value: " + value);
    }
}

