/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.context.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;
import org.apache.aries.jpa.container.context.impl.NLS;
import org.apache.aries.jpa.container.context.impl.PersistenceContextManager;
import org.apache.aries.jpa.container.context.transaction.impl.DestroyCallback;
import org.apache.aries.jpa.container.context.transaction.impl.JTAEntityManagerClose;
import org.apache.aries.jpa.container.context.transaction.impl.JTAEntityManagerHandler;
import org.apache.aries.jpa.container.context.transaction.impl.JTAPersistenceContextRegistry;
import org.apache.aries.jpa.container.sync.Synchronization;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedPersistenceContextFactory
implements Synchronization,
EntityManagerFactory,
DestroyCallback {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container.context");
    private final ServiceReference emf;
    private final Map<String, Object> properties;
    private final JTAPersistenceContextRegistry registry;
    private final PersistenceContextType type;
    private final AtomicLong activeCount = new AtomicLong(0L);
    private final String unitName;
    private final EntityManager em;
    private final AtomicReference<PersistenceContextManager.QuiesceTidyUp> tidyUp = new AtomicReference();

    public ManagedPersistenceContextFactory(String name, ServiceReference unit, Map<String, Object> props, JTAPersistenceContextRegistry contextRegistry) {
        this.unitName = name;
        this.emf = unit;
        this.properties = new HashMap<String, Object>(props);
        this.registry = contextRegistry;
        this.type = (PersistenceContextType)this.properties.remove("org.apache.aries.jpa.context.type");
        EntityManagerFactory factory = AccessController.doPrivileged(new PrivilegedAction<EntityManagerFactory>(){

            @Override
            public EntityManagerFactory run() {
                return (EntityManagerFactory)ManagedPersistenceContextFactory.this.emf.getBundle().getBundleContext().getService(ManagedPersistenceContextFactory.this.emf);
            }
        });
        JTAEntityManagerHandler invocationHandler = new JTAEntityManagerHandler(factory, this.properties, this.registry, this.activeCount, this);
        ClassLoader cl = this.getClass().getClassLoader();
        Class[] ifAr = new Class[]{Synchronization.class, EntityManager.class, JTAEntityManagerClose.class};
        this.em = (EntityManager)Proxy.newProxyInstance(cl, ifAr, (InvocationHandler)invocationHandler);
    }

    public EntityManager createEntityManager() {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Creating a container managed entity manager for the perstence unit {} with the following properties {}", new Object[]{this.emf, this.properties});
        }
        if (this.type == PersistenceContextType.TRANSACTION || this.type == null) {
            return this.em;
        }
        _logger.error(NLS.MESSAGES.getMessage("extended.em.not.supported", new Object[0]));
        return null;
    }

    public void preCall() {
        ((Synchronization)this.em).preCall();
    }

    public void postCall() {
        ((Synchronization)this.em).postCall();
    }

    public void close() {
        throw new UnsupportedOperationException();
    }

    public EntityManager createEntityManager(Map arg0) {
        throw new UnsupportedOperationException();
    }

    public Cache getCache() {
        throw new UnsupportedOperationException();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        throw new UnsupportedOperationException();
    }

    public Metamodel getMetamodel() {
        throw new UnsupportedOperationException();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> getProperties() {
        throw new UnsupportedOperationException();
    }

    public boolean isOpen() {
        throw new UnsupportedOperationException();
    }

    public void quiesce(PersistenceContextManager.QuiesceTidyUp tidyUp) {
        this.tidyUp.compareAndSet(null, tidyUp);
        if (this.activeCount.get() == 0L) {
            tidyUp.unitQuiesced(this.unitName);
        }
    }

    @Override
    public void callback() {
        if (this.tidyUp.get() != null && this.activeCount.get() == 0L) {
            this.tidyUp.get().unitQuiesced(this.unitName);
        }
    }

    public void addNamedQuery(String arg0, Query arg1) {
        throw new UnsupportedOperationException();
    }

    public <T> T unwrap(Class<T> arg0) {
        throw new UnsupportedOperationException();
    }
}

