/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.jco.JCoIDoc;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SapIDocDestinationEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SapIDocDestinationEndpoint.class);
    protected String idocType;
    protected String idocTypeExtension;
    protected String systemRelease;
    protected String applicationRelease;
    protected String destinationName;
    protected JCoDestination destination;

    public SapIDocDestinationEndpoint() {
    }

    public SapIDocDestinationEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Endpoint '" + this.getEndpointUri() + "' does not support consumers");
    }

    public boolean isSingleton() {
        return true;
    }

    public String getIdocType() {
        return this.idocType;
    }

    public void setIdocType(String idocType) {
        this.idocType = idocType;
    }

    public String getIdocTypeExtension() {
        return this.idocTypeExtension;
    }

    public void setIdocTypeExtension(String idocTypeExtension) {
        this.idocTypeExtension = idocTypeExtension;
    }

    public String getSystemRelease() {
        return this.systemRelease;
    }

    public void setSystemRelease(String systemRelease) {
        this.systemRelease = systemRelease;
    }

    public String getApplicationRelease() {
        return this.applicationRelease;
    }

    public void setApplicationRelease(String applicationRelease) {
        this.applicationRelease = applicationRelease;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    protected IDocRepository getIDocRepository() throws Exception {
        if (this.getDestination() != null) {
            return JCoIDoc.getIDocRepository((JCoDestination)this.getDestination());
        }
        throw new Exception("Failed to get IDoc repository: no destination set of endpoint");
    }

    protected JCoDestination getDestination() {
        if (this.destination == null) {
            try {
                this.destination = JCoDestinationManager.getDestination((String)this.destinationName);
            }
            catch (Exception e) {
                LOG.warn("Failed to get destination object for endpoint '" + this.getEndpointUri() + "'. This exception will be ignored.", (Throwable)e);
            }
        }
        return this.destination;
    }
}

