/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.fusesource.camel.component.sap.SapQueuedRfcDestinationEndpoint;
import org.fusesource.camel.component.sap.SapSynchronousRfcDestinationEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapQueuedRfcDestinationComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SapQueuedRfcDestinationComponent.class);

    public SapQueuedRfcDestinationComponent() {
        super(SapSynchronousRfcDestinationEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (!uri.startsWith("sap-qrfc-destination:")) {
            throw new IllegalArgumentException("The URI '" + uri + "' has invalid scheme; should be 'sap-qrfc-destination:'");
        }
        String[] uriComponents = remaining.split(":");
        if (uriComponents.length != 3) {
            throw new IllegalArgumentException("URI must be of the form: sap-qrfc-destination:<destinationName>:<queueName>:<rfcName>");
        }
        parameters.put("destinationName", uriComponents[0]);
        parameters.put("queueName", uriComponents[1]);
        parameters.put("rfcName", uriComponents[2]);
        SapQueuedRfcDestinationEndpoint endpoint = new SapQueuedRfcDestinationEndpoint(uri, this);
        this.setProperties((Object)endpoint, parameters);
        LOG.debug("Created endpoint '" + uri + "'");
        endpoint.createRequest();
        return endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("STARTED");
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("STOPPED");
    }
}

