/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.fusesource.camel.component.sap.SapTransactionalIDocDestinationEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapTransactionalIDocDestinationComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SapTransactionalIDocDestinationComponent.class);

    public SapTransactionalIDocDestinationComponent() {
        super(SapTransactionalIDocDestinationEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (!uri.startsWith("sap-idoc-destination:")) {
            throw new IllegalArgumentException("The URI '" + uri + "' has invalid scheme; should be 'sap-idoc-destination:'");
        }
        String[] uriComponents = remaining.split(":");
        if (uriComponents.length < 2) {
            throw new IllegalArgumentException("URI must be of the form: sap-idoc-destination:<destinationName>:<idocType>[<idocTypeExtension>[<systemRelease>[<applicationRelease>]]]");
        }
        parameters.put("destinationName", uriComponents[0]);
        parameters.put("idocType", uriComponents[1]);
        if (uriComponents.length > 2) {
            parameters.put("idocTypeExtension", uriComponents[2]);
        }
        if (uriComponents.length > 3) {
            parameters.put("systemRelease", uriComponents[3]);
        }
        if (uriComponents.length > 4) {
            parameters.put("applicationRelease", uriComponents[4]);
        }
        SapTransactionalIDocDestinationEndpoint endpoint = new SapTransactionalIDocDestinationEndpoint(uri, this);
        this.setProperties((Object)endpoint, parameters);
        LOG.debug("Created endpoint '" + uri + "'");
        endpoint.createDocument();
        return endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("STARTED");
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("STOPPED");
    }
}

