/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import org.apache.camel.Component;
import org.apache.camel.Producer;
import org.apache.camel.spi.UriEndpoint;
import org.fusesource.camel.component.sap.SapIDocDestinationEndpoint;
import org.fusesource.camel.component.sap.SapTransactionalIDocListDestinationComponent;
import org.fusesource.camel.component.sap.SapTransactionalIDocListProducer;
import org.fusesource.camel.component.sap.model.idoc.DocumentList;
import org.fusesource.camel.component.sap.util.IDocUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="sap-idoclist-destination", syntax="sap-idoclist-destination:destination")
public class SapTransactionalIDocListDestinationEndpoint
extends SapIDocDestinationEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SapTransactionalIDocListDestinationEndpoint.class);

    public SapTransactionalIDocListDestinationEndpoint() {
    }

    public SapTransactionalIDocListDestinationEndpoint(String endpointUri, SapTransactionalIDocListDestinationComponent component) {
        super(endpointUri, (Component)component);
    }

    public DocumentList createDocumentList() throws Exception {
        try {
            return IDocUtil.createDocumentList(this.getIDocRepository(), this.getIdocType(), this.getIdocTypeExtension(), this.getSystemRelease(), this.getApplicationRelease());
        }
        catch (Exception e) {
            throw new Exception("Failed to get Document List from endpoint", e);
        }
    }

    public Producer createProducer() throws Exception {
        LOG.debug("Created producer for endpoint '" + this.getEndpointUri() + "'");
        return new SapTransactionalIDocListProducer(this);
    }
}

