/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.fusesource.camel.component.sap.SapConsumer;
import org.fusesource.camel.component.sap.SapTransactionalRfcServerEndpoint;
import org.fusesource.camel.component.sap.ServerTIDHandler;
import org.fusesource.camel.component.sap.model.rfc.Request;
import org.fusesource.camel.component.sap.util.RfcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapTransactionalRfcConsumer
extends SapConsumer
implements JCoServerFunctionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SapTransactionalRfcConsumer.class);
    Map<String, Object> sessionData = new HashMap<String, Object>();

    public SapTransactionalRfcConsumer(SapTransactionalRfcServerEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public SapTransactionalRfcServerEndpoint getEndpoint() {
        return (SapTransactionalRfcServerEndpoint)super.getEndpoint();
    }

    public void handleRequest(JCoServerContext serverContext, JCoFunction jcoFunction) throws AbapException, AbapClassException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling request for RFC '{}'", (Object)jcoFunction.getName());
        }
        Exchange exchange = this.getEndpoint().createExchange(ExchangePattern.InOnly);
        Request request = RfcUtil.getRequest(serverContext.getRepository(), jcoFunction.getName());
        RfcUtil.extractJCoParameterListsIntoRequest(jcoFunction, request);
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("Request: " + (request == null ? request : RfcUtil.marshal(request)));
            }
            catch (IOException e) {
                LOG.warn("Failed to log request", (Throwable)e);
            }
        }
        try {
            Message message = exchange.getIn();
            if (this.isStateful()) {
                exchange.setProperty("org.fusesource.camel.component.sap.sessionContext", (Object)this.getSessionContext());
            }
            message.setBody((Object)request);
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            if (this.getEndpoint().isPropagateExceptions()) {
                throw new AbapException("ROUTE_EXCEPTION", e.getMessage());
            }
            this.getExceptionHandler().handleException("Failed to process request", (Throwable)e);
        }
        if (exchange.getException() != null && this.getEndpoint().isPropagateExceptions()) {
            throw new AbapException("ROUTE_EXCEPTION", exchange.getException().getMessage());
        }
        JCoServerTIDHandler jcoServerTidHandler = serverContext.getServer().getTIDHandler();
        if (jcoServerTidHandler instanceof ServerTIDHandler) {
            ((ServerTIDHandler)jcoServerTidHandler).execute(serverContext);
        }
    }
}

