/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.fusesource.camel.component.sap.SapSynchronousRfcDestinationEndpoint;
import org.fusesource.camel.component.sap.SapTransactionalRfcDestinationEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapTransactionalRfcDestinationComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SapTransactionalRfcDestinationComponent.class);

    public SapTransactionalRfcDestinationComponent() {
        super(SapSynchronousRfcDestinationEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (!uri.startsWith("sap-trfc-destination:")) {
            throw new IllegalArgumentException("The URI '" + uri + "' has invalid scheme; should be 'sap-trfc-destination:'");
        }
        String[] uriComponents = remaining.split(":");
        if (uriComponents.length != 2) {
            throw new IllegalArgumentException("URI must be of the form: sap-trfc-destination:<destinationName>:<rfcName>");
        }
        parameters.put("destinationName", uriComponents[0]);
        parameters.put("rfcName", uriComponents[1]);
        SapTransactionalRfcDestinationEndpoint endpoint = new SapTransactionalRfcDestinationEndpoint(uri, this);
        this.setProperties((Object)endpoint, parameters);
        LOG.debug("Created endpoint '" + uri + "'");
        endpoint.createRequest();
        return endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("STARTED");
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("STOPPED");
    }
}

