/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.fusesource.camel.component.sap.SapRfcServerComponent;
import org.fusesource.camel.component.sap.SapTransactionalRfcServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapTransactionalRfcServerComponent
extends SapRfcServerComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SapTransactionalRfcServerComponent.class);

    public SapTransactionalRfcServerComponent() {
        super(SapTransactionalRfcServerEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (!uri.startsWith("sap-trfc-server:")) {
            throw new IllegalArgumentException("The URI '" + uri + "' has invalid scheme; should be 'sap-trfc-server:'");
        }
        String[] uriComponents = remaining.split(":");
        if (uriComponents.length != 2) {
            throw new IllegalArgumentException("URI must be of the form: sap-trfc-server:<serverName>:<rfcName>");
        }
        parameters.put("serverName", uriComponents[0]);
        parameters.put("rfcName", uriComponents[1]);
        SapTransactionalRfcServerEndpoint endpoint = new SapTransactionalRfcServerEndpoint(uri, this);
        this.setProperties((Object)endpoint, parameters);
        LOG.debug("Created endpoint '" + uri + "'");
        endpoint.createResponse();
        return endpoint;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("STARTED");
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("STOPPED");
    }
}

