/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap.model.idoc.impl;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.fusesource.camel.component.sap.model.idoc.Document;
import org.fusesource.camel.component.sap.model.idoc.DocumentList;
import org.fusesource.camel.component.sap.model.idoc.IdocFactory;
import org.fusesource.camel.component.sap.model.idoc.IdocPackage;
import org.fusesource.camel.component.sap.model.idoc.Segment;
import org.fusesource.camel.component.sap.model.idoc.impl.DocumentImpl;
import org.fusesource.camel.component.sap.model.idoc.impl.SegmentImpl;

public class DocumentListImpl
extends EObjectImpl
implements DocumentList {
    private EClass rootSegmentClass;
    protected static final String IDOC_TYPE_EDEFAULT = "";
    protected static final String IDOC_TYPE_EXTENSION_EDEFAULT = "";
    protected static final String SYSTEM_RELEASE_EDEFAULT = "";
    protected static final String APPLICATION_RELEASE_EDEFAULT = "";
    protected EList<Document> document;

    @Override
    protected EClass eStaticClass() {
        return IdocPackage.Literals.DOCUMENT_LIST;
    }

    @Override
    public String getIdocType() {
        String idocType = null;
        EAnnotation idocAnnotation = this.getRootSegmentClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            idocType = idocAnnotation.getDetails().get("idocType");
        }
        return idocType;
    }

    public void setIdocType(String newIdocType) {
    }

    @Override
    public String getIdocTypeExtension() {
        String idocTypeExtension = null;
        EAnnotation idocAnnotation = this.getRootSegmentClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            idocTypeExtension = idocAnnotation.getDetails().get("idocTypeExtension");
        }
        return idocTypeExtension;
    }

    public void setIdocTypeExtension(String newIdocTypeExtension) {
    }

    @Override
    public String getSystemRelease() {
        String systemRelease = null;
        EAnnotation idocAnnotation = this.getRootSegmentClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            systemRelease = idocAnnotation.getDetails().get("systemRelease");
        }
        return systemRelease;
    }

    public void setSystemRelease(String newSystemRelease) {
    }

    @Override
    public String getApplicationRelease() {
        String applicationRelease = null;
        EAnnotation idocAnnotation = this.getRootSegmentClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            applicationRelease = idocAnnotation.getDetails().get("applicationRelease");
        }
        return applicationRelease;
    }

    public void setApplicationRelease(String newApplicationRelease) {
    }

    public EList<Document> getDocument() {
        if (this.document == null) {
            this.document = new EObjectContainmentEList<Document>(Document.class, this, 4);
        }
        return this.document;
    }

    public EClass getRootSegmentClass() {
        if (this.rootSegmentClass == null && this.document.size() > 0) {
            this.rootSegmentClass = ((Document)this.document.get(0)).getRootSegment().eClass();
        }
        return this.rootSegmentClass;
    }

    public void setRootSegmentClass(EClass rootSegmentClass) {
        this.rootSegmentClass = rootSegmentClass;
    }

    @Override
    public Document add() {
        Document document = this.createIDoc();
        this.add(document);
        return document;
    }

    @Override
    public Document add(int index) {
        Document document = this.createIDoc();
        this.add(index, document);
        return document;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getDocument()).basicRemove(otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getIdocType();
            }
            case 1: {
                return this.getIdocTypeExtension();
            }
            case 2: {
                return this.getSystemRelease();
            }
            case 3: {
                return this.getApplicationRelease();
            }
            case 4: {
                return this.getDocument();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setIdocType((String)newValue);
                return;
            }
            case 1: {
                this.setIdocTypeExtension((String)newValue);
                return;
            }
            case 2: {
                this.setSystemRelease((String)newValue);
                return;
            }
            case 3: {
                this.setApplicationRelease((String)newValue);
                return;
            }
            case 4: {
                this.getDocument().clear();
                this.getDocument().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setIdocType("");
                return;
            }
            case 1: {
                this.setIdocTypeExtension("");
                return;
            }
            case 2: {
                this.setSystemRelease("");
                return;
            }
            case 3: {
                this.setApplicationRelease("");
                return;
            }
            case 4: {
                this.getDocument().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return "" == null ? this.getIdocType() != null : !"".equals(this.getIdocType());
            }
            case 1: {
                return "" == null ? this.getIdocTypeExtension() != null : !"".equals(this.getIdocTypeExtension());
            }
            case 2: {
                return "" == null ? this.getSystemRelease() != null : !"".equals(this.getSystemRelease());
            }
            case 3: {
                return "" == null ? this.getApplicationRelease() != null : !"".equals(this.getApplicationRelease());
            }
            case 4: {
                return this.document != null && !this.document.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void move(int newPosition, Document object) {
        this.getDocument().move(newPosition, object);
    }

    @Override
    public Document move(int newPosition, int oldPosition) {
        return this.getDocument().move(newPosition, oldPosition);
    }

    @Override
    public int size() {
        return this.getDocument().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getDocument().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.getDocument().contains(o);
    }

    @Override
    public Iterator<Document> iterator() {
        return this.getDocument().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getDocument().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getDocument().toArray(a);
    }

    @Override
    public boolean add(Document e) {
        this.checkDocument(e);
        return this.getDocument().add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.getDocument().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getDocument().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Document> c) {
        this.checkDocuments(c);
        return this.getDocument().addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Document> c) {
        this.checkDocuments(c);
        return this.getDocument().addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.getDocument().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getDocument().retainAll(c);
    }

    @Override
    public void clear() {
        this.getDocument().clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.getDocument().equals(o);
    }

    @Override
    public int hashCode() {
        return this.getDocument().hashCode();
    }

    @Override
    public Document get(int index) {
        return (Document)this.getDocument().get(index);
    }

    @Override
    public Document set(int index, Document element) {
        this.checkDocument(element);
        return this.getDocument().set(index, element);
    }

    @Override
    public void add(int index, Document element) {
        this.checkDocument(element);
        this.getDocument().add(index, element);
    }

    @Override
    public Document remove(int index) {
        return (Document)this.getDocument().remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.getDocument().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getDocument().lastIndexOf(o);
    }

    @Override
    public ListIterator<Document> listIterator() {
        return this.getDocument().listIterator();
    }

    @Override
    public ListIterator<Document> listIterator(int index) {
        return this.getDocument().listIterator(index);
    }

    @Override
    public List<Document> subList(int fromIndex, int toIndex) {
        return this.getDocument().subList(fromIndex, toIndex);
    }

    private void checkDocuments(Collection<? extends Document> c) {
        for (Document document : c) {
            this.checkDocument(document);
        }
    }

    private void checkDocument(Document document) {
        if (document != null && this.getRootSegmentClass().equals(document.getRootSegment().eClass())) {
            return;
        }
        throw new IllegalArgumentException("Document does not match kind of documents in this document list");
    }

    private Document createIDoc() {
        Segment segment = (Segment)this.getRootSegmentClass().getEPackage().getEFactoryInstance().create(this.getRootSegmentClass());
        DocumentImpl iDoc = (DocumentImpl)IdocFactory.eINSTANCE.createDocument();
        iDoc.setRootSegment(segment);
        ((SegmentImpl)segment).setDocument(iDoc);
        iDoc.setIDocType(segment.getIdocType());
        iDoc.setIDocTypeExtension(segment.getIdocTypeExtension());
        Date now = new Date();
        iDoc.setCreationDate(now);
        iDoc.setCreationTime(now);
        String idocCompoundType = this.getAnnotation(segment.eClass(), "http://sap.fusesource.org/idoc", "compoundType");
        if (idocCompoundType == null) {
            iDoc.setIDocCompoundType(idocCompoundType);
        }
        return iDoc;
    }

    private String getAnnotation(EModelElement modelElement, String source, String key) {
        EAnnotation annotation = modelElement.getEAnnotation(source);
        if (annotation == null) {
            return null;
        }
        return annotation.getDetails().get(key);
    }
}

