/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap.model.rfc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TIDState implements Enumerator
{
    CREATED(0, "CREATED", "CREATED"),
    EXECUTED(1, "EXECUTED", "EXECUTED"),
    COMMITTED(2, "COMMITTED", "COMMITTED"),
    ROLLED_BACK(3, "ROLLED_BACK", "ROLLED_BACK"),
    CONFIRMED(4, "CONFIRMED", "CONFIRMED");

    public static final int CREATED_VALUE = 0;
    public static final int EXECUTED_VALUE = 1;
    public static final int COMMITTED_VALUE = 2;
    public static final int ROLLED_BACK_VALUE = 3;
    public static final int CONFIRMED_VALUE = 4;
    private static final TIDState[] VALUES_ARRAY;
    public static final List<TIDState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TIDState[]{CREATED, EXECUTED, COMMITTED, ROLLED_BACK, CONFIRMED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TIDState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TIDState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TIDState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TIDState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TIDState get(int value) {
        switch (value) {
            case 0: {
                return CREATED;
            }
            case 1: {
                return EXECUTED;
            }
            case 2: {
                return COMMITTED;
            }
            case 3: {
                return ROLLED_BACK;
            }
            case 4: {
                return CONFIRMED;
            }
        }
        return null;
    }

    private TIDState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

