/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.model;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.List;
import org.switchyard.common.type.classpath.AbstractTypeFilter;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.common.type.classpath.Filter;
import org.switchyard.component.camel.Route;
import org.switchyard.component.camel.model.CamelNamespace;
import org.switchyard.component.camel.model.v1.V1CamelImplementationModel;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Namespace;
import org.switchyard.config.model.Scannable;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1CompositeModel;
import org.switchyard.config.model.composite.v1.V1InterfaceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.SwitchYardNamespace;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;

public class RouteScanner
implements Scanner<SwitchYardModel> {
    public ScannerOutput<SwitchYardModel> scan(ScannerInput<SwitchYardModel> input) throws IOException {
        SwitchYardNamespace switchyardNamespace = input.getSwitchyardNamespace();
        V1SwitchYardModel switchyardModel = new V1SwitchYardModel(switchyardNamespace.uri());
        V1CompositeModel compositeModel = new V1CompositeModel();
        compositeModel.setName(input.getCompositeName());
        CamelNamespace camelNamespace = CamelNamespace.DEFAULT;
        for (CamelNamespace value : CamelNamespace.values()) {
            if (!value.versionMatches((Namespace)switchyardNamespace)) continue;
            camelNamespace = value;
            break;
        }
        List<Class<?>> routeClasses = this.scanForRoutes(input.getURLs());
        for (Class<?> routeClass : routeClasses) {
            V1ComponentModel componentModel = new V1ComponentModel();
            componentModel.setName(routeClass.getSimpleName());
            V1CamelImplementationModel camelModel = new V1CamelImplementationModel(camelNamespace.uri());
            camelModel.setJavaClass(routeClass.getName());
            componentModel.setImplementation((ComponentImplementationModel)camelModel);
            compositeModel.addComponent((ComponentModel)componentModel);
            V1ComponentServiceModel serviceModel = new V1ComponentServiceModel(switchyardNamespace.uri());
            V1InterfaceModel csiModel = new V1InterfaceModel("java");
            Class<?> serviceInterface = routeClass.getAnnotation(Route.class).value();
            serviceModel.setName(this.getServiceName(routeClass));
            csiModel.setInterface(serviceInterface.getName());
            serviceModel.setInterface((InterfaceModel)csiModel);
            componentModel.addService((ComponentServiceModel)serviceModel);
        }
        if (!compositeModel.getModelChildren().isEmpty()) {
            switchyardModel.setComposite((CompositeModel)compositeModel);
        }
        return new ScannerOutput().setModel((Model)switchyardModel);
    }

    private String getServiceName(Class<?> routeClass) {
        return routeClass.getAnnotation(Route.class).name().equals("") ? routeClass.getAnnotation(Route.class).value().getSimpleName() : routeClass.getAnnotation(Route.class).name();
    }

    private List<Class<?>> scanForRoutes(List<URL> urls) throws IOException {
        RouteFilter filter = new RouteFilter();
        ClasspathScanner scanner = new ClasspathScanner((Filter)filter);
        for (URL url : urls) {
            scanner.scan(url);
        }
        return filter.getMatchedTypes();
    }

    private class RouteFilter
    extends AbstractTypeFilter {
        private RouteFilter() {
        }

        public boolean matches(Class<?> clazz) {
            Scannable scannable = clazz.getAnnotation(Scannable.class);
            if (scannable != null && !scannable.value()) {
                return false;
            }
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                return false;
            }
            try {
                clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            return clazz.isAnnotationPresent(Route.class);
        }
    }
}

