/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.commands.AbstractCamelCommand;
import org.apache.camel.commands.CamelController;
import org.apache.camel.commands.StringEscape;
import org.apache.camel.util.CamelContextStatDump;
import org.apache.camel.util.ObjectHelper;

public class ContextInfoCommand
extends AbstractCamelCommand {
    public static final String XML_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String OUTPUT_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private StringEscape stringEscape;
    private String context;
    private boolean verbose;

    public ContextInfoCommand(String context, boolean verbose) {
        this.context = context;
        this.verbose = verbose;
    }

    public void setStringEscape(StringEscape stringEscape) {
        this.stringEscape = stringEscape;
    }

    @Override
    public Object execute(CamelController camelController, PrintStream out, PrintStream err) throws Exception {
        Map<String, Object> row = camelController.getCamelContextInformation(this.context);
        if (row == null || row.isEmpty()) {
            err.println("Camel context " + this.context + " not found.");
            return null;
        }
        out.println("");
        out.println(this.stringEscape.unescapeJava("\u001b[1mCamel Context " + this.context + "\u001b[0m"));
        out.println(this.stringEscape.unescapeJava("\tName: " + row.get("name")));
        out.println(this.stringEscape.unescapeJava("\tManagementName: " + row.get("managementName")));
        out.println(this.stringEscape.unescapeJava("\tVersion: " + row.get("version")));
        out.println(this.stringEscape.unescapeJava("\tStatus: " + row.get("status")));
        out.println(this.stringEscape.unescapeJava("\tUptime: " + row.get("uptime")));
        out.println("");
        out.println(this.stringEscape.unescapeJava("\u001b[1mMiscellaneous\u001b[0m"));
        out.println(this.stringEscape.unescapeJava("\tSuspended: " + row.get("suspended")));
        out.println(this.stringEscape.unescapeJava("\tShutdown Timeout: " + row.get("shutdownTimeout") + " sec."));
        out.println(this.stringEscape.unescapeJava("\tAllow UseOriginalMessage: " + row.get("allowUseOriginalMessage")));
        out.println(this.stringEscape.unescapeJava("\tMessage History: " + row.get("messageHistory")));
        out.println(this.stringEscape.unescapeJava("\tTracing: " + row.get("tracing")));
        out.println("");
        out.println(this.stringEscape.unescapeJava("\u001b[1mProperties\u001b[0m"));
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("property.")) continue;
            key = key.substring(9);
            out.println(this.stringEscape.unescapeJava("\t" + key + " = " + entry.getValue()));
        }
        if (this.verbose) {
            out.println("");
            out.println(this.stringEscape.unescapeJava("\u001b[1mAdvanced\u001b[0m"));
            out.println(this.stringEscape.unescapeJava("\tClassResolver: " + row.get("classResolver")));
            out.println(this.stringEscape.unescapeJava("\tPackageScanClassResolver: " + row.get("packageScanClassResolver")));
            out.println(this.stringEscape.unescapeJava("\tApplicationContextClassLoader: " + row.get("applicationContextClassLoader")));
            this.printStatistics(camelController, out);
            out.println(this.stringEscape.unescapeJava("\tNumber of type converters: " + row.get("typeConverter.numberOfTypeConverters")));
            boolean enabled = false;
            if (row.get("typeConverter.statisticsEnabled") != null) {
                enabled = (Boolean)row.get("typeConverter.statisticsEnabled");
            }
            if (enabled) {
                long noop = (Long)row.get("typeConverter.noopCounter");
                long attempt = (Long)row.get("typeConverter.attemptCounter");
                long hit = (Long)row.get("typeConverter.hitCounter");
                long miss = (Long)row.get("typeConverter.missCounter");
                long failed = (Long)row.get("typeConverter.failedCounter");
                out.println(this.stringEscape.unescapeJava(String.format("\tType converter usage: [noop=%s, attempts=%s, hits=%s, misses=%s, failures=%s]", noop, attempt, hit, miss, failed)));
            }
            out.println(this.stringEscape.unescapeJava("\tNumber of blocked threads: " + row.get("asyncProcessorAwaitManager.size")));
            enabled = false;
            if (row.get("asyncProcessorAwaitManager.statisticsEnabled") != null) {
                enabled = (Boolean)row.get("asyncProcessorAwaitManager.statisticsEnabled");
            }
            if (enabled) {
                long blocked = (Long)row.get("asyncProcessorAwaitManager.threadsBlocked");
                long interrupted = (Long)row.get("asyncProcessorAwaitManager.threadsInterrupted");
                long total = (Long)row.get("asyncProcessorAwaitManager.totalDuration");
                long min = (Long)row.get("asyncProcessorAwaitManager.minDuration");
                long max = (Long)row.get("asyncProcessorAwaitManager.maxDuration");
                long mean = (Long)row.get("asyncProcessorAwaitManager.meanDuration");
                out.println(this.stringEscape.unescapeJava(String.format("\tAsyncProcessorAwaitManager usage: [blocked=%s, interrupted=%s, total=%s msec, min=%s msec, max=%s msec, mean=%s msec]", blocked, interrupted, total, min, max, mean)));
            }
            if (enabled = ((Boolean)row.get("streamCachingEnabled")).booleanValue()) {
                String spoolDirectory = this.safeNull(row.get("streamCaching.spoolDirectory"));
                String spoolChiper = this.safeNull(row.get("streamCaching.spoolChiper"));
                String spoolThreshold = this.safeNull(row.get("streamCaching.spoolThreshold"));
                String spoolUsedHeapMemoryThreshold = this.safeNull(row.get("streamCaching.spoolUsedHeapMemoryThreshold"));
                String spoolUsedHeapMemoryLimit = this.safeNull(row.get("streamCaching.spoolUsedHeapMemoryLimit"));
                String anySpoolRules = this.safeNull(row.get("streamCaching.anySpoolRules"));
                String bufferSize = this.safeNull(row.get("streamCaching.bufferSize"));
                String removeSpoolDirectoryWhenStopping = this.safeNull(row.get("streamCaching.removeSpoolDirectoryWhenStopping"));
                boolean statisticsEnabled = (Boolean)row.get("streamCaching.statisticsEnabled");
                String text = String.format("\tStream caching: [spoolDirectory=%s, spoolChiper=%s, spoolThreshold=%s, spoolUsedHeapMemoryThreshold=%s, spoolUsedHeapMemoryLimit=%s, anySpoolRules=%s, bufferSize=%s, removeSpoolDirectoryWhenStopping=%s, statisticsEnabled=%s]", spoolDirectory, spoolChiper, spoolThreshold, spoolUsedHeapMemoryThreshold, spoolUsedHeapMemoryLimit, anySpoolRules, bufferSize, removeSpoolDirectoryWhenStopping, statisticsEnabled);
                out.println(this.stringEscape.unescapeJava(text));
                if (statisticsEnabled) {
                    String cacheMemoryCounter = this.safeNull(row.get("streamCaching.cacheMemoryCounter"));
                    String cacheMemorySize = this.safeNull(row.get("streamCaching.cacheMemorySize"));
                    String cacheMemoryAverageSize = this.safeNull(row.get("streamCaching.cacheMemoryAverageSize"));
                    String cacheSpoolCounter = this.safeNull(row.get("streamCaching.cacheSpoolCounter"));
                    String cacheSpoolSize = this.safeNull(row.get("streamCaching.cacheSpoolSize"));
                    String cacheSpoolAverageSize = this.safeNull(row.get("streamCaching.cacheSpoolAverageSize"));
                    text = String.format("\t                       [cacheMemoryCounter=%s, cacheMemorySize=%s, cacheMemoryAverageSize=%s, cacheSpoolCounter=%s, cacheSpoolSize=%s, cacheSpoolAverageSize=%s]", cacheMemoryCounter, cacheMemorySize, cacheMemoryAverageSize, cacheSpoolCounter, cacheSpoolSize, cacheSpoolAverageSize);
                    out.println(this.stringEscape.unescapeJava(text));
                }
            }
            long totalRoutes = (Long)row.get("totalRoutes");
            long startedRoutes = (Long)row.get("totalRoutes");
            out.println(this.stringEscape.unescapeJava("\tNumber of running routes: " + startedRoutes));
            out.println(this.stringEscape.unescapeJava("\tNumber of not running routes: " + (totalRoutes - startedRoutes)));
        }
        return null;
    }

    protected void printStatistics(CamelController camelController, PrintStream out) throws Exception {
        out.println("");
        out.println(this.stringEscape.unescapeJava("\u001b[1mStatistics\u001b[0m"));
        String xml = camelController.getCamelContextStatsAsXml(this.context, true, false);
        if (xml != null) {
            String text;
            Date date;
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CamelContextStatDump.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            CamelContextStatDump stat = (CamelContextStatDump)unmarshaller.unmarshal((Reader)new StringReader(xml));
            long total = stat.getExchangesCompleted() + stat.getExchangesFailed();
            out.println(this.stringEscape.unescapeJava("\tExchanges Total: " + total));
            out.println(this.stringEscape.unescapeJava("\tExchanges Completed: " + stat.getExchangesCompleted()));
            out.println(this.stringEscape.unescapeJava("\tExchanges Failed: " + stat.getExchangesFailed()));
            out.println(this.stringEscape.unescapeJava("\tExchanges Inflight: " + stat.getExchangesInflight()));
            out.println(this.stringEscape.unescapeJava("\tMin Processing Time: " + stat.getMinProcessingTime() + " ms"));
            out.println(this.stringEscape.unescapeJava("\tMax Processing Time: " + stat.getMaxProcessingTime() + " ms"));
            out.println(this.stringEscape.unescapeJava("\tMean Processing Time: " + stat.getMeanProcessingTime() + " ms"));
            out.println(this.stringEscape.unescapeJava("\tTotal Processing Time: " + stat.getTotalProcessingTime() + " ms"));
            out.println(this.stringEscape.unescapeJava("\tLast Processing Time: " + stat.getLastProcessingTime() + " ms"));
            out.println(this.stringEscape.unescapeJava("\tDelta Processing Time: " + stat.getDeltaProcessingTime() + " ms"));
            if (ObjectHelper.isEmpty((Object)stat.getResetTimestamp())) {
                out.println(this.stringEscape.unescapeJava("\tReset Statistics Date:"));
            } else {
                date = new SimpleDateFormat(XML_TIMESTAMP_FORMAT).parse(stat.getResetTimestamp());
                text = new SimpleDateFormat(OUTPUT_TIMESTAMP_FORMAT).format(date);
                out.println(this.stringEscape.unescapeJava("\tReset Statistics Date: " + text));
            }
            if (ObjectHelper.isEmpty((Object)stat.getFirstExchangeCompletedTimestamp())) {
                out.println(this.stringEscape.unescapeJava("\tFirst Exchange Date:"));
            } else {
                date = new SimpleDateFormat(XML_TIMESTAMP_FORMAT).parse(stat.getFirstExchangeCompletedTimestamp());
                text = new SimpleDateFormat(OUTPUT_TIMESTAMP_FORMAT).format(date);
                out.println(this.stringEscape.unescapeJava("\tFirst Exchange Date: " + text));
            }
            if (ObjectHelper.isEmpty((Object)stat.getLastExchangeCompletedTimestamp())) {
                out.println(this.stringEscape.unescapeJava("\tLast Exchange Date:"));
            } else {
                date = new SimpleDateFormat(XML_TIMESTAMP_FORMAT).parse(stat.getLastExchangeCompletedTimestamp());
                text = new SimpleDateFormat(OUTPUT_TIMESTAMP_FORMAT).format(date);
                out.println(this.stringEscape.unescapeJava("\tLast Exchange Date: " + text));
            }
        }
    }
}

