/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.group.RGV_O01_ORDER;
import ca.uhn.hl7v2.model.v23.group.RGV_O01_xx;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RGV_O01_PATIENT
extends AbstractGroup {
    public RGV_O01_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(RGV_O01_xx.class, false, false, false);
            this.add(RGV_O01_ORDER.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RGV_O01_PATIENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RGV_O01_xx getxx() {
        RGV_O01_xx retVal = this.getTyped("xx", RGV_O01_xx.class);
        return retVal;
    }

    public RGV_O01_ORDER getORDER() {
        RGV_O01_ORDER retVal = this.getTyped("ORDER", RGV_O01_ORDER.class);
        return retVal;
    }

    public RGV_O01_ORDER getORDER(int rep) {
        RGV_O01_ORDER retVal = this.getTyped("ORDER", rep, RGV_O01_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<RGV_O01_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", RGV_O01_ORDER.class);
    }

    public void insertORDER(RGV_O01_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public RGV_O01_ORDER insertORDER(int rep) throws HL7Exception {
        return (RGV_O01_ORDER)super.insertRepetition("ORDER", rep);
    }

    public RGV_O01_ORDER removeORDER(int rep) throws HL7Exception {
        return (RGV_O01_ORDER)super.removeRepetition("ORDER", rep);
    }
}

