/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CX;
import ca.uhn.hl7v2.model.v23.datatype.XPN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class MRG
extends AbstractSegment {
    public MRG(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CX.class, true, 0, 20, new Object[]{this.getMessage()}, "Prior Patient ID - Internal");
            this.add(CX.class, false, 0, 16, new Object[]{this.getMessage()}, "Prior Alternate Patient ID");
            this.add(CX.class, false, 1, 20, new Object[]{this.getMessage()}, "Prior Patient Account Number");
            this.add(CX.class, false, 1, 16, new Object[]{this.getMessage()}, "Prior Patient ID - External");
            this.add(CX.class, false, 1, 0, new Object[]{this.getMessage()}, "Prior Visit Number");
            this.add(CX.class, false, 1, 0, new Object[]{this.getMessage()}, "Prior Alternate Visit ID");
            this.add(XPN.class, false, 1, 0, new Object[]{this.getMessage()}, "Prior Patient Name");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MRG - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CX[] getPriorPatientIDInternal() {
        CX[] retVal = (CX[])this.getTypedField(1, new CX[0]);
        return retVal;
    }

    public CX[] getMrg1_PriorPatientIDInternal() {
        CX[] retVal = (CX[])this.getTypedField(1, new CX[0]);
        return retVal;
    }

    public int getPriorPatientIDInternalReps() {
        return this.getReps(1);
    }

    public CX getPriorPatientIDInternal(int rep) {
        CX retVal = (CX)this.getTypedField(1, rep);
        return retVal;
    }

    public CX getMrg1_PriorPatientIDInternal(int rep) {
        CX retVal = (CX)this.getTypedField(1, rep);
        return retVal;
    }

    public int getMrg1_PriorPatientIDInternalReps() {
        return this.getReps(1);
    }

    public CX insertPriorPatientIDInternal(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(1, rep);
    }

    public CX insertMrg1_PriorPatientIDInternal(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(1, rep);
    }

    public CX removePriorPatientIDInternal(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(1, rep);
    }

    public CX removeMrg1_PriorPatientIDInternal(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(1, rep);
    }

    public CX[] getPriorAlternatePatientID() {
        CX[] retVal = (CX[])this.getTypedField(2, new CX[0]);
        return retVal;
    }

    public CX[] getMrg2_PriorAlternatePatientID() {
        CX[] retVal = (CX[])this.getTypedField(2, new CX[0]);
        return retVal;
    }

    public int getPriorAlternatePatientIDReps() {
        return this.getReps(2);
    }

    public CX getPriorAlternatePatientID(int rep) {
        CX retVal = (CX)this.getTypedField(2, rep);
        return retVal;
    }

    public CX getMrg2_PriorAlternatePatientID(int rep) {
        CX retVal = (CX)this.getTypedField(2, rep);
        return retVal;
    }

    public int getMrg2_PriorAlternatePatientIDReps() {
        return this.getReps(2);
    }

    public CX insertPriorAlternatePatientID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(2, rep);
    }

    public CX insertMrg2_PriorAlternatePatientID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(2, rep);
    }

    public CX removePriorAlternatePatientID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(2, rep);
    }

    public CX removeMrg2_PriorAlternatePatientID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(2, rep);
    }

    public CX getPriorPatientAccountNumber() {
        CX retVal = (CX)this.getTypedField(3, 0);
        return retVal;
    }

    public CX getMrg3_PriorPatientAccountNumber() {
        CX retVal = (CX)this.getTypedField(3, 0);
        return retVal;
    }

    public CX getPriorPatientIDExternal() {
        CX retVal = (CX)this.getTypedField(4, 0);
        return retVal;
    }

    public CX getMrg4_PriorPatientIDExternal() {
        CX retVal = (CX)this.getTypedField(4, 0);
        return retVal;
    }

    public CX getPriorVisitNumber() {
        CX retVal = (CX)this.getTypedField(5, 0);
        return retVal;
    }

    public CX getMrg5_PriorVisitNumber() {
        CX retVal = (CX)this.getTypedField(5, 0);
        return retVal;
    }

    public CX getPriorAlternateVisitID() {
        CX retVal = (CX)this.getTypedField(6, 0);
        return retVal;
    }

    public CX getMrg6_PriorAlternateVisitID() {
        CX retVal = (CX)this.getTypedField(6, 0);
        return retVal;
    }

    public XPN getPriorPatientName() {
        XPN retVal = (XPN)this.getTypedField(7, 0);
        return retVal;
    }

    public XPN getMrg7_PriorPatientName() {
        XPN retVal = (XPN)this.getTypedField(7, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CX(this.getMessage());
            }
            case 1: {
                return new CX(this.getMessage());
            }
            case 2: {
                return new CX(this.getMessage());
            }
            case 3: {
                return new CX(this.getMessage());
            }
            case 4: {
                return new CX(this.getMessage());
            }
            case 5: {
                return new CX(this.getMessage());
            }
            case 6: {
                return new XPN(this.getMessage());
            }
        }
        return null;
    }
}

