/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CX;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.IS;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.model.v23.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PD1
extends AbstractSegment {
    public PD1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(223)}, "Living Dependency");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(220)}, "Living Arrangement");
            this.add(XON.class, false, 0, 90, new Object[]{this.getMessage()}, "Patient Primary Facility");
            this.add(XCN.class, false, 0, 90, new Object[]{this.getMessage()}, "Patient Primary Care Provider Name & ID No.");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(231)}, "Student Indicator");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(310)}, "Handicap");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(315)}, "Living Will");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(316)}, "Organ Donor");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(136)}, "Separate Bill");
            this.add(CX.class, false, 0, 2, new Object[]{this.getMessage()}, "Duplicate Patient");
            this.add(CE.class, false, 1, 1, new Object[]{this.getMessage()}, "Publicity Indicator");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Protection Indicator");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PD1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public IS getLivingDependency() {
        IS retVal = (IS)this.getTypedField(1, 0);
        return retVal;
    }

    public IS getPd11_LivingDependency() {
        IS retVal = (IS)this.getTypedField(1, 0);
        return retVal;
    }

    public IS getLivingArrangement() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public IS getPd12_LivingArrangement() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public XON[] getPatientPrimaryFacility() {
        XON[] retVal = (XON[])this.getTypedField(3, new XON[0]);
        return retVal;
    }

    public XON[] getPd13_PatientPrimaryFacility() {
        XON[] retVal = (XON[])this.getTypedField(3, new XON[0]);
        return retVal;
    }

    public int getPatientPrimaryFacilityReps() {
        return this.getReps(3);
    }

    public XON getPatientPrimaryFacility(int rep) {
        XON retVal = (XON)this.getTypedField(3, rep);
        return retVal;
    }

    public XON getPd13_PatientPrimaryFacility(int rep) {
        XON retVal = (XON)this.getTypedField(3, rep);
        return retVal;
    }

    public int getPd13_PatientPrimaryFacilityReps() {
        return this.getReps(3);
    }

    public XON insertPatientPrimaryFacility(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(3, rep);
    }

    public XON insertPd13_PatientPrimaryFacility(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(3, rep);
    }

    public XON removePatientPrimaryFacility(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(3, rep);
    }

    public XON removePd13_PatientPrimaryFacility(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(3, rep);
    }

    public XCN[] getPatientPrimaryCareProviderNameIDNo() {
        XCN[] retVal = (XCN[])this.getTypedField(4, new XCN[0]);
        return retVal;
    }

    public XCN[] getPd14_PatientPrimaryCareProviderNameIDNo() {
        XCN[] retVal = (XCN[])this.getTypedField(4, new XCN[0]);
        return retVal;
    }

    public int getPatientPrimaryCareProviderNameIDNoReps() {
        return this.getReps(4);
    }

    public XCN getPatientPrimaryCareProviderNameIDNo(int rep) {
        XCN retVal = (XCN)this.getTypedField(4, rep);
        return retVal;
    }

    public XCN getPd14_PatientPrimaryCareProviderNameIDNo(int rep) {
        XCN retVal = (XCN)this.getTypedField(4, rep);
        return retVal;
    }

    public int getPd14_PatientPrimaryCareProviderNameIDNoReps() {
        return this.getReps(4);
    }

    public XCN insertPatientPrimaryCareProviderNameIDNo(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(4, rep);
    }

    public XCN insertPd14_PatientPrimaryCareProviderNameIDNo(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(4, rep);
    }

    public XCN removePatientPrimaryCareProviderNameIDNo(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(4, rep);
    }

    public XCN removePd14_PatientPrimaryCareProviderNameIDNo(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(4, rep);
    }

    public IS getStudentIndicator() {
        IS retVal = (IS)this.getTypedField(5, 0);
        return retVal;
    }

    public IS getPd15_StudentIndicator() {
        IS retVal = (IS)this.getTypedField(5, 0);
        return retVal;
    }

    public IS getHandicap() {
        IS retVal = (IS)this.getTypedField(6, 0);
        return retVal;
    }

    public IS getPd16_Handicap() {
        IS retVal = (IS)this.getTypedField(6, 0);
        return retVal;
    }

    public IS getLivingWill() {
        IS retVal = (IS)this.getTypedField(7, 0);
        return retVal;
    }

    public IS getPd17_LivingWill() {
        IS retVal = (IS)this.getTypedField(7, 0);
        return retVal;
    }

    public IS getOrganDonor() {
        IS retVal = (IS)this.getTypedField(8, 0);
        return retVal;
    }

    public IS getPd18_OrganDonor() {
        IS retVal = (IS)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getSeparateBill() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getPd19_SeparateBill() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public CX[] getDuplicatePatient() {
        CX[] retVal = (CX[])this.getTypedField(10, new CX[0]);
        return retVal;
    }

    public CX[] getPd110_DuplicatePatient() {
        CX[] retVal = (CX[])this.getTypedField(10, new CX[0]);
        return retVal;
    }

    public int getDuplicatePatientReps() {
        return this.getReps(10);
    }

    public CX getDuplicatePatient(int rep) {
        CX retVal = (CX)this.getTypedField(10, rep);
        return retVal;
    }

    public CX getPd110_DuplicatePatient(int rep) {
        CX retVal = (CX)this.getTypedField(10, rep);
        return retVal;
    }

    public int getPd110_DuplicatePatientReps() {
        return this.getReps(10);
    }

    public CX insertDuplicatePatient(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(10, rep);
    }

    public CX insertPd110_DuplicatePatient(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(10, rep);
    }

    public CX removeDuplicatePatient(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(10, rep);
    }

    public CX removePd110_DuplicatePatient(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(10, rep);
    }

    public CE getPublicityIndicator() {
        CE retVal = (CE)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getPd111_PublicityIndicator() {
        CE retVal = (CE)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getPd112_ProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new IS(this.getMessage(), new Integer(223));
            }
            case 1: {
                return new IS(this.getMessage(), new Integer(220));
            }
            case 2: {
                return new XON(this.getMessage());
            }
            case 3: {
                return new XCN(this.getMessage());
            }
            case 4: {
                return new IS(this.getMessage(), new Integer(231));
            }
            case 5: {
                return new IS(this.getMessage(), new Integer(310));
            }
            case 6: {
                return new IS(this.getMessage(), new Integer(315));
            }
            case 7: {
                return new IS(this.getMessage(), new Integer(316));
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 9: {
                return new CX(this.getMessage());
            }
            case 10: {
                return new CE(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(136));
            }
        }
        return null;
    }
}

