/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v231.group.RCI_I05_OBRNTEOBXNTE;
import ca.uhn.hl7v2.model.v231.group.RCI_I05_PRDCTD;
import ca.uhn.hl7v2.model.v231.segment.AL1;
import ca.uhn.hl7v2.model.v231.segment.DG1;
import ca.uhn.hl7v2.model.v231.segment.DRG;
import ca.uhn.hl7v2.model.v231.segment.MSA;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.model.v231.segment.PID;
import ca.uhn.hl7v2.model.v231.segment.QRD;
import ca.uhn.hl7v2.model.v231.segment.QRF;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RCI_I05
extends AbstractMessage {
    public RCI_I05() {
        this(new DefaultModelClassFactory());
    }

    public RCI_I05(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(RCI_I05_PRDCTD.class, true, true);
            this.add(PID.class, true, false);
            this.add(DG1.class, false, true);
            this.add(DRG.class, false, true);
            this.add(AL1.class, false, true);
            this.add(RCI_I05_OBRNTEOBXNTE.class, false, true);
            this.add(NTE.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RCI_I05 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public QRD getQRD() {
        return this.getTyped("QRD", QRD.class);
    }

    public QRF getQRF() {
        return this.getTyped("QRF", QRF.class);
    }

    public RCI_I05_PRDCTD getPRDCTD() {
        return this.getTyped("PRDCTD", RCI_I05_PRDCTD.class);
    }

    public RCI_I05_PRDCTD getPRDCTD(int rep) {
        return this.getTyped("PRDCTD", rep, RCI_I05_PRDCTD.class);
    }

    public int getPRDCTDReps() {
        return this.getReps("PRDCTD");
    }

    public List<RCI_I05_PRDCTD> getPRDCTDAll() throws HL7Exception {
        return this.getAllAsList("PRDCTD", RCI_I05_PRDCTD.class);
    }

    public void insertPRDCTD(RCI_I05_PRDCTD structure, int rep) throws HL7Exception {
        super.insertRepetition("PRDCTD", structure, rep);
    }

    public RCI_I05_PRDCTD insertPRDCTD(int rep) throws HL7Exception {
        return (RCI_I05_PRDCTD)super.insertRepetition("PRDCTD", rep);
    }

    public RCI_I05_PRDCTD removePRDCTD(int rep) throws HL7Exception {
        return (RCI_I05_PRDCTD)super.removeRepetition("PRDCTD", rep);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public DG1 getDG1() {
        return this.getTyped("DG1", DG1.class);
    }

    public DG1 getDG1(int rep) {
        return this.getTyped("DG1", rep, DG1.class);
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public DRG getDRG() {
        return this.getTyped("DRG", DRG.class);
    }

    public DRG getDRG(int rep) {
        return this.getTyped("DRG", rep, DRG.class);
    }

    public int getDRGReps() {
        return this.getReps("DRG");
    }

    public List<DRG> getDRGAll() throws HL7Exception {
        return this.getAllAsList("DRG", DRG.class);
    }

    public void insertDRG(DRG structure, int rep) throws HL7Exception {
        super.insertRepetition("DRG", structure, rep);
    }

    public DRG insertDRG(int rep) throws HL7Exception {
        return (DRG)super.insertRepetition("DRG", rep);
    }

    public DRG removeDRG(int rep) throws HL7Exception {
        return (DRG)super.removeRepetition("DRG", rep);
    }

    public AL1 getAL1() {
        return this.getTyped("AL1", AL1.class);
    }

    public AL1 getAL1(int rep) {
        return this.getTyped("AL1", rep, AL1.class);
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public RCI_I05_OBRNTEOBXNTE getOBRNTEOBXNTE() {
        return this.getTyped("OBRNTEOBXNTE", RCI_I05_OBRNTEOBXNTE.class);
    }

    public RCI_I05_OBRNTEOBXNTE getOBRNTEOBXNTE(int rep) {
        return this.getTyped("OBRNTEOBXNTE", rep, RCI_I05_OBRNTEOBXNTE.class);
    }

    public int getOBRNTEOBXNTEReps() {
        return this.getReps("OBRNTEOBXNTE");
    }

    public List<RCI_I05_OBRNTEOBXNTE> getOBRNTEOBXNTEAll() throws HL7Exception {
        return this.getAllAsList("OBRNTEOBXNTE", RCI_I05_OBRNTEOBXNTE.class);
    }

    public void insertOBRNTEOBXNTE(RCI_I05_OBRNTEOBXNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("OBRNTEOBXNTE", structure, rep);
    }

    public RCI_I05_OBRNTEOBXNTE insertOBRNTEOBXNTE(int rep) throws HL7Exception {
        return (RCI_I05_OBRNTEOBXNTE)super.insertRepetition("OBRNTEOBXNTE", rep);
    }

    public RCI_I05_OBRNTEOBXNTE removeOBRNTEOBXNTE(int rep) throws HL7Exception {
        return (RCI_I05_OBRNTEOBXNTE)super.removeRepetition("OBRNTEOBXNTE", rep);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

