/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.group.RSP_K25_STAFF;
import ca.uhn.hl7v2.model.v24.segment.DSC;
import ca.uhn.hl7v2.model.v24.segment.ERR;
import ca.uhn.hl7v2.model.v24.segment.MSA;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.QAK;
import ca.uhn.hl7v2.model.v24.segment.QPD;
import ca.uhn.hl7v2.model.v24.segment.RCP;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSP_K25
extends AbstractMessage {
    public RSP_K25() {
        this(new DefaultModelClassFactory());
    }

    public RSP_K25(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(QAK.class, true, false);
            this.add(QPD.class, true, false);
            this.add(RCP.class, true, false);
            this.add(RSP_K25_STAFF.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RSP_K25 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public QAK getQAK() {
        return this.getTyped("QAK", QAK.class);
    }

    public QPD getQPD() {
        return this.getTyped("QPD", QPD.class);
    }

    public RCP getRCP() {
        return this.getTyped("RCP", RCP.class);
    }

    public RSP_K25_STAFF getSTAFF() {
        return this.getTyped("STAFF", RSP_K25_STAFF.class);
    }

    public RSP_K25_STAFF getSTAFF(int rep) {
        return this.getTyped("STAFF", rep, RSP_K25_STAFF.class);
    }

    public int getSTAFFReps() {
        return this.getReps("STAFF");
    }

    public List<RSP_K25_STAFF> getSTAFFAll() throws HL7Exception {
        return this.getAllAsList("STAFF", RSP_K25_STAFF.class);
    }

    public void insertSTAFF(RSP_K25_STAFF structure, int rep) throws HL7Exception {
        super.insertRepetition("STAFF", structure, rep);
    }

    public RSP_K25_STAFF insertSTAFF(int rep) throws HL7Exception {
        return (RSP_K25_STAFF)super.insertRepetition("STAFF", rep);
    }

    public RSP_K25_STAFF removeSTAFF(int rep) throws HL7Exception {
        return (RSP_K25_STAFF)super.removeRepetition("STAFF", rep);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

