/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.IS;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.SI;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class AIG
extends AbstractSegment {
    public AIG(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - AIG");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(206)}, "Segment Action Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Resource ID");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Resource Type");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Resource Group");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Resource Quantity");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Resource Quantity Units");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Start Date/Time");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Start Date/Time Offset");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Start Date/Time Offset Units");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Duration");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Duration Units");
            this.add(IS.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(279)}, "Allow Substitution Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Filler Status Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating AIG - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDAIG() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getAig1_SetIDAIG() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getAig2_SegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getResourceID() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getAig3_ResourceID() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getResourceType() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getAig4_ResourceType() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE[] getResourceGroup() {
        CE[] retVal = (CE[])this.getTypedField(5, new CE[0]);
        return retVal;
    }

    public CE[] getAig5_ResourceGroup() {
        CE[] retVal = (CE[])this.getTypedField(5, new CE[0]);
        return retVal;
    }

    public int getResourceGroupReps() {
        return this.getReps(5);
    }

    public CE getResourceGroup(int rep) {
        CE retVal = (CE)this.getTypedField(5, rep);
        return retVal;
    }

    public CE getAig5_ResourceGroup(int rep) {
        CE retVal = (CE)this.getTypedField(5, rep);
        return retVal;
    }

    public int getAig5_ResourceGroupReps() {
        return this.getReps(5);
    }

    public CE insertResourceGroup(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(5, rep);
    }

    public CE insertAig5_ResourceGroup(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(5, rep);
    }

    public CE removeResourceGroup(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(5, rep);
    }

    public CE removeAig5_ResourceGroup(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(5, rep);
    }

    public NM getResourceQuantity() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getAig6_ResourceQuantity() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getResourceQuantityUnits() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getAig7_ResourceQuantityUnits() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getStartDateTime() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getAig8_StartDateTime() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getStartDateTimeOffset() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getAig9_StartDateTimeOffset() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getStartDateTimeOffsetUnits() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getAig10_StartDateTimeOffsetUnits() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getDuration() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getAig11_Duration() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getDurationUnits() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getAig12_DurationUnits() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public IS getAllowSubstitutionCode() {
        IS retVal = (IS)this.getTypedField(13, 0);
        return retVal;
    }

    public IS getAig13_AllowSubstitutionCode() {
        IS retVal = (IS)this.getTypedField(13, 0);
        return retVal;
    }

    public CE getFillerStatusCode() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public CE getAig14_FillerStatusCode() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(206));
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new NM(this.getMessage());
            }
            case 11: {
                return new CE(this.getMessage());
            }
            case 12: {
                return new IS(this.getMessage(), new Integer(279));
            }
            case 13: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

