/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.DT;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.IS;
import ca.uhn.hl7v2.model.v25.datatype.PIP;
import ca.uhn.hl7v2.model.v25.datatype.PLN;
import ca.uhn.hl7v2.model.v25.datatype.SI;
import ca.uhn.hl7v2.model.v25.datatype.SPD;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PRA
extends AbstractSegment {
    public PRA(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Primary Key Value - PRA");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Practitioner Group");
            this.add(IS.class, false, 0, 3, new Object[]{this.getMessage(), new Integer(186)}, "Practitioner Category");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(187)}, "Provider Billing");
            this.add(SPD.class, false, 0, 112, new Object[]{this.getMessage()}, "Specialty");
            this.add(PLN.class, false, 0, 99, new Object[]{this.getMessage()}, "Practitioner ID Numbers");
            this.add(PIP.class, false, 0, 770, new Object[]{this.getMessage()}, "Privileges");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Date Entered Practice");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Institution");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Date Left Practice");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Government Reimbursement Billing Eligibility");
            this.add(SI.class, false, 1, 60, new Object[]{this.getMessage()}, "Set ID - PRA");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PRA - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getPrimaryKeyValuePRA() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getPra1_PrimaryKeyValuePRA() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE[] getPractitionerGroup() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public CE[] getPra2_PractitionerGroup() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public int getPractitionerGroupReps() {
        return this.getReps(2);
    }

    public CE getPractitionerGroup(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public CE getPra2_PractitionerGroup(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getPra2_PractitionerGroupReps() {
        return this.getReps(2);
    }

    public CE insertPractitionerGroup(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE insertPra2_PractitionerGroup(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE removePractitionerGroup(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public CE removePra2_PractitionerGroup(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public IS[] getPractitionerCategory() {
        IS[] retVal = (IS[])this.getTypedField(3, new IS[0]);
        return retVal;
    }

    public IS[] getPra3_PractitionerCategory() {
        IS[] retVal = (IS[])this.getTypedField(3, new IS[0]);
        return retVal;
    }

    public int getPractitionerCategoryReps() {
        return this.getReps(3);
    }

    public IS getPractitionerCategory(int rep) {
        IS retVal = (IS)this.getTypedField(3, rep);
        return retVal;
    }

    public IS getPra3_PractitionerCategory(int rep) {
        IS retVal = (IS)this.getTypedField(3, rep);
        return retVal;
    }

    public int getPra3_PractitionerCategoryReps() {
        return this.getReps(3);
    }

    public IS insertPractitionerCategory(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(3, rep);
    }

    public IS insertPra3_PractitionerCategory(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(3, rep);
    }

    public IS removePractitionerCategory(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(3, rep);
    }

    public IS removePra3_PractitionerCategory(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(3, rep);
    }

    public ID getProviderBilling() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getPra4_ProviderBilling() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public SPD[] getSpecialty() {
        SPD[] retVal = (SPD[])this.getTypedField(5, new SPD[0]);
        return retVal;
    }

    public SPD[] getPra5_Specialty() {
        SPD[] retVal = (SPD[])this.getTypedField(5, new SPD[0]);
        return retVal;
    }

    public int getSpecialtyReps() {
        return this.getReps(5);
    }

    public SPD getSpecialty(int rep) {
        SPD retVal = (SPD)this.getTypedField(5, rep);
        return retVal;
    }

    public SPD getPra5_Specialty(int rep) {
        SPD retVal = (SPD)this.getTypedField(5, rep);
        return retVal;
    }

    public int getPra5_SpecialtyReps() {
        return this.getReps(5);
    }

    public SPD insertSpecialty(int rep) throws HL7Exception {
        return (SPD)super.insertRepetition(5, rep);
    }

    public SPD insertPra5_Specialty(int rep) throws HL7Exception {
        return (SPD)super.insertRepetition(5, rep);
    }

    public SPD removeSpecialty(int rep) throws HL7Exception {
        return (SPD)super.removeRepetition(5, rep);
    }

    public SPD removePra5_Specialty(int rep) throws HL7Exception {
        return (SPD)super.removeRepetition(5, rep);
    }

    public PLN[] getPractitionerIDNumbers() {
        PLN[] retVal = (PLN[])this.getTypedField(6, new PLN[0]);
        return retVal;
    }

    public PLN[] getPra6_PractitionerIDNumbers() {
        PLN[] retVal = (PLN[])this.getTypedField(6, new PLN[0]);
        return retVal;
    }

    public int getPractitionerIDNumbersReps() {
        return this.getReps(6);
    }

    public PLN getPractitionerIDNumbers(int rep) {
        PLN retVal = (PLN)this.getTypedField(6, rep);
        return retVal;
    }

    public PLN getPra6_PractitionerIDNumbers(int rep) {
        PLN retVal = (PLN)this.getTypedField(6, rep);
        return retVal;
    }

    public int getPra6_PractitionerIDNumbersReps() {
        return this.getReps(6);
    }

    public PLN insertPractitionerIDNumbers(int rep) throws HL7Exception {
        return (PLN)super.insertRepetition(6, rep);
    }

    public PLN insertPra6_PractitionerIDNumbers(int rep) throws HL7Exception {
        return (PLN)super.insertRepetition(6, rep);
    }

    public PLN removePractitionerIDNumbers(int rep) throws HL7Exception {
        return (PLN)super.removeRepetition(6, rep);
    }

    public PLN removePra6_PractitionerIDNumbers(int rep) throws HL7Exception {
        return (PLN)super.removeRepetition(6, rep);
    }

    public PIP[] getPrivileges() {
        PIP[] retVal = (PIP[])this.getTypedField(7, new PIP[0]);
        return retVal;
    }

    public PIP[] getPra7_Privileges() {
        PIP[] retVal = (PIP[])this.getTypedField(7, new PIP[0]);
        return retVal;
    }

    public int getPrivilegesReps() {
        return this.getReps(7);
    }

    public PIP getPrivileges(int rep) {
        PIP retVal = (PIP)this.getTypedField(7, rep);
        return retVal;
    }

    public PIP getPra7_Privileges(int rep) {
        PIP retVal = (PIP)this.getTypedField(7, rep);
        return retVal;
    }

    public int getPra7_PrivilegesReps() {
        return this.getReps(7);
    }

    public PIP insertPrivileges(int rep) throws HL7Exception {
        return (PIP)super.insertRepetition(7, rep);
    }

    public PIP insertPra7_Privileges(int rep) throws HL7Exception {
        return (PIP)super.insertRepetition(7, rep);
    }

    public PIP removePrivileges(int rep) throws HL7Exception {
        return (PIP)super.removeRepetition(7, rep);
    }

    public PIP removePra7_Privileges(int rep) throws HL7Exception {
        return (PIP)super.removeRepetition(7, rep);
    }

    public DT getDateEnteredPractice() {
        DT retVal = (DT)this.getTypedField(8, 0);
        return retVal;
    }

    public DT getPra8_DateEnteredPractice() {
        DT retVal = (DT)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getInstitution() {
        CE retVal = (CE)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getPra9_Institution() {
        CE retVal = (CE)this.getTypedField(9, 0);
        return retVal;
    }

    public DT getDateLeftPractice() {
        DT retVal = (DT)this.getTypedField(10, 0);
        return retVal;
    }

    public DT getPra10_DateLeftPractice() {
        DT retVal = (DT)this.getTypedField(10, 0);
        return retVal;
    }

    public CE[] getGovernmentReimbursementBillingEligibility() {
        CE[] retVal = (CE[])this.getTypedField(11, new CE[0]);
        return retVal;
    }

    public CE[] getPra11_GovernmentReimbursementBillingEligibility() {
        CE[] retVal = (CE[])this.getTypedField(11, new CE[0]);
        return retVal;
    }

    public int getGovernmentReimbursementBillingEligibilityReps() {
        return this.getReps(11);
    }

    public CE getGovernmentReimbursementBillingEligibility(int rep) {
        CE retVal = (CE)this.getTypedField(11, rep);
        return retVal;
    }

    public CE getPra11_GovernmentReimbursementBillingEligibility(int rep) {
        CE retVal = (CE)this.getTypedField(11, rep);
        return retVal;
    }

    public int getPra11_GovernmentReimbursementBillingEligibilityReps() {
        return this.getReps(11);
    }

    public CE insertGovernmentReimbursementBillingEligibility(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(11, rep);
    }

    public CE insertPra11_GovernmentReimbursementBillingEligibility(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(11, rep);
    }

    public CE removeGovernmentReimbursementBillingEligibility(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(11, rep);
    }

    public CE removePra11_GovernmentReimbursementBillingEligibility(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(11, rep);
    }

    public SI getSetIDPRA() {
        SI retVal = (SI)this.getTypedField(12, 0);
        return retVal;
    }

    public SI getPra12_SetIDPRA() {
        SI retVal = (SI)this.getTypedField(12, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new IS(this.getMessage(), new Integer(186));
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(187));
            }
            case 4: {
                return new SPD(this.getMessage());
            }
            case 5: {
                return new PLN(this.getMessage());
            }
            case 6: {
                return new PIP(this.getMessage());
            }
            case 7: {
                return new DT(this.getMessage());
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new DT(this.getMessage());
            }
            case 10: {
                return new CE(this.getMessage());
            }
            case 11: {
                return new SI(this.getMessage());
            }
        }
        return null;
    }
}

