/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.CP;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.IS;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class DRG
extends AbstractSegment {
    public DRG(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Diagnostic Related Group");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "DRG Assigned Date/Time");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "DRG Approval Indicator");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(56)}, "DRG Grouper Review Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Outlier Type");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Outlier Days");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Outlier Cost");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(229)}, "DRG Payor");
            this.add(CP.class, false, 1, 9, new Object[]{this.getMessage()}, "Outlier Reimbursement");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Confidential Indicator");
            this.add(IS.class, false, 1, 21, new Object[]{this.getMessage(), new Integer(415)}, "DRG Transfer Type");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DRG - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getDiagnosticRelatedGroup() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getDrg1_DiagnosticRelatedGroup() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getDRGAssignedDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getDrg2_DRGAssignedDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getDRGApprovalIndicator() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getDrg3_DRGApprovalIndicator() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public IS getDRGGrouperReviewCode() {
        IS retVal = (IS)this.getTypedField(4, 0);
        return retVal;
    }

    public IS getDrg4_DRGGrouperReviewCode() {
        IS retVal = (IS)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getOutlierType() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getDrg5_OutlierType() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getOutlierDays() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getDrg6_OutlierDays() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public CP getOutlierCost() {
        CP retVal = (CP)this.getTypedField(7, 0);
        return retVal;
    }

    public CP getDrg7_OutlierCost() {
        CP retVal = (CP)this.getTypedField(7, 0);
        return retVal;
    }

    public IS getDRGPayor() {
        IS retVal = (IS)this.getTypedField(8, 0);
        return retVal;
    }

    public IS getDrg8_DRGPayor() {
        IS retVal = (IS)this.getTypedField(8, 0);
        return retVal;
    }

    public CP getOutlierReimbursement() {
        CP retVal = (CP)this.getTypedField(9, 0);
        return retVal;
    }

    public CP getDrg9_OutlierReimbursement() {
        CP retVal = (CP)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getConfidentialIndicator() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getDrg10_ConfidentialIndicator() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public IS getDRGTransferType() {
        IS retVal = (IS)this.getTypedField(11, 0);
        return retVal;
    }

    public IS getDrg11_DRGTransferType() {
        IS retVal = (IS)this.getTypedField(11, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new TS(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 3: {
                return new IS(this.getMessage(), new Integer(56));
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new CP(this.getMessage());
            }
            case 7: {
                return new IS(this.getMessage(), new Integer(229));
            }
            case 8: {
                return new CP(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 10: {
                return new IS(this.getMessage(), new Integer(415));
            }
        }
        return null;
    }
}

