/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CWE;
import ca.uhn.hl7v2.model.v251.datatype.ELD;
import ca.uhn.hl7v2.model.v251.datatype.ERL;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.IS;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.model.v251.datatype.TX;
import ca.uhn.hl7v2.model.v251.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ERR
extends AbstractSegment {
    public ERR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ELD.class, false, 0, 493, new Object[]{this.getMessage()}, "Error Code and Location");
            this.add(ERL.class, false, 0, 18, new Object[]{this.getMessage()}, "Error Location");
            this.add(CWE.class, true, 1, 705, new Object[]{this.getMessage()}, "HL7 Error Code");
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(516)}, "Severity");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Application Error Code");
            this.add(ST.class, false, 10, 80, new Object[]{this.getMessage()}, "Application Error Parameter");
            this.add(TX.class, false, 1, 2048, new Object[]{this.getMessage()}, "Diagnostic Information");
            this.add(TX.class, false, 1, 250, new Object[]{this.getMessage()}, "User Message");
            this.add(IS.class, false, 0, 20, new Object[]{this.getMessage(), new Integer(517)}, "Inform Person Indicator");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Override Type");
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage()}, "Override Reason Code");
            this.add(XTN.class, false, 0, 652, new Object[]{this.getMessage()}, "Help Desk Contact Point");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ERR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ELD[] getErrorCodeAndLocation() {
        ELD[] retVal = (ELD[])this.getTypedField(1, new ELD[0]);
        return retVal;
    }

    public ELD[] getErr1_ErrorCodeAndLocation() {
        ELD[] retVal = (ELD[])this.getTypedField(1, new ELD[0]);
        return retVal;
    }

    public int getErrorCodeAndLocationReps() {
        return this.getReps(1);
    }

    public ELD getErrorCodeAndLocation(int rep) {
        ELD retVal = (ELD)this.getTypedField(1, rep);
        return retVal;
    }

    public ELD getErr1_ErrorCodeAndLocation(int rep) {
        ELD retVal = (ELD)this.getTypedField(1, rep);
        return retVal;
    }

    public int getErr1_ErrorCodeAndLocationReps() {
        return this.getReps(1);
    }

    public ELD insertErrorCodeAndLocation(int rep) throws HL7Exception {
        return (ELD)super.insertRepetition(1, rep);
    }

    public ELD insertErr1_ErrorCodeAndLocation(int rep) throws HL7Exception {
        return (ELD)super.insertRepetition(1, rep);
    }

    public ELD removeErrorCodeAndLocation(int rep) throws HL7Exception {
        return (ELD)super.removeRepetition(1, rep);
    }

    public ELD removeErr1_ErrorCodeAndLocation(int rep) throws HL7Exception {
        return (ELD)super.removeRepetition(1, rep);
    }

    public ERL[] getErrorLocation() {
        ERL[] retVal = (ERL[])this.getTypedField(2, new ERL[0]);
        return retVal;
    }

    public ERL[] getErr2_ErrorLocation() {
        ERL[] retVal = (ERL[])this.getTypedField(2, new ERL[0]);
        return retVal;
    }

    public int getErrorLocationReps() {
        return this.getReps(2);
    }

    public ERL getErrorLocation(int rep) {
        ERL retVal = (ERL)this.getTypedField(2, rep);
        return retVal;
    }

    public ERL getErr2_ErrorLocation(int rep) {
        ERL retVal = (ERL)this.getTypedField(2, rep);
        return retVal;
    }

    public int getErr2_ErrorLocationReps() {
        return this.getReps(2);
    }

    public ERL insertErrorLocation(int rep) throws HL7Exception {
        return (ERL)super.insertRepetition(2, rep);
    }

    public ERL insertErr2_ErrorLocation(int rep) throws HL7Exception {
        return (ERL)super.insertRepetition(2, rep);
    }

    public ERL removeErrorLocation(int rep) throws HL7Exception {
        return (ERL)super.removeRepetition(2, rep);
    }

    public ERL removeErr2_ErrorLocation(int rep) throws HL7Exception {
        return (ERL)super.removeRepetition(2, rep);
    }

    public CWE getHL7ErrorCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getErr3_HL7ErrorCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getSeverity() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getErr4_Severity() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getApplicationErrorCode() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getErr5_ApplicationErrorCode() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public ST[] getApplicationErrorParameter() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public ST[] getErr6_ApplicationErrorParameter() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public int getApplicationErrorParameterReps() {
        return this.getReps(6);
    }

    public ST getApplicationErrorParameter(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public ST getErr6_ApplicationErrorParameter(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public int getErr6_ApplicationErrorParameterReps() {
        return this.getReps(6);
    }

    public ST insertApplicationErrorParameter(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST insertErr6_ApplicationErrorParameter(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST removeApplicationErrorParameter(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ST removeErr6_ApplicationErrorParameter(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public TX getDiagnosticInformation() {
        TX retVal = (TX)this.getTypedField(7, 0);
        return retVal;
    }

    public TX getErr7_DiagnosticInformation() {
        TX retVal = (TX)this.getTypedField(7, 0);
        return retVal;
    }

    public TX getUserMessage() {
        TX retVal = (TX)this.getTypedField(8, 0);
        return retVal;
    }

    public TX getErr8_UserMessage() {
        TX retVal = (TX)this.getTypedField(8, 0);
        return retVal;
    }

    public IS[] getInformPersonIndicator() {
        IS[] retVal = (IS[])this.getTypedField(9, new IS[0]);
        return retVal;
    }

    public IS[] getErr9_InformPersonIndicator() {
        IS[] retVal = (IS[])this.getTypedField(9, new IS[0]);
        return retVal;
    }

    public int getInformPersonIndicatorReps() {
        return this.getReps(9);
    }

    public IS getInformPersonIndicator(int rep) {
        IS retVal = (IS)this.getTypedField(9, rep);
        return retVal;
    }

    public IS getErr9_InformPersonIndicator(int rep) {
        IS retVal = (IS)this.getTypedField(9, rep);
        return retVal;
    }

    public int getErr9_InformPersonIndicatorReps() {
        return this.getReps(9);
    }

    public IS insertInformPersonIndicator(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(9, rep);
    }

    public IS insertErr9_InformPersonIndicator(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(9, rep);
    }

    public IS removeInformPersonIndicator(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(9, rep);
    }

    public IS removeErr9_InformPersonIndicator(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(9, rep);
    }

    public CWE getOverrideType() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getErr10_OverrideType() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE[] getOverrideReasonCode() {
        CWE[] retVal = (CWE[])this.getTypedField(11, new CWE[0]);
        return retVal;
    }

    public CWE[] getErr11_OverrideReasonCode() {
        CWE[] retVal = (CWE[])this.getTypedField(11, new CWE[0]);
        return retVal;
    }

    public int getOverrideReasonCodeReps() {
        return this.getReps(11);
    }

    public CWE getOverrideReasonCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public CWE getErr11_OverrideReasonCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public int getErr11_OverrideReasonCodeReps() {
        return this.getReps(11);
    }

    public CWE insertOverrideReasonCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE insertErr11_OverrideReasonCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE removeOverrideReasonCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public CWE removeErr11_OverrideReasonCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public XTN[] getHelpDeskContactPoint() {
        XTN[] retVal = (XTN[])this.getTypedField(12, new XTN[0]);
        return retVal;
    }

    public XTN[] getErr12_HelpDeskContactPoint() {
        XTN[] retVal = (XTN[])this.getTypedField(12, new XTN[0]);
        return retVal;
    }

    public int getHelpDeskContactPointReps() {
        return this.getReps(12);
    }

    public XTN getHelpDeskContactPoint(int rep) {
        XTN retVal = (XTN)this.getTypedField(12, rep);
        return retVal;
    }

    public XTN getErr12_HelpDeskContactPoint(int rep) {
        XTN retVal = (XTN)this.getTypedField(12, rep);
        return retVal;
    }

    public int getErr12_HelpDeskContactPointReps() {
        return this.getReps(12);
    }

    public XTN insertHelpDeskContactPoint(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(12, rep);
    }

    public XTN insertErr12_HelpDeskContactPoint(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(12, rep);
    }

    public XTN removeHelpDeskContactPoint(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(12, rep);
    }

    public XTN removeErr12_HelpDeskContactPoint(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(12, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ELD(this.getMessage());
            }
            case 1: {
                return new ERL(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(516));
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new TX(this.getMessage());
            }
            case 7: {
                return new TX(this.getMessage());
            }
            case 8: {
                return new IS(this.getMessage(), new Integer(517));
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new XTN(this.getMessage());
            }
        }
        return null;
    }
}

