/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DR;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.FN;
import ca.uhn.hl7v2.model.v26.datatype.HD;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.ST;

public class PPN
extends AbstractComposite {
    private Type[] data;

    public PPN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[24];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new FN(this.getMessage());
        this.data[2] = new ST(this.getMessage());
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new ST(this.getMessage());
        this.data[5] = new ST(this.getMessage());
        this.data[6] = new IS(this.getMessage(), 360);
        this.data[7] = new IS(this.getMessage(), 297);
        this.data[8] = new HD(this.getMessage());
        this.data[9] = new ID(this.getMessage(), 200);
        this.data[10] = new ST(this.getMessage());
        this.data[11] = new ID(this.getMessage(), 61);
        this.data[12] = new ID(this.getMessage(), 203);
        this.data[13] = new HD(this.getMessage());
        this.data[14] = new DTM(this.getMessage());
        this.data[15] = new ID(this.getMessage(), 465);
        this.data[16] = new CWE(this.getMessage());
        this.data[17] = new DR(this.getMessage());
        this.data[18] = new ID(this.getMessage(), 444);
        this.data[19] = new DTM(this.getMessage());
        this.data[20] = new DTM(this.getMessage());
        this.data[21] = new ST(this.getMessage());
        this.data[22] = new CWE(this.getMessage());
        this.data[23] = new CWE(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getIDNumber() {
        return this.getTyped(0, ST.class);
    }

    public ST getPpn1_IDNumber() {
        return this.getTyped(0, ST.class);
    }

    public FN getFamilyName() {
        return this.getTyped(1, FN.class);
    }

    public FN getPpn2_FamilyName() {
        return this.getTyped(1, FN.class);
    }

    public ST getGivenName() {
        return this.getTyped(2, ST.class);
    }

    public ST getPpn3_GivenName() {
        return this.getTyped(2, ST.class);
    }

    public ST getSecondAndFurtherGivenNamesOrInitialsThereof() {
        return this.getTyped(3, ST.class);
    }

    public ST getPpn4_SecondAndFurtherGivenNamesOrInitialsThereof() {
        return this.getTyped(3, ST.class);
    }

    public ST getSuffixEgJRorIII() {
        return this.getTyped(4, ST.class);
    }

    public ST getPpn5_SuffixEgJRorIII() {
        return this.getTyped(4, ST.class);
    }

    public ST getPrefixEgDR() {
        return this.getTyped(5, ST.class);
    }

    public ST getPpn6_PrefixEgDR() {
        return this.getTyped(5, ST.class);
    }

    public IS getDegreeEgMD() {
        return this.getTyped(6, IS.class);
    }

    public IS getPpn7_DegreeEgMD() {
        return this.getTyped(6, IS.class);
    }

    public IS getSourceTable() {
        return this.getTyped(7, IS.class);
    }

    public IS getPpn8_SourceTable() {
        return this.getTyped(7, IS.class);
    }

    public HD getAssigningAuthority() {
        return this.getTyped(8, HD.class);
    }

    public HD getPpn9_AssigningAuthority() {
        return this.getTyped(8, HD.class);
    }

    public ID getNameTypeCode() {
        return this.getTyped(9, ID.class);
    }

    public ID getPpn10_NameTypeCode() {
        return this.getTyped(9, ID.class);
    }

    public ST getIdentifierCheckDigit() {
        return this.getTyped(10, ST.class);
    }

    public ST getPpn11_IdentifierCheckDigit() {
        return this.getTyped(10, ST.class);
    }

    public ID getCheckDigitScheme() {
        return this.getTyped(11, ID.class);
    }

    public ID getPpn12_CheckDigitScheme() {
        return this.getTyped(11, ID.class);
    }

    public ID getIdentifierTypeCode() {
        return this.getTyped(12, ID.class);
    }

    public ID getPpn13_IdentifierTypeCode() {
        return this.getTyped(12, ID.class);
    }

    public HD getAssigningFacility() {
        return this.getTyped(13, HD.class);
    }

    public HD getPpn14_AssigningFacility() {
        return this.getTyped(13, HD.class);
    }

    public DTM getDateTimeActionPerformed() {
        return this.getTyped(14, DTM.class);
    }

    public DTM getPpn15_DateTimeActionPerformed() {
        return this.getTyped(14, DTM.class);
    }

    public ID getNameRepresentationCode() {
        return this.getTyped(15, ID.class);
    }

    public ID getPpn16_NameRepresentationCode() {
        return this.getTyped(15, ID.class);
    }

    public CWE getNameContext() {
        return this.getTyped(16, CWE.class);
    }

    public CWE getPpn17_NameContext() {
        return this.getTyped(16, CWE.class);
    }

    public DR getNameValidityRange() {
        return this.getTyped(17, DR.class);
    }

    public DR getPpn18_NameValidityRange() {
        return this.getTyped(17, DR.class);
    }

    public ID getNameAssemblyOrder() {
        return this.getTyped(18, ID.class);
    }

    public ID getPpn19_NameAssemblyOrder() {
        return this.getTyped(18, ID.class);
    }

    public DTM getEffectiveDate() {
        return this.getTyped(19, DTM.class);
    }

    public DTM getPpn20_EffectiveDate() {
        return this.getTyped(19, DTM.class);
    }

    public DTM getExpirationDate() {
        return this.getTyped(20, DTM.class);
    }

    public DTM getPpn21_ExpirationDate() {
        return this.getTyped(20, DTM.class);
    }

    public ST getProfessionalSuffix() {
        return this.getTyped(21, ST.class);
    }

    public ST getPpn22_ProfessionalSuffix() {
        return this.getTyped(21, ST.class);
    }

    public CWE getAssigningJurisdiction() {
        return this.getTyped(22, CWE.class);
    }

    public CWE getPpn23_AssigningJurisdiction() {
        return this.getTyped(22, CWE.class);
    }

    public CWE getAssigningAgencyOrDepartment() {
        return this.getTyped(23, CWE.class);
    }

    public CWE getPpn24_AssigningAgencyOrDepartment() {
        return this.getTyped(23, CWE.class);
    }
}

