/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.OPL_O37_PATIENT;
import ca.uhn.hl7v2.model.v26.group.OPL_O37_PRIOR_RESULT;
import ca.uhn.hl7v2.model.v26.group.OPL_O37_SPECIMEN;
import ca.uhn.hl7v2.model.v26.segment.BLG;
import ca.uhn.hl7v2.model.v26.segment.CTI;
import ca.uhn.hl7v2.model.v26.segment.FT1;
import ca.uhn.hl7v2.model.v26.segment.NK1;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPL_O37_ORDER
extends AbstractGroup {
    public OPL_O37_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NK1.class, true, true, false);
            this.add(OPL_O37_PATIENT.class, false, false, false);
            this.add(OPL_O37_SPECIMEN.class, true, true, false);
            this.add(OPL_O37_PRIOR_RESULT.class, false, false, false);
            this.add(FT1.class, false, true, false);
            this.add(CTI.class, false, true, false);
            this.add(BLG.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OPL_O37_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public NK1 getNK1() {
        NK1 retVal = this.getTyped("NK1", NK1.class);
        return retVal;
    }

    public NK1 getNK1(int rep) {
        NK1 retVal = this.getTyped("NK1", rep, NK1.class);
        return retVal;
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public OPL_O37_PATIENT getPATIENT() {
        OPL_O37_PATIENT retVal = this.getTyped("PATIENT", OPL_O37_PATIENT.class);
        return retVal;
    }

    public OPL_O37_SPECIMEN getSPECIMEN() {
        OPL_O37_SPECIMEN retVal = this.getTyped("SPECIMEN", OPL_O37_SPECIMEN.class);
        return retVal;
    }

    public OPL_O37_SPECIMEN getSPECIMEN(int rep) {
        OPL_O37_SPECIMEN retVal = this.getTyped("SPECIMEN", rep, OPL_O37_SPECIMEN.class);
        return retVal;
    }

    public int getSPECIMENReps() {
        return this.getReps("SPECIMEN");
    }

    public List<OPL_O37_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", OPL_O37_SPECIMEN.class);
    }

    public void insertSPECIMEN(OPL_O37_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", structure, rep);
    }

    public OPL_O37_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (OPL_O37_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public OPL_O37_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (OPL_O37_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }

    public OPL_O37_PRIOR_RESULT getPRIOR_RESULT() {
        OPL_O37_PRIOR_RESULT retVal = this.getTyped("PRIOR_RESULT", OPL_O37_PRIOR_RESULT.class);
        return retVal;
    }

    public FT1 getFT1() {
        FT1 retVal = this.getTyped("FT1", FT1.class);
        return retVal;
    }

    public FT1 getFT1(int rep) {
        FT1 retVal = this.getTyped("FT1", rep, FT1.class);
        return retVal;
    }

    public int getFT1Reps() {
        return this.getReps("FT1");
    }

    public List<FT1> getFT1All() throws HL7Exception {
        return this.getAllAsList("FT1", FT1.class);
    }

    public void insertFT1(FT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("FT1", structure, rep);
    }

    public FT1 insertFT1(int rep) throws HL7Exception {
        return (FT1)super.insertRepetition("FT1", rep);
    }

    public FT1 removeFT1(int rep) throws HL7Exception {
        return (FT1)super.removeRepetition("FT1", rep);
    }

    public CTI getCTI() {
        CTI retVal = this.getTyped("CTI", CTI.class);
        return retVal;
    }

    public CTI getCTI(int rep) {
        CTI retVal = this.getTyped("CTI", rep, CTI.class);
        return retVal;
    }

    public int getCTIReps() {
        return this.getReps("CTI");
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }

    public BLG getBLG() {
        BLG retVal = this.getTyped("BLG", BLG.class);
        return retVal;
    }
}

