/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.EHC_E21_PSL_ITEM_INFO;
import ca.uhn.hl7v2.model.v26.segment.IVC;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EHC_E21
extends AbstractMessage {
    public EHC_E21() {
        this(new DefaultModelClassFactory());
    }

    public EHC_E21(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, true);
            this.add(IVC.class, true, false);
            this.add(EHC_E21_PSL_ITEM_INFO.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E21 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public UAC getUAC(int rep) {
        return this.getTyped("UAC", rep, UAC.class);
    }

    public int getUACReps() {
        return this.getReps("UAC");
    }

    public List<UAC> getUACAll() throws HL7Exception {
        return this.getAllAsList("UAC", UAC.class);
    }

    public void insertUAC(UAC structure, int rep) throws HL7Exception {
        super.insertRepetition("UAC", structure, rep);
    }

    public UAC insertUAC(int rep) throws HL7Exception {
        return (UAC)super.insertRepetition("UAC", rep);
    }

    public UAC removeUAC(int rep) throws HL7Exception {
        return (UAC)super.removeRepetition("UAC", rep);
    }

    public IVC getIVC() {
        return this.getTyped("IVC", IVC.class);
    }

    public EHC_E21_PSL_ITEM_INFO getPSL_ITEM_INFO() {
        return this.getTyped("PSL_ITEM_INFO", EHC_E21_PSL_ITEM_INFO.class);
    }

    public EHC_E21_PSL_ITEM_INFO getPSL_ITEM_INFO(int rep) {
        return this.getTyped("PSL_ITEM_INFO", rep, EHC_E21_PSL_ITEM_INFO.class);
    }

    public int getPSL_ITEM_INFOReps() {
        return this.getReps("PSL_ITEM_INFO");
    }

    public List<EHC_E21_PSL_ITEM_INFO> getPSL_ITEM_INFOAll() throws HL7Exception {
        return this.getAllAsList("PSL_ITEM_INFO", EHC_E21_PSL_ITEM_INFO.class);
    }

    public void insertPSL_ITEM_INFO(EHC_E21_PSL_ITEM_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("PSL_ITEM_INFO", structure, rep);
    }

    public EHC_E21_PSL_ITEM_INFO insertPSL_ITEM_INFO(int rep) throws HL7Exception {
        return (EHC_E21_PSL_ITEM_INFO)super.insertRepetition("PSL_ITEM_INFO", rep);
    }

    public EHC_E21_PSL_ITEM_INFO removePSL_ITEM_INFO(int rep) throws HL7Exception {
        return (EHC_E21_PSL_ITEM_INFO)super.removeRepetition("PSL_ITEM_INFO", rep);
    }
}

