/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.SCV;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class APR
extends AbstractSegment {
    public APR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SCV.class, false, 0, 80, new Object[]{this.getMessage()}, "Time Selection Criteria");
            this.add(SCV.class, false, 0, 80, new Object[]{this.getMessage()}, "Resource Selection Criteria");
            this.add(SCV.class, false, 0, 80, new Object[]{this.getMessage()}, "Location Selection Criteria");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Slot Spacing Criteria");
            this.add(SCV.class, false, 0, 80, new Object[]{this.getMessage()}, "Filler Override Criteria");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating APR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SCV[] getTimeSelectionCriteria() {
        SCV[] retVal = (SCV[])this.getTypedField(1, new SCV[0]);
        return retVal;
    }

    public SCV[] getApr1_TimeSelectionCriteria() {
        SCV[] retVal = (SCV[])this.getTypedField(1, new SCV[0]);
        return retVal;
    }

    public int getTimeSelectionCriteriaReps() {
        return this.getReps(1);
    }

    public SCV getTimeSelectionCriteria(int rep) {
        SCV retVal = (SCV)this.getTypedField(1, rep);
        return retVal;
    }

    public SCV getApr1_TimeSelectionCriteria(int rep) {
        SCV retVal = (SCV)this.getTypedField(1, rep);
        return retVal;
    }

    public int getApr1_TimeSelectionCriteriaReps() {
        return this.getReps(1);
    }

    public SCV insertTimeSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.insertRepetition(1, rep);
    }

    public SCV insertApr1_TimeSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.insertRepetition(1, rep);
    }

    public SCV removeTimeSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.removeRepetition(1, rep);
    }

    public SCV removeApr1_TimeSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.removeRepetition(1, rep);
    }

    public SCV[] getResourceSelectionCriteria() {
        SCV[] retVal = (SCV[])this.getTypedField(2, new SCV[0]);
        return retVal;
    }

    public SCV[] getApr2_ResourceSelectionCriteria() {
        SCV[] retVal = (SCV[])this.getTypedField(2, new SCV[0]);
        return retVal;
    }

    public int getResourceSelectionCriteriaReps() {
        return this.getReps(2);
    }

    public SCV getResourceSelectionCriteria(int rep) {
        SCV retVal = (SCV)this.getTypedField(2, rep);
        return retVal;
    }

    public SCV getApr2_ResourceSelectionCriteria(int rep) {
        SCV retVal = (SCV)this.getTypedField(2, rep);
        return retVal;
    }

    public int getApr2_ResourceSelectionCriteriaReps() {
        return this.getReps(2);
    }

    public SCV insertResourceSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.insertRepetition(2, rep);
    }

    public SCV insertApr2_ResourceSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.insertRepetition(2, rep);
    }

    public SCV removeResourceSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.removeRepetition(2, rep);
    }

    public SCV removeApr2_ResourceSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.removeRepetition(2, rep);
    }

    public SCV[] getLocationSelectionCriteria() {
        SCV[] retVal = (SCV[])this.getTypedField(3, new SCV[0]);
        return retVal;
    }

    public SCV[] getApr3_LocationSelectionCriteria() {
        SCV[] retVal = (SCV[])this.getTypedField(3, new SCV[0]);
        return retVal;
    }

    public int getLocationSelectionCriteriaReps() {
        return this.getReps(3);
    }

    public SCV getLocationSelectionCriteria(int rep) {
        SCV retVal = (SCV)this.getTypedField(3, rep);
        return retVal;
    }

    public SCV getApr3_LocationSelectionCriteria(int rep) {
        SCV retVal = (SCV)this.getTypedField(3, rep);
        return retVal;
    }

    public int getApr3_LocationSelectionCriteriaReps() {
        return this.getReps(3);
    }

    public SCV insertLocationSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.insertRepetition(3, rep);
    }

    public SCV insertApr3_LocationSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.insertRepetition(3, rep);
    }

    public SCV removeLocationSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.removeRepetition(3, rep);
    }

    public SCV removeApr3_LocationSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.removeRepetition(3, rep);
    }

    public NM getSlotSpacingCriteria() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getApr4_SlotSpacingCriteria() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public SCV[] getFillerOverrideCriteria() {
        SCV[] retVal = (SCV[])this.getTypedField(5, new SCV[0]);
        return retVal;
    }

    public SCV[] getApr5_FillerOverrideCriteria() {
        SCV[] retVal = (SCV[])this.getTypedField(5, new SCV[0]);
        return retVal;
    }

    public int getFillerOverrideCriteriaReps() {
        return this.getReps(5);
    }

    public SCV getFillerOverrideCriteria(int rep) {
        SCV retVal = (SCV)this.getTypedField(5, rep);
        return retVal;
    }

    public SCV getApr5_FillerOverrideCriteria(int rep) {
        SCV retVal = (SCV)this.getTypedField(5, rep);
        return retVal;
    }

    public int getApr5_FillerOverrideCriteriaReps() {
        return this.getReps(5);
    }

    public SCV insertFillerOverrideCriteria(int rep) throws HL7Exception {
        return (SCV)super.insertRepetition(5, rep);
    }

    public SCV insertApr5_FillerOverrideCriteria(int rep) throws HL7Exception {
        return (SCV)super.insertRepetition(5, rep);
    }

    public SCV removeFillerOverrideCriteria(int rep) throws HL7Exception {
        return (SCV)super.removeRepetition(5, rep);
    }

    public SCV removeApr5_FillerOverrideCriteria(int rep) throws HL7Exception {
        return (SCV)super.removeRepetition(5, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SCV(this.getMessage());
            }
            case 1: {
                return new SCV(this.getMessage());
            }
            case 2: {
                return new SCV(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new SCV(this.getMessage());
            }
        }
        return null;
    }
}

