/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.ValidationExceptionHandler;
import ca.uhn.hl7v2.validation.ValidationExceptionHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportingValidationExceptionHandler
implements ValidationExceptionHandler<Boolean>,
ValidationExceptionHandlerFactory<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(ReportingValidationExceptionHandler.class);
    private boolean throwFirstException;
    private ValidationException firstException;

    public ReportingValidationExceptionHandler(boolean throwFirstException) {
        this.throwFirstException = throwFirstException;
    }

    @Override
    public void onExceptions(ValidationException ... exceptions) {
        if (this.firstException == null) {
            this.firstException = exceptions[0];
        }
        for (ValidationException ve : exceptions) {
            switch (ve.getSeverity()) {
                case ERROR: {
                    LOG.error("Invalid message", (Throwable)ve);
                }
                case WARNING: {
                    LOG.warn("Message with warnings", (Throwable)ve);
                }
                case INFO: {
                    LOG.info("Message with comments", (Throwable)ve);
                }
            }
        }
    }

    @Override
    public Boolean result() throws HL7Exception {
        if (this.hasFailed() && this.throwFirstException) {
            throw new HL7Exception(this.firstException.getMessage(), this.firstException);
        }
        return !this.hasFailed();
    }

    @Override
    public boolean hasFailed() {
        return this.firstException != null;
    }

    @Override
    public ValidationExceptionHandler<Boolean> getNewInstance(HapiContext context) {
        return new ReportingValidationExceptionHandler(this.throwFirstException);
    }

    @Override
    public void setValidationSubject(Object subject) {
    }
}

