/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataformat;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.processor.MarshalProcessor;
import org.apache.camel.processor.UnmarshalProcessor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ServiceHelper;

@UriEndpoint(scheme="dataformat", title="Data Format", syntax="dataformat:name:operation", producerOnly=true, label="core,transformation")
public class DataFormatEndpoint
extends DefaultEndpoint {
    private MarshalProcessor marshal;
    private UnmarshalProcessor unmarshal;
    private DataFormat dataFormat;
    @UriPath(description="Name of data format")
    @Metadata(required="true")
    private String name;
    @UriPath(enums="marshal,unmarshal")
    @Metadata(required="true")
    private String operation;

    public DataFormatEndpoint() {
    }

    public DataFormatEndpoint(String endpointUri, Component component, DataFormat dataFormat) {
        super(endpointUri, component);
        this.dataFormat = dataFormat;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new DefaultAsyncProducer(this){

            @Override
            public boolean process(Exchange exchange, AsyncCallback callback) {
                if (DataFormatEndpoint.this.marshal != null) {
                    return DataFormatEndpoint.this.marshal.process(exchange, callback);
                }
                return DataFormatEndpoint.this.unmarshal.process(exchange, callback);
            }

            @Override
            public String toString() {
                return "DataFormatProducer[" + DataFormatEndpoint.this.dataFormat + "]";
            }
        };
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from data format");
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.dataFormat == null && this.name != null) {
            this.dataFormat = this.getCamelContext().resolveDataFormat(this.name);
        }
        if (this.operation.equals("marshal")) {
            this.marshal = new MarshalProcessor(this.dataFormat);
            this.marshal.setCamelContext(this.getCamelContext());
        } else {
            this.unmarshal = new UnmarshalProcessor(this.dataFormat);
            this.unmarshal.setCamelContext(this.getCamelContext());
        }
        ServiceHelper.startServices(this.dataFormat, this.marshal, this.unmarshal);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.marshal, this.unmarshal, this.dataFormat);
        super.doStop();
    }
}

