/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.annotation.Export;
import aQute.bnd.annotation.ProviderType;
import aQute.bnd.annotation.Version;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.AnalyzerMessages;
import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.EmbeddedResource;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Macro;
import aQute.bnd.osgi.Packages;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.URLResource;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.bnd.version.VersionRange;
import aQute.lib.base64.Base64;
import aQute.lib.collections.MultiMap;
import aQute.lib.filter.Filter;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.libg.cryptography.Digester;
import aQute.libg.cryptography.MD5;
import aQute.libg.cryptography.SHA1;
import aQute.libg.generics.Create;
import aQute.libg.reporter.ReporterMessages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyzer
extends Processor {
    private final SortedSet<Clazz.JAVA> ees = new TreeSet<Clazz.JAVA>();
    static Properties bndInfo;
    private Jar dot;
    private final Packages contained = new Packages();
    private final Packages referred = new Packages();
    private Packages exports;
    private Packages imports;
    private Descriptors.TypeRef activator;
    private final MultiMap<Descriptors.PackageRef, Descriptors.PackageRef> uses = new MultiMap<Descriptors.PackageRef, Descriptors.PackageRef>(Descriptors.PackageRef.class, Descriptors.PackageRef.class, true);
    private final MultiMap<Descriptors.PackageRef, Descriptors.PackageRef> apiUses = new MultiMap<Descriptors.PackageRef, Descriptors.PackageRef>(Descriptors.PackageRef.class, Descriptors.PackageRef.class, true);
    private final Packages classpathExports = new Packages();
    private final Descriptors descriptors = new Descriptors();
    private final List<Jar> classpath = Create.list();
    private final Map<Descriptors.TypeRef, Clazz> classspace = Create.map();
    private final Map<Descriptors.TypeRef, Clazz> importedClassesCache = Create.map();
    private boolean analyzed = false;
    private boolean diagnostics = false;
    private boolean inited = false;
    protected final AnalyzerMessages msgs = ReporterMessages.base(this, AnalyzerMessages.class);
    static SimpleDateFormat df;
    boolean firstUse = true;
    static Pattern OBJECT_REFERENCE;
    static Pattern fuzzyVersion;
    static Pattern fuzzyVersionRange;
    static Pattern fuzzyModifier;
    static Pattern nummeric;
    static final String DEFAULT_PROVIDER_POLICY = "${range;[==,=+)}";
    static final String DEFAULT_CONSUMER_POLICY = "${range;[==,+)}";
    static String _classesHelp;
    static String _md5Help;
    static String _sha1Help;

    public Analyzer(Processor parent) {
        super(parent);
    }

    public Analyzer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getManifest(File dirOrJar) throws Exception {
        Analyzer analyzer = new Analyzer();
        try {
            analyzer.setJar(dirOrJar);
            Properties properties = new Properties();
            properties.put("Import-Package", "*");
            properties.put("Export-Package", "*");
            analyzer.setProperties(properties);
            Manifest m = analyzer.calcManifest();
            Properties result = new Properties();
            for (Attributes.Name name : m.getMainAttributes().keySet()) {
                result.put(((Object)name).toString(), m.getMainAttributes().getValue(name));
            }
            Properties properties2 = result;
            return properties2;
        }
        finally {
            analyzer.close();
        }
    }

    public void analyze() throws Exception {
        if (!this.analyzed) {
            boolean api;
            this.analyzed = true;
            this.uses.clear();
            this.apiUses.clear();
            this.classspace.clear();
            this.classpathExports.clear();
            this.analyzeBundleClasspath();
            for (Clazz c : this.classspace.values()) {
                this.ees.add(c.getFormat());
            }
            for (Jar current : this.getClasspath()) {
                this.getExternalExports(current, this.classpathExports);
                for (String dir : current.getDirectories().keySet()) {
                    Descriptors.PackageRef packageRef = this.getPackageRef(dir);
                    Resource resource = current.getResource(dir + "/packageinfo");
                    this.getExportVersionsFromPackageInfo(packageRef, resource, this.classpathExports);
                }
            }
            String s = this.getProperty("Bundle-Activator");
            if (s != null) {
                this.activator = this.getTypeRefFromFQN(s);
                this.referTo(this.activator);
                this.trace("activator %s %s", s, this.activator);
            }
            this.doPlugins();
            Jar extra = this.getExtra();
            while (extra != null) {
                this.dot.addAll(extra);
                this.analyzeJar(extra, "", true);
                extra = this.getExtra();
            }
            this.referred.keySet().removeAll(this.contained.keySet());
            Set<Instruction> unused = Create.set();
            Instructions filter = new Instructions(this.getExportPackage());
            filter.append(this.getExportContents());
            this.exports = this.filter(filter, this.contained, unused);
            if (!unused.isEmpty()) {
                this.warning("Unused Export-Package instructions: %s ", unused);
            }
            this.augmentExports(this.exports);
            Packages referredAndExported = new Packages(this.referred);
            referredAndExported.putAll(this.doExportsToImports(this.exports));
            this.removeDynamicImports(referredAndExported);
            Iterator<Descriptors.PackageRef> i = referredAndExported.keySet().iterator();
            while (i.hasNext()) {
                if (!i.next().isJava()) continue;
                i.remove();
            }
            Set<Instruction> unused2 = Create.set();
            String h = this.getProperty("Import-Package");
            if (h == null) {
                h = "*";
            }
            if (this.isPedantic() && h.trim().length() == 0) {
                this.warning("Empty Import-Package header", new Object[0]);
            }
            Instructions filter2 = new Instructions(h);
            this.imports = this.filter(filter2, referredAndExported, unused2);
            if (!(unused2.isEmpty() || unused2.size() == 1 && unused2.iterator().next().toString().equals("*"))) {
                this.warning("Unused Import-Package instructions: %s ", unused2);
            }
            this.augmentImports(this.imports, this.exports);
            if (!Analyzer.isTrue(this.getProperty("-experiments"))) {
                // empty if block
            }
            this.doUses(this.exports, (api = true) ? this.apiUses : this.uses, this.imports);
            Set<Descriptors.PackageRef> privatePackages = this.getPrivates();
            Iterator<Descriptors.PackageRef> p = privatePackages.iterator();
            while (p.hasNext()) {
                if (!p.next().isJava()) continue;
                p.remove();
            }
            for (Descriptors.PackageRef exported : this.exports.keySet()) {
                List used = (List)this.uses.get(exported);
                if (used == null) continue;
                HashSet<Descriptors.PackageRef> privateReferences = new HashSet<Descriptors.PackageRef>((Collection)this.apiUses.get(exported));
                privateReferences.retainAll(privatePackages);
                if (privateReferences.isEmpty()) continue;
                this.msgs.Export_Has_PrivateReferences_(exported, privateReferences.size(), privateReferences);
            }
            if (this.referred.containsKey(Descriptors.DEFAULT_PACKAGE)) {
                this.error("The default package '.' is not permitted by the Import-Package syntax. \n This can be caused by compile errors in Eclipse because Eclipse creates \nvalid class files regardless of compile errors.\nThe following package(s) import from the default package " + this.uses.transpose().get(Descriptors.DEFAULT_PACKAGE), new Object[0]);
            }
        }
    }

    void removeDynamicImports(Packages referredAndExported) {
    }

    protected Jar getExtra() throws Exception {
        return null;
    }

    void doPlugins() {
        for (AnalyzerPlugin plugin : this.getPlugins(AnalyzerPlugin.class)) {
            try {
                Processor previous = this.beginHandleErrors(plugin.toString());
                boolean reanalyze = plugin.analyzeJar(this);
                this.endHandleErrors(previous);
                if (!reanalyze) continue;
                this.classspace.clear();
                this.analyzeBundleClasspath();
            }
            catch (Exception e) {
                this.error("Analyzer Plugin %s failed %s", plugin, e);
            }
        }
    }

    boolean isResourceOnly() {
        return Analyzer.isTrue(this.getProperty("-resourceonly"));
    }

    public Manifest calcManifest() throws Exception {
        try {
            String exportHeader;
            this.analyze();
            Manifest manifest = new Manifest();
            Attributes main = manifest.getMainAttributes();
            main.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            main.putValue("Bundle-ManifestVersion", "2");
            boolean noExtraHeaders = "true".equalsIgnoreCase(this.getProperty("-noextraheaders"));
            if (!noExtraHeaders) {
                main.putValue("Created-By", System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
                main.putValue("Tool", "Bnd-" + this.getBndVersion());
                main.putValue("Bnd-LastModified", "" + System.currentTimeMillis());
            }
            if ((exportHeader = Analyzer.printClauses(this.exports, true)).length() > 0) {
                main.putValue("Export-Package", exportHeader);
            } else {
                main.remove("Export-Package");
            }
            if (!this.imports.isEmpty()) {
                main.putValue("Import-Package", Analyzer.printClauses(this.imports));
            } else {
                main.remove("Import-Package");
            }
            Packages temp = new Packages(this.contained);
            temp.keySet().removeAll(this.exports.keySet());
            if (!temp.isEmpty()) {
                main.putValue("Private-Package", Analyzer.printClauses(temp));
            } else {
                main.remove("Private-Package");
            }
            Parameters bcp = this.getBundleClasspath();
            if (bcp.isEmpty() || bcp.containsKey(".") && bcp.size() == 1) {
                main.remove("Bundle-ClassPath");
            } else {
                main.putValue("Bundle-ClassPath", Analyzer.printClauses(bcp));
            }
            this.doNamesection(this.dot, manifest);
            Enumeration<?> h = this.getProperties().propertyNames();
            while (h.hasMoreElements()) {
                String value;
                String header = (String)h.nextElement();
                if (header.trim().length() == 0) {
                    this.warning("Empty property set with value: " + this.getProperties().getProperty(header), new Object[0]);
                    continue;
                }
                if (this.isMissingPlugin(header.trim())) {
                    this.error("Missing plugin for command %s", header);
                }
                if (!Character.isUpperCase(header.charAt(0))) {
                    if (header.charAt(0) != '@') continue;
                    this.doNameSection(manifest, header);
                    continue;
                }
                if (header.equals("Bundle-ClassPath") || header.equals("Export-Package") || header.equals("Import-Package")) continue;
                if (header.equalsIgnoreCase("Name")) {
                    this.error("Your bnd file contains a header called 'Name'. This interferes with the manifest name section.", new Object[0]);
                    continue;
                }
                if (!Verifier.HEADER_PATTERN.matcher(header).matches() || (value = this.getProperty(header)) == null || main.getValue(header) != null) continue;
                if (value.trim().length() == 0) {
                    main.remove(header);
                    continue;
                }
                if (value.trim().equals("<<EMPTY>>")) {
                    main.putValue(header, "");
                    continue;
                }
                main.putValue(header, value);
            }
            this.merge(manifest, this.dot.getManifest());
            String bsn = this.getBsn();
            if (main.getValue("Bundle-SymbolicName") == null) {
                main.putValue("Bundle-SymbolicName", bsn);
            }
            if (main.getValue("Bundle-Name") == null) {
                main.putValue("Bundle-Name", bsn);
            }
            if (main.getValue("Bundle-Version") == null) {
                main.putValue("Bundle-Version", "0");
            }
            Instructions instructions = new Instructions(this.getProperty("-removeheaders"));
            Collection<Object> result = instructions.select(main.keySet(), false);
            main.keySet().removeAll(result);
            return manifest;
        }
        catch (Exception e) {
            throw new IllegalStateException("Calc manifest failed, state=\n" + this.getFlattenedProperties(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNamesection(Jar dot, Manifest manifest) {
        Parameters namesection = this.parseHeader(this.getProperties().getProperty("-namesection"));
        Instructions instructions = new Instructions(namesection);
        HashSet<String> resources = new HashSet<String>(dot.getResources().keySet());
        for (Map.Entry<Instruction, Attrs> instr : instructions.entrySet()) {
            boolean matched = false;
            Iterator i = resources.iterator();
            while (i.hasNext()) {
                String path = (String)i.next();
                if (!instr.getKey().matches(path)) continue;
                matched = true;
                if (!instr.getKey().isNegated()) {
                    Attributes attrs = manifest.getAttributes(path);
                    if (attrs == null) {
                        attrs = new Attributes();
                        manifest.getEntries().put(path, attrs);
                    }
                    for (Map.Entry<String, String> property : instr.getValue().entrySet()) {
                        this.setProperty("@", path);
                        try {
                            String processed = this.getReplacer().process(property.getValue());
                            attrs.putValue(property.getKey(), processed);
                        }
                        finally {
                            this.unsetProperty("@");
                        }
                    }
                }
                i.remove();
            }
            if (matched || resources.size() <= 0) continue;
            this.warning("The instruction %s in %s did not match any resources", instr.getKey(), "-namesection");
        }
    }

    private void doNameSection(Manifest manifest, String header) {
        String path = header.replace('@', '/');
        int n = path.lastIndexOf(47);
        String name = path.substring(n + 1);
        path = path.substring(1, n);
        if (name.length() != 0 && path.length() != 0) {
            Attributes attrs = manifest.getAttributes(path);
            if (attrs == null) {
                attrs = new Attributes();
                manifest.getEntries().put(path, attrs);
            }
            attrs.putValue(name, this.getProperty(header));
        } else {
            this.warning("Invalid header (starts with @ but does not seem to be for the Name section): %s", header);
        }
    }

    public String getBsn() {
        String value = this.getProperty("Bundle-SymbolicName");
        if (value == null) {
            if (this.getPropertiesFile() != null) {
                value = this.getPropertiesFile().getName();
            }
            String projectName = this.getBase().getName();
            if (value == null || value.equals("bnd.bnd")) {
                value = projectName;
            } else if (value.endsWith(".bnd") && !(value = value.substring(0, value.length() - 4)).startsWith(this.getBase().getName())) {
                value = projectName + "." + value;
            }
        }
        if (value == null) {
            return "untitled";
        }
        int n = value.indexOf(59);
        if (n > 0) {
            value = value.substring(0, n);
        }
        return value.trim();
    }

    public String _bsn(String[] args) {
        return this.getBsn();
    }

    public String calculateExportsFromContents(Jar bundle) {
        String ddel = "";
        StringBuilder sb = new StringBuilder();
        Map<String, Map<String, Resource>> map = bundle.getDirectories();
        for (String directory : map.keySet()) {
            if (directory.equals("META-INF") || directory.startsWith("META-INF/") || directory.equals("OSGI-OPT") || directory.startsWith("OSGI-OPT/") || directory.equals("/")) continue;
            if (directory.endsWith("/")) {
                directory = directory.substring(0, directory.length() - 1);
            }
            directory = directory.replace('/', '.');
            sb.append(ddel);
            sb.append(directory);
            ddel = ",";
        }
        return sb.toString();
    }

    public Packages getContained() {
        return this.contained;
    }

    public Packages getExports() {
        return this.exports;
    }

    public Packages getImports() {
        return this.imports;
    }

    public Set<Descriptors.PackageRef> getPrivates() {
        HashSet<Descriptors.PackageRef> privates = new HashSet<Descriptors.PackageRef>(this.contained.keySet());
        privates.removeAll(this.exports.keySet());
        privates.removeAll(this.imports.keySet());
        return privates;
    }

    public Jar getJar() {
        return this.dot;
    }

    public Packages getReferred() {
        return this.referred;
    }

    public Set<Descriptors.PackageRef> getUnreachable() {
        HashSet<Descriptors.PackageRef> unreachable = new HashSet<Descriptors.PackageRef>(this.uses.keySet());
        for (Descriptors.PackageRef packageRef : this.exports.keySet()) {
            this.removeTransitive(packageRef, unreachable);
        }
        if (this.activator != null) {
            this.removeTransitive(this.activator.getPackageRef(), unreachable);
        }
        return unreachable;
    }

    public Map<Descriptors.PackageRef, List<Descriptors.PackageRef>> getUses() {
        return this.uses;
    }

    public Map<Descriptors.PackageRef, List<Descriptors.PackageRef>> getAPIUses() {
        return this.apiUses;
    }

    public Packages getClasspathExports() {
        return this.classpathExports;
    }

    public String getBndVersion() {
        return this.getBndInfo("version", "<unknown>");
    }

    public long getBndLastModified() {
        String time = this.getBndInfo("lastmodified", "0");
        if (time.matches("\\d+")) {
            return Long.parseLong(time);
        }
        try {
            Date parse = df.parse(time);
            if (parse != null) {
                return parse.getTime();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBndInfo(String key, String defaultValue) {
        String value;
        if (bndInfo == null) {
            try {
                Properties bndInfoLocal = new Properties();
                URL url = Analyzer.class.getResource("bnd.info");
                if (url != null) {
                    InputStream in = url.openStream();
                    try {
                        bndInfoLocal.load(in);
                    }
                    finally {
                        in.close();
                    }
                }
                bndInfo = bndInfoLocal;
            }
            catch (Exception e) {
                e.printStackTrace();
                return defaultValue;
            }
        }
        if ((value = bndInfo.getProperty(key)) == null) {
            return defaultValue;
        }
        return value;
    }

    public void mergeManifest(Manifest manifest) throws IOException {
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            for (Attributes.Name name : attributes.keySet()) {
                String key = ((Object)name).toString();
                if (key.startsWith("-") || this.getProperty(key) != null) continue;
                this.setProperty(key, attributes.getValue(name));
            }
        }
    }

    @Override
    public void setBase(File file) {
        super.setBase(file);
        this.getProperties().put("project.dir", this.getBase().getAbsolutePath());
    }

    public void setClasspath(File[] classpath) throws IOException {
        ArrayList<Jar> list = new ArrayList<Jar>();
        for (int i = 0; i < classpath.length; ++i) {
            if (classpath[i].exists()) {
                Jar current = new Jar(classpath[i]);
                list.add(current);
                continue;
            }
            this.error("Missing file on classpath: %s", classpath[i]);
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            this.addClasspath((Jar)i.next());
        }
    }

    public void setClasspath(Jar[] classpath) {
        for (int i = 0; i < classpath.length; ++i) {
            this.addClasspath(classpath[i]);
        }
    }

    public void setClasspath(String[] classpath) {
        for (int i = 0; i < classpath.length; ++i) {
            Jar jar = this.getJarFromName(classpath[i], " setting classpath");
            if (jar == null) continue;
            this.addClasspath(jar);
        }
    }

    public Jar setJar(File jar) throws IOException {
        Jar jarx = new Jar(jar);
        this.addClose(jarx);
        return this.setJar(jarx);
    }

    public Jar setJar(Jar jar) {
        if (this.dot != null) {
            this.removeClose(this.dot);
        }
        this.dot = jar;
        if (this.dot != null) {
            this.addClose(this.dot);
        }
        return jar;
    }

    @Override
    protected void begin() {
        if (!this.inited) {
            this.inited = true;
            super.begin();
            this.updateModified(this.getBndLastModified(), "bnd last modified");
            this.verifyManifestHeadersCase(this.getProperties());
        }
    }

    Jar getJarFromName(String name, String from) {
        File file = new File(name);
        if (!file.isAbsolute()) {
            file = new File(this.getBase(), name);
        }
        if (file.exists()) {
            try {
                Jar jar = new Jar(file);
                this.addClose(jar);
                return jar;
            }
            catch (Exception e) {
                this.error("Exception in parsing jar file for " + from + ": " + name + " " + e, new Object[0]);
            }
        }
        try {
            URL url = new URL(name);
            Jar jar = new Jar(this.fileName(url.getPath()));
            this.addClose(jar);
            URLConnection connection = url.openConnection();
            InputStream in = connection.getInputStream();
            long lastModified = connection.getLastModified();
            if (lastModified == 0L) {
                lastModified = System.currentTimeMillis();
            }
            EmbeddedResource.build(jar, in, lastModified);
            in.close();
            return jar;
        }
        catch (IOException ee) {
            for (Jar entry : this.getClasspath()) {
                if (entry.getSource() == null || !entry.getSource().getName().equals(name)) continue;
                return entry;
            }
            return null;
        }
    }

    private String fileName(String path) {
        int n = path.lastIndexOf(47);
        if (n > 0) {
            return path.substring(n + 1);
        }
        return path;
    }

    private void merge(Manifest result, Manifest old) {
        if (old != null) {
            for (Map.Entry<Object, Object> entry : old.getMainAttributes().entrySet()) {
                Attributes.Name name = (Attributes.Name)entry.getKey();
                String value = (String)entry.getValue();
                if (((Object)name).toString().equalsIgnoreCase("Created-By")) {
                    name = new Attributes.Name("Originally-Created-By");
                }
                if (result.getMainAttributes().containsKey(name)) continue;
                result.getMainAttributes().put(name, value);
            }
            Map<String, Attributes> oldEntries = old.getEntries();
            Map<String, Attributes> newEntries = result.getEntries();
            for (Map.Entry<String, Attributes> entry : oldEntries.entrySet()) {
                if (newEntries.containsKey(entry.getKey())) continue;
                newEntries.put(entry.getKey(), entry.getValue());
            }
        }
    }

    void verifyManifestHeadersCase(Properties properties) {
        block0: for (String string : properties.keySet()) {
            for (int j = 0; j < headers.length; ++j) {
                if (headers[j].equals(string) || !headers[j].equalsIgnoreCase(string)) continue;
                this.warning("Using a standard OSGi header with the wrong case (bnd is case sensitive!), using: " + string + " and expecting: " + headers[j], new Object[0]);
                continue block0;
            }
        }
    }

    Packages doExportsToImports(Packages exports) {
        HashSet<Descriptors.PackageRef> privatePackages = new HashSet<Descriptors.PackageRef>(this.contained.keySet());
        privatePackages.removeAll(exports.keySet());
        Set privateReferences = this.newSet();
        for (Descriptors.PackageRef p : privatePackages) {
            Collection uses = (Collection)this.uses.get(p);
            if (uses == null) continue;
            privateReferences.addAll(uses);
        }
        HashSet<Descriptors.PackageRef> toBeImported = new HashSet<Descriptors.PackageRef>(exports.keySet());
        toBeImported.retainAll(privateReferences);
        Iterator i = toBeImported.iterator();
        block1: while (i.hasNext()) {
            Descriptors.PackageRef next = (Descriptors.PackageRef)i.next();
            Collection usedByExportedPackage = (Collection)this.uses.get(next);
            if (usedByExportedPackage == null || usedByExportedPackage.isEmpty()) continue;
            for (Descriptors.PackageRef privatePackage : privatePackages) {
                if (!usedByExportedPackage.contains(privatePackage)) continue;
                i.remove();
                continue block1;
            }
        }
        Packages result = new Packages();
        for (Descriptors.PackageRef ep : toBeImported) {
            String noimport;
            Attrs parameters = exports.get(ep);
            String string = noimport = parameters == null ? null : parameters.get("-noimport:");
            if (noimport != null && noimport.equalsIgnoreCase("true")) continue;
            parameters = new Attrs(new Attrs[0]);
            parameters.remove("version");
            result.put(ep, parameters);
        }
        return result;
    }

    public boolean referred(Descriptors.PackageRef packageName) {
        for (Map.Entry contained : this.uses.entrySet()) {
            if (((Descriptors.PackageRef)contained.getKey()).equals(packageName) || !((List)contained.getValue()).contains(packageName)) continue;
            return true;
        }
        return false;
    }

    private void getExternalExports(Jar jar, Packages classpathExports) {
        try {
            Manifest m = jar.getManifest();
            if (m != null) {
                Domain domain = Domain.domain(m);
                Parameters exported = domain.getExportPackage();
                for (Map.Entry<String, Attrs> e : exported.entrySet()) {
                    Descriptors.PackageRef ref = this.getPackageRef(e.getKey());
                    if (classpathExports.containsKey(ref)) continue;
                    classpathExports.put(ref, e.getValue());
                }
            }
        }
        catch (Exception e) {
            this.warning("Erroneous Manifest for " + jar + " " + e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void augmentImports(Packages imports, Packages exports) throws Exception {
        List noimports = Create.list();
        Set<Descriptors.PackageRef> provided = this.findProvidedPackages();
        for (Descriptors.PackageRef packageRef : imports.keySet()) {
            String packageName = packageRef.getFQN();
            this.setProperty("@package", packageName);
            try {
                String mandatory;
                Attrs importAttributes = imports.get(packageRef);
                Attrs exportAttributes = exports.get(packageRef, this.classpathExports.get(packageRef, new Attrs(new Attrs[0])));
                String exportVersion = exportAttributes.getVersion();
                String importRange = importAttributes.getVersion();
                if (exportVersion != null) {
                    boolean provider = Analyzer.isTrue(importAttributes.get("provide:")) || Analyzer.isTrue(exportAttributes.get("provide:")) || provided.contains(packageRef);
                    exportVersion = Analyzer.cleanupVersion(exportVersion);
                    try {
                        this.setProperty("@", exportVersion);
                        if (importRange != null) {
                            importRange = Analyzer.cleanupVersion(importRange);
                            importRange = this.getReplacer().process(importRange);
                        } else {
                            importRange = this.getVersionPolicy(provider);
                        }
                    }
                    finally {
                        this.unsetProperty("@");
                    }
                    importAttributes.put("version", importRange);
                }
                if ((mandatory = exportAttributes.get("mandatory:")) != null) {
                    String[] attrs = mandatory.split("\\s*,\\s*");
                    for (int i = 0; i < attrs.length; ++i) {
                        if (importAttributes.containsKey(attrs[i])) continue;
                        importAttributes.put(attrs[i], exportAttributes.get(attrs[i]));
                    }
                }
                if (exportAttributes.containsKey("-import:")) {
                    importAttributes.put("-import:", exportAttributes.get("-import:"));
                }
                this.fixupAttributes(importAttributes);
                this.removeAttributes(importAttributes);
                String result = importAttributes.get("version");
                if (result != null) continue;
                noimports.add(packageRef);
            }
            finally {
                this.unsetProperty("@package");
            }
        }
        if (this.isPedantic() && noimports.size() != 0) {
            this.warning("Imports that lack version ranges: %s", noimports);
        }
    }

    Set<Descriptors.PackageRef> findProvidedPackages() throws Exception {
        Set<Descriptors.PackageRef> providers = Create.set();
        Set cached = Create.set();
        for (Clazz c : this.classspace.values()) {
            Descriptors.TypeRef[] interfaces = c.getInterfaces();
            if (interfaces == null) continue;
            for (Descriptors.TypeRef t : interfaces) {
                if (!cached.contains(t) && !this.isProvider(t)) continue;
                cached.add(t);
                providers.add(t.getPackageRef());
            }
        }
        return providers;
    }

    private boolean isProvider(Descriptors.TypeRef t) throws Exception {
        Clazz c = this.findClass(t);
        if (c == null) {
            return false;
        }
        if (c.annotations == null) {
            return false;
        }
        Descriptors.TypeRef pt = this.getTypeRefFromFQN(ProviderType.class.getName());
        boolean result = c.annotations.contains(pt);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void augmentExports(Packages exports) {
        for (Descriptors.PackageRef packageRef : exports.keySet()) {
            String packageName = packageRef.getFQN();
            this.setProperty("@package", packageName);
            try {
                Attrs attributes = exports.get(packageRef);
                Attrs exporterAttributes = this.classpathExports.get(packageRef);
                if (exporterAttributes == null) continue;
                for (Map.Entry<String, String> entry : exporterAttributes.entrySet()) {
                    String key = entry.getKey();
                    if (key.equalsIgnoreCase("specification-version")) {
                        key = "version";
                    }
                    if (key.endsWith(":") || attributes.containsKey(key)) continue;
                    attributes.put(key, entry.getValue());
                }
                this.fixupAttributes(attributes);
                this.removeAttributes(attributes);
            }
            finally {
                this.unsetProperty("@package");
            }
        }
    }

    void fixupAttributes(Attrs attributes) {
        for (String key : attributes.keySet()) {
            String value = attributes.get(key);
            if (value.indexOf(36) < 0) continue;
            value = this.getReplacer().process(value);
            attributes.put(key, value);
        }
    }

    void removeAttributes(Attrs attributes) {
        String remove = attributes.remove("-remove-attribute:");
        if (remove != null) {
            Instructions removeInstr = new Instructions(remove);
            attributes.keySet().removeAll(removeInstr.select(attributes.keySet(), false));
        }
        Iterator<Map.Entry<String, String>> i = attributes.entrySet().iterator();
        while (i.hasNext()) {
            String v = i.next().getValue();
            if (!v.equals("!")) continue;
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String calculateVersionRange(String version, boolean impl) {
        this.setProperty("@", version);
        try {
            String string = this.getVersionPolicy(impl);
            return string;
        }
        finally {
            this.unsetProperty("@");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUses(Packages exports, Map<Descriptors.PackageRef, List<Descriptors.PackageRef>> uses, Packages imports) {
        if ("true".equalsIgnoreCase(this.getProperty("-nouses"))) {
            return;
        }
        for (Descriptors.PackageRef packageRef : exports.keySet()) {
            String packageName = packageRef.getFQN();
            this.setProperty("@package", packageName);
            try {
                this.doUses(packageRef, exports, uses, imports);
            }
            finally {
                this.unsetProperty("@package");
            }
        }
    }

    protected void doUses(Descriptors.PackageRef packageRef, Packages exports, Map<Descriptors.PackageRef, List<Descriptors.PackageRef>> uses, Packages imports) {
        Collection usedPackages;
        Attrs clause = exports.get(packageRef);
        String override = clause.get("uses:");
        if (override == null) {
            override = "<<USES>>";
        }
        if ((usedPackages = (Collection)uses.get(packageRef)) != null) {
            TreeSet<Descriptors.PackageRef> sharedPackages = new TreeSet<Descriptors.PackageRef>();
            sharedPackages.addAll(imports.keySet());
            sharedPackages.addAll(exports.keySet());
            sharedPackages.retainAll(usedPackages);
            sharedPackages.remove(packageRef);
            StringBuilder sb = new StringBuilder();
            String del = "";
            for (Descriptors.PackageRef usedPackage : sharedPackages) {
                if (usedPackage.isJava()) continue;
                sb.append(del);
                sb.append(usedPackage.getFQN());
                del = ",";
            }
            if (override.indexOf(36) >= 0) {
                this.setProperty("@uses", sb.toString());
                override = this.getReplacer().process(override);
                this.unsetProperty("@uses");
            } else {
                override = override.replaceAll("<<USES>>", Matcher.quoteReplacement(sb.toString())).trim();
            }
            if (override.endsWith(",")) {
                override = override.substring(0, override.length() - 1);
            }
            if (override.startsWith(",")) {
                override = override.substring(1);
            }
            if (override.length() > 0) {
                clause.put("uses:", override);
            }
        }
    }

    void removeTransitive(Descriptors.PackageRef name, Set<Descriptors.PackageRef> unreachable) {
        if (!unreachable.contains(name)) {
            return;
        }
        unreachable.remove(name);
        List ref = (List)this.uses.get(name);
        if (ref != null) {
            for (Descriptors.PackageRef element : ref) {
                this.removeTransitive(element, unreachable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getExportVersionsFromPackageInfo(Descriptors.PackageRef packageRef, Resource r, Packages classpathExports) throws Exception {
        if (r == null) {
            return;
        }
        Properties p = new Properties();
        try {
            InputStream in = r.openInputStream();
            try {
                p.load(in);
            }
            finally {
                in.close();
            }
            Attrs map = classpathExports.get(packageRef);
            if (map == null) {
                map = new Attrs(new Attrs[0]);
                classpathExports.put(packageRef, map);
            }
            Enumeration<?> t = p.propertyNames();
            while (t.hasMoreElements()) {
                String key = (String)t.nextElement();
                String value = map.get(key);
                if (value != null) continue;
                value = p.getProperty(key);
                if (value.startsWith(":")) {
                    key = key + ":";
                    value = value.substring(1);
                }
                map.put(key, value);
            }
        }
        catch (Exception e) {
            this.msgs.NoSuchFile_(r);
        }
    }

    @Override
    public void close() {
        if (this.diagnostics) {
            PrintStream out = System.err;
            out.printf("Current directory            : %s%n", new File("").getAbsolutePath());
            out.println("Classpath used");
            for (Jar jar : this.getClasspath()) {
                out.printf("File                                : %s%n", jar.getSource());
                out.printf("File abs path                       : %s%n", jar.getSource().getAbsolutePath());
                out.printf("Name                                : %s%n", jar.getName());
                Map<String, Map<String, Resource>> dirs = jar.getDirectories();
                for (Map.Entry<String, Map<String, Resource>> entry : dirs.entrySet()) {
                    Map<String, Resource> dir = entry.getValue();
                    String name = entry.getKey().replace('/', '.');
                    if (dir != null) {
                        out.printf("                                      %-30s %d%n", name, dir.size());
                        continue;
                    }
                    out.printf("                                      %-30s <<empty>>%n", name);
                }
            }
        }
        super.close();
        if (this.dot != null) {
            this.dot.close();
        }
        if (this.classpath != null) {
            for (Jar jar : this.classpath) {
                jar.close();
            }
        }
    }

    public String _findpath(String[] args) {
        return this.findPath("findpath", args, true);
    }

    public String _findname(String[] args) {
        return this.findPath("findname", args, false);
    }

    String findPath(String name, String[] args, boolean fullPathName) {
        if (args.length > 3) {
            this.warning("Invalid nr of arguments to " + name + " " + Arrays.asList(args) + ", syntax: ${" + name + " (; reg-expr (; replacement)? )? }", new Object[0]);
            return null;
        }
        String regexp = ".*";
        String replace = null;
        switch (args.length) {
            case 3: {
                replace = args[2];
            }
            case 2: {
                regexp = args[1];
            }
        }
        StringBuilder sb = new StringBuilder();
        String del = "";
        Pattern expr = Pattern.compile(regexp);
        for (String path : this.dot.getResources().keySet()) {
            Matcher m;
            int n;
            if (!fullPathName && (n = path.lastIndexOf(47)) >= 0) {
                path = path.substring(n + 1);
            }
            if (!(m = expr.matcher(path)).matches()) continue;
            if (replace != null) {
                path = m.replaceAll(replace);
            }
            sb.append(del);
            sb.append(path);
            del = ", ";
        }
        return sb.toString();
    }

    public void putAll(Map<String, String> additional, boolean force) {
        for (Map.Entry<String, String> entry : additional.entrySet()) {
            if (!force && this.getProperties().get(entry.getKey()) != null) continue;
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public List<Jar> getClasspath() {
        if (this.firstUse) {
            this.firstUse = false;
            String cp = this.getProperty("-classpath");
            if (cp != null) {
                for (String s : Analyzer.split(cp)) {
                    Jar jar = this.getJarFromName(s, "getting classpath");
                    if (jar != null) {
                        this.addClasspath(jar);
                        continue;
                    }
                    this.warning("Cannot find entry on -classpath: %s", s);
                }
            }
        }
        return this.classpath;
    }

    public void addClasspath(Jar jar) {
        if (this.isPedantic() && jar.getResources().isEmpty()) {
            this.warning("There is an empty jar or directory on the classpath: " + jar.getName(), new Object[0]);
        }
        this.classpath.add(jar);
    }

    public void addClasspath(Collection<?> jars) throws IOException {
        for (Object jar : jars) {
            if (jar instanceof Jar) {
                this.addClasspath((Jar)jar);
                continue;
            }
            if (jar instanceof File) {
                this.addClasspath((File)jar);
                continue;
            }
            if (jar instanceof String) {
                this.addClasspath(this.getFile((String)jar));
                continue;
            }
            this.error("Cannot convert to JAR to add to classpath %s. Not a File, Jar, or String", jar);
        }
    }

    public void addClasspath(File cp) throws IOException {
        if (!cp.exists()) {
            this.warning("File on classpath that does not exist: " + cp, new Object[0]);
        }
        Jar jar = new Jar(cp);
        this.addClose(jar);
        this.classpath.add(jar);
    }

    @Override
    public void clear() {
        this.classpath.clear();
    }

    public Jar getTarget() {
        return this.dot;
    }

    private void analyzeBundleClasspath() throws Exception {
        Parameters bcp = this.getBundleClasspath();
        if (bcp.isEmpty()) {
            this.analyzeJar(this.dot, "", true);
        } else {
            boolean okToIncludeDirs = true;
            for (String path : bcp.keySet()) {
                if (!this.dot.getDirectories().containsKey(path)) continue;
                okToIncludeDirs = false;
                break;
            }
            for (String path : bcp.keySet()) {
                Attrs info = bcp.get(path);
                if (path.equals(".")) {
                    this.analyzeJar(this.dot, "", okToIncludeDirs);
                    continue;
                }
                Resource resource = this.dot.getResource(path);
                if (resource != null) {
                    try {
                        Jar jar = new Jar(path);
                        this.addClose(jar);
                        EmbeddedResource.build(jar, resource);
                        this.analyzeJar(jar, "", true);
                    }
                    catch (Exception e) {
                        this.warning("Invalid bundle classpath entry: " + path + " " + e, new Object[0]);
                    }
                    continue;
                }
                if (this.dot.getDirectories().containsKey(path)) {
                    if (bcp.containsKey(".")) {
                        this.warning("Bundle-ClassPath uses a directory '%s' as well as '.'. This means bnd does not know if a directory is a package.", path, path);
                    }
                    this.analyzeJar(this.dot, Processor.appendPath(path) + "/", true);
                    continue;
                }
                if ("optional".equals(info.get("resolution:"))) continue;
                this.warning("No sub JAR or directory " + path, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean analyzeJar(Jar jar, String prefix, boolean okToIncludeDirs) throws Exception {
        HashMap<String, Clazz> mismatched = new HashMap<String, Clazz>();
        for (String path : jar.getResources().keySet()) {
            Clazz clazz;
            if (!path.startsWith(prefix)) continue;
            String relativePath = path.substring(prefix.length());
            if (okToIncludeDirs) {
                String relativeDir;
                Descriptors.PackageRef packageRef;
                int n = relativePath.lastIndexOf(47);
                if (n < 0) {
                    n = relativePath.length();
                }
                if (!(packageRef = this.getPackageRef(relativeDir = relativePath.substring(0, n))).isMetaData() && !this.contained.containsKey(packageRef)) {
                    this.contained.put(packageRef);
                    if (!packageRef.isMetaData()) {
                        Resource pinfo = jar.getResource(prefix + packageRef.getPath() + "/packageinfo");
                        this.getExportVersionsFromPackageInfo(packageRef, pinfo, this.classpathExports);
                    }
                }
            }
            if (!path.endsWith(".class")) continue;
            Resource resource = jar.getResource(path);
            Attrs info = null;
            try {
                InputStream in = resource.openInputStream();
                clazz = new Clazz(this, path, resource);
                try {
                    if (relativePath.endsWith("/package-info.class")) {
                        info = new Attrs(new Attrs[0]);
                        this.parsePackageInfoClass(clazz, info);
                    } else {
                        clazz.parseClassFile();
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (Throwable e) {
                this.error("Invalid class file %s (%s)", e, relativePath, e);
                e.printStackTrace();
                continue;
            }
            String calculatedPath = clazz.getClassName().getPath();
            if (!calculatedPath.equals(relativePath)) {
                if (!okToIncludeDirs) continue;
                mismatched.put(clazz.getAbsolutePath(), clazz);
                continue;
            }
            this.classspace.put(clazz.getClassName(), clazz);
            Descriptors.PackageRef packageRef = clazz.getClassName().getPackageRef();
            if (!this.contained.containsKey(packageRef)) {
                this.contained.put(packageRef);
                if (!packageRef.isMetaData()) {
                    Resource pinfo = jar.getResource(prefix + packageRef.getPath() + "/packageinfo");
                    this.getExportVersionsFromPackageInfo(packageRef, pinfo, this.classpathExports);
                }
            }
            if (info != null) {
                this.contained.merge(packageRef, false, info);
            }
            Set refs = Create.set();
            for (Descriptors.PackageRef p : clazz.getReferred()) {
                this.referred.put(p);
                refs.add(p);
            }
            refs.remove(packageRef);
            this.uses.addAll(packageRef, refs);
            this.apiUses.addAll(packageRef, clazz.getAPIUses());
        }
        if (mismatched.size() > 0) {
            this.error("Classes found in the wrong directory: %s", mismatched);
            return false;
        }
        return true;
    }

    private void parsePackageInfoClass(final Clazz clazz, final Attrs info) throws Exception {
        clazz.parseClassFileWithCollector(new ClassDataCollector(){

            public void annotation(Annotation a) {
                String name = a.name.getFQN();
                if (Version.class.getName().equals(name)) {
                    String version = (String)a.get("value");
                    if (!info.containsKey("version")) {
                        if (version != null) {
                            version = Analyzer.this.getReplacer().process(version);
                            if (Verifier.VERSION.matcher(version).matches()) {
                                info.put("version", version);
                            } else {
                                Analyzer.this.error("Export annotation in %s has invalid version info: %s", clazz, version);
                            }
                        }
                    } else {
                        String presentVersion = info.get("version");
                        try {
                            aQute.bnd.version.Version av = new aQute.bnd.version.Version(presentVersion);
                            aQute.bnd.version.Version bv = new aQute.bnd.version.Version(version);
                            if (!av.equals(bv)) {
                                Analyzer.this.error("Version from annotation for %s differs with packageinfo or Manifest", clazz.getClassName().getFQN());
                            }
                        }
                        catch (Exception e) {}
                    }
                } else if (name.equals(Export.class.getName())) {
                    Object[] uses;
                    Object[] excluded;
                    Object[] included;
                    Attrs attrs = Processor.doAttrbutes((Object[])a.get("mandatory"), clazz, Analyzer.this.getReplacer());
                    if (!attrs.isEmpty()) {
                        info.putAll(attrs);
                        info.put("mandatory:", Processor.join(attrs.keySet()));
                    }
                    if (!(attrs = Processor.doAttrbutes((Object[])a.get("optional"), clazz, Analyzer.this.getReplacer())).isEmpty()) {
                        info.putAll(attrs);
                    }
                    if ((included = (Object[])a.get("include")) != null && included.length > 0) {
                        StringBuilder sb = new StringBuilder();
                        String del = "";
                        for (Object i : included) {
                            Matcher m = OBJECT_REFERENCE.matcher((String)i);
                            if (!m.matches()) continue;
                            sb.append(del);
                            sb.append(m.group(2));
                            del = ",";
                        }
                        info.put("include:", sb.toString());
                    }
                    if ((excluded = (Object[])a.get("exclude")) != null && excluded.length > 0) {
                        StringBuilder sb = new StringBuilder();
                        String del = "";
                        for (Object i : excluded) {
                            Matcher m = OBJECT_REFERENCE.matcher((String)i);
                            if (!m.matches()) continue;
                            sb.append(del);
                            sb.append(m.group(2));
                            del = ",";
                        }
                        info.put("exclude:", sb.toString());
                    }
                    if ((uses = (Object[])a.get("uses")) != null && uses.length > 0) {
                        StringBuilder sb;
                        String old = info.get("uses:");
                        if (old == null) {
                            old = "";
                        }
                        String del = (sb = new StringBuilder(old)).length() == 0 ? "" : ",";
                        for (Object use : uses) {
                            sb.append(del);
                            sb.append(use);
                            del = ",";
                        }
                        info.put("uses:", sb.toString());
                    }
                }
            }
        });
    }

    public static String cleanupVersion(String version) {
        Matcher m = Verifier.VERSIONRANGE.matcher(version);
        if (m.matches()) {
            try {
                VersionRange vr = new VersionRange(version);
                return version;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((m = fuzzyVersionRange.matcher(version)).matches()) {
            String prefix = m.group(1);
            String first = m.group(2);
            String last = m.group(3);
            String suffix = m.group(4);
            return prefix + Analyzer.cleanupVersion(first) + "," + Analyzer.cleanupVersion(last) + suffix;
        }
        m = fuzzyVersion.matcher(version);
        if (m.matches()) {
            StringBuilder result = new StringBuilder();
            String major = Analyzer.removeLeadingZeroes(m.group(1));
            String minor = Analyzer.removeLeadingZeroes(m.group(3));
            String micro = Analyzer.removeLeadingZeroes(m.group(5));
            String qualifier = m.group(7);
            if (qualifier == null) {
                if (!Analyzer.isInteger(minor)) {
                    qualifier = minor;
                    minor = "0";
                } else if (!Analyzer.isInteger(micro)) {
                    qualifier = micro;
                    micro = "0";
                }
            }
            if (major != null) {
                result.append(major);
                if (minor != null) {
                    result.append(".");
                    result.append(minor);
                    if (micro != null) {
                        result.append(".");
                        result.append(micro);
                        if (qualifier != null) {
                            result.append(".");
                            Analyzer.cleanupModifier(result, qualifier);
                        }
                    } else if (qualifier != null) {
                        result.append(".0.");
                        Analyzer.cleanupModifier(result, qualifier);
                    }
                } else if (qualifier != null) {
                    result.append(".0.0.");
                    Analyzer.cleanupModifier(result, qualifier);
                }
                return result.toString();
            }
        }
        return version;
    }

    private static boolean isInteger(String minor) {
        return minor.length() < 10 || minor.length() == 10 && minor.compareTo("2147483647") < 0;
    }

    private static String removeLeadingZeroes(String group) {
        int n;
        if (group == null) {
            return "0";
        }
        for (n = 0; n < group.length() - 1 && group.charAt(n) == '0'; ++n) {
        }
        if (n == 0) {
            return group;
        }
        return group.substring(n);
    }

    static void cleanupModifier(StringBuilder result, String modifier) {
        Matcher m = fuzzyModifier.matcher(modifier);
        if (m.matches()) {
            modifier = m.group(2);
        }
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') && c != '-') continue;
            result.append(c);
        }
    }

    public String getVersionPolicy(boolean implemented) {
        if (implemented) {
            return this.getProperty("-provider-policy", DEFAULT_PROVIDER_POLICY);
        }
        return this.getProperty("-consumer-policy", DEFAULT_CONSUMER_POLICY);
    }

    public String _classes(String ... args) throws Exception {
        Collection<Clazz> matched = this.getClasses(args);
        if (matched.isEmpty()) {
            return "";
        }
        return Analyzer.join(matched);
    }

    public Collection<Clazz> getClasses(String ... args) throws Exception {
        HashSet<Clazz> matched = new HashSet<Clazz>(this.classspace.values());
        for (int i = 1; i < args.length; ++i) {
            if (args.length < i + 1) {
                throw new IllegalArgumentException("${classes} macro must have odd number of arguments. " + _classesHelp);
            }
            String typeName = args[i];
            if (typeName.equalsIgnoreCase("extending")) {
                typeName = "extends";
            } else if (typeName.equalsIgnoreCase("importing")) {
                typeName = "imports";
            } else if (typeName.equalsIgnoreCase("annotation")) {
                typeName = "annotated";
            } else if (typeName.equalsIgnoreCase("implementing")) {
                typeName = "implements";
            }
            Clazz.QUERY type = Clazz.QUERY.valueOf(typeName.toUpperCase());
            if (type == null) {
                throw new IllegalArgumentException("${classes} has invalid type: " + typeName + ". " + _classesHelp);
            }
            Instruction instr = null;
            if (Clazz.HAS_ARGUMENT.contains((Object)type)) {
                String s = args[++i];
                instr = new Instruction(s);
            }
            Iterator c = matched.iterator();
            while (c.hasNext()) {
                Clazz clazz = (Clazz)c.next();
                if (clazz.is(type, instr, this)) continue;
                c.remove();
            }
        }
        return matched;
    }

    public String _exporters(String[] args) throws Exception {
        Macro.verifyCommand(args, "${exporters;<packagename>}, returns the list of jars that export the given package", null, 2, 2);
        StringBuilder sb = new StringBuilder();
        String del = "";
        String pack = args[1].replace('.', '/');
        for (Jar jar : this.classpath) {
            if (!jar.getDirectories().containsKey(pack)) continue;
            sb.append(del);
            sb.append(jar.getName());
        }
        return sb.toString();
    }

    public Map<Descriptors.TypeRef, Clazz> getClassspace() {
        return this.classspace;
    }

    public Resource findResource(String path) {
        for (Jar entry : this.getClasspath()) {
            Resource r = entry.getResource(path);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public Clazz findClass(Descriptors.TypeRef typeRef) throws Exception {
        Clazz c = this.classspace.get(typeRef);
        if (c != null) {
            return c;
        }
        c = this.importedClassesCache.get(typeRef);
        if (c != null) {
            return c;
        }
        Resource r = this.findResource(typeRef.getPath());
        if (r == null) {
            this.getClass().getClassLoader();
            URL url = ClassLoader.getSystemResource(typeRef.getPath());
            if (url != null) {
                r = new URLResource(url);
            }
        }
        if (r != null) {
            c = new Clazz(this, typeRef.getPath(), r);
            c.parseClassFile();
            this.importedClassesCache.put(typeRef, c);
        }
        return c;
    }

    public String getVersion() {
        String version = this.getProperty("Bundle-Version");
        if (version == null) {
            version = "0.0.0";
        }
        return version;
    }

    public boolean isNoBundle() {
        return Analyzer.isTrue(this.getProperty("-resourceonly")) || Analyzer.isTrue(this.getProperty("-nomanifest"));
    }

    public void referTo(Descriptors.TypeRef ref) {
        Descriptors.PackageRef pack = ref.getPackageRef();
        if (!this.referred.containsKey(pack)) {
            this.referred.put(pack, new Attrs(new Attrs[0]));
        }
    }

    public void referToByBinaryName(String binaryClassName) {
        Descriptors.TypeRef ref = this.descriptors.getTypeRef(binaryClassName);
        this.referTo(ref);
    }

    void doRequireBnd() {
        Attrs require = OSGiHeader.parseProperties(this.getProperty("-require-bnd"));
        if (require == null || require.isEmpty()) {
            return;
        }
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("version", this.getBndVersion());
        for (String filter : require.keySet()) {
            try {
                Filter f = new Filter(filter);
                if (f.match(map)) continue;
                this.error("%s fails %s", "-require-bnd", require.get(filter));
            }
            catch (Exception t) {
                this.error("%s with value %s throws exception", t, "-require-bnd", require);
            }
        }
    }

    public String _md5(String[] args) throws Exception {
        boolean hex;
        Macro.verifyCommand(args, _md5Help, new Pattern[]{null, null, Pattern.compile("base64|hex")}, 2, 3);
        Digester<MD5> digester = MD5.getDigester(new OutputStream[0]);
        Resource r = this.dot.getResource(args[1]);
        if (r == null) {
            throw new FileNotFoundException("From " + digester + ", not found " + args[1]);
        }
        IO.copy(r.openInputStream(), digester);
        boolean bl = hex = args.length > 2 && args[2].equals("hex");
        if (hex) {
            return Hex.toHexString(digester.digest().digest());
        }
        return Base64.encodeBase64(digester.digest().digest());
    }

    public String _sha1(String[] args) throws Exception {
        Macro.verifyCommand(args, _sha1Help, new Pattern[]{null, null, Pattern.compile("base64|hex")}, 2, 3);
        Digester<SHA1> digester = SHA1.getDigester(new OutputStream[0]);
        Resource r = this.dot.getResource(args[1]);
        if (r == null) {
            throw new FileNotFoundException("From sha1, not found " + args[1]);
        }
        IO.copy(r.openInputStream(), digester);
        return Base64.encodeBase64(digester.digest().digest());
    }

    public Descriptors.Descriptor getDescriptor(String descriptor) {
        return this.descriptors.getDescriptor(descriptor);
    }

    public Descriptors.TypeRef getTypeRef(String binaryClassName) {
        return this.descriptors.getTypeRef(binaryClassName);
    }

    public Descriptors.PackageRef getPackageRef(String binaryName) {
        return this.descriptors.getPackageRef(binaryName);
    }

    public Descriptors.TypeRef getTypeRefFromFQN(String fqn) {
        return this.descriptors.getTypeRefFromFQN(fqn);
    }

    public Descriptors.TypeRef getTypeRefFromPath(String path) {
        return this.descriptors.getTypeRefFromPath(path);
    }

    public boolean isImported(Descriptors.PackageRef packageRef) {
        return this.imports.containsKey(packageRef);
    }

    Packages filter(Instructions instructions, Packages source, Set<Instruction> nomatch) {
        Packages result = new Packages();
        ArrayList<Descriptors.PackageRef> refs = new ArrayList<Descriptors.PackageRef>(source.keySet());
        Collections.sort(refs);
        ArrayList<Instruction> filters = new ArrayList<Instruction>(instructions.keySet());
        if (nomatch == null) {
            nomatch = Create.set();
        }
        for (Instruction instruction : filters) {
            boolean match = false;
            Iterator i = refs.iterator();
            while (i.hasNext()) {
                Descriptors.PackageRef packageRef = (Descriptors.PackageRef)i.next();
                if (packageRef.isMetaData()) {
                    i.remove();
                    continue;
                }
                String packageName = packageRef.getFQN();
                if (!instruction.matches(packageName)) continue;
                match = true;
                if (!instruction.isNegated()) {
                    result.merge(packageRef, instruction.isDuplicate(), source.get(packageRef), instructions.get(instruction));
                }
                i.remove();
            }
            if (match || instruction.isAny()) continue;
            nomatch.add(instruction);
        }
        Iterator<Instruction> i = nomatch.iterator();
        while (i.hasNext()) {
            Instruction instruction;
            instruction = i.next();
            if (instruction.isLiteral() && !instruction.isNegated()) {
                result.merge(this.getPackageRef(instruction.getLiteral()), true, instructions.get(instruction));
                i.remove();
                continue;
            }
            if (instruction.isNegated()) {
                i.remove();
                continue;
            }
            if (!instruction.isOptional()) continue;
            i.remove();
        }
        return result;
    }

    public void setDiagnostics(boolean b) {
        this.diagnostics = b;
    }

    public Clazz.JAVA getLowestEE() {
        if (this.ees.isEmpty()) {
            return Clazz.JAVA.JDK1_4;
        }
        return this.ees.first();
    }

    public String _ee(String[] args) {
        return this.getLowestEE().getEE();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File getOutputFile(String output) {
        Map.Entry<String, Attrs> name;
        File outputDir;
        if (output == null) {
            output = this.get("-output");
        }
        if (output != null) {
            File outputFile = this.getFile(output);
            if (!outputFile.isDirectory()) return outputFile;
            outputDir = outputFile;
        } else {
            outputDir = this.getBase();
        }
        if ((name = this.getBundleSymbolicName()) != null) {
            String bsn = name.getKey();
            String version = this.getBundleVersion();
            aQute.bnd.version.Version v = aQute.bnd.version.Version.parseVersion(version);
            String outputName = bsn + "-" + v.getWithoutQualifier() + ".jar";
            return new File(outputDir, outputName);
        }
        File source = this.getJar().getSource();
        if (source != null) {
            String outputName = source.getName();
            return new File(outputDir, outputName);
        }
        this.error("Cannot establish an output name from %s, nor bsn, nor source file name, using Untitled", output);
        int n = 0;
        File f = Analyzer.getFile(outputDir, "Untitled");
        while (f.isFile()) {
            f = Analyzer.getFile(outputDir, "Untitled-" + n++);
        }
        return f;
    }

    public boolean save(File output, boolean force) throws Exception {
        if (output == null) {
            output = this.getOutputFile(null);
        }
        Jar jar = this.getJar();
        File source = jar.getSource();
        this.trace("check for modified build=%s file=%s, diff=%s", jar.lastModified(), output.lastModified(), jar.lastModified() - output.lastModified());
        if (!output.exists() || output.lastModified() <= jar.lastModified() || force) {
            File op = output.getParentFile();
            if (!op.exists() && !op.mkdirs()) {
                throw new IOException("Could not create directory " + op);
            }
            if (source != null && output.getCanonicalPath().equals(source.getCanonicalPath())) {
                File bak = new File(source.getParentFile(), source.getName() + ".bak");
                if (!source.renameTo(bak)) {
                    this.error("Could not create backup file %s", bak);
                } else {
                    source.delete();
                }
            }
            try {
                this.trace("Saving jar to %s", output);
                this.getJar().write(output);
            }
            catch (Exception e) {
                output.delete();
                this.error("Cannot write JAR file to %s due to %s", e, output, e.getMessage());
            }
            return true;
        }
        this.trace("Not modified %s", output);
        return false;
    }

    public void setDefaults(String bsn, aQute.bnd.version.Version version) {
        if (this.getExportPackage() == null) {
            this.setExportPackage("*");
        }
        if (this.getImportPackage() == null) {
            this.setExportPackage("*");
        }
        if (bsn != null && this.getBundleSymbolicName() == null) {
            this.setBundleSymbolicName(bsn);
        }
        if (version != null && this.getBundleVersion() == null) {
            this.setBundleVersion(version);
        }
    }

    public Map<Descriptors.PackageRef, List<Descriptors.PackageRef>> cleanupUses(Map<Descriptors.PackageRef, List<Descriptors.PackageRef>> apiUses, boolean removeJava) {
        MultiMap<Descriptors.PackageRef, Descriptors.PackageRef> map = new MultiMap<Descriptors.PackageRef, Descriptors.PackageRef>(apiUses);
        for (Map.Entry e : map.entrySet()) {
            ((List)e.getValue()).remove(e.getKey());
            if (!removeJava) continue;
            Iterator i = ((List)e.getValue()).iterator();
            while (i.hasNext()) {
                if (!((Descriptors.PackageRef)i.next()).isJava()) continue;
                i.remove();
            }
        }
        return map;
    }

    public Set<Clazz> getClassspace(Descriptors.PackageRef source) {
        HashSet<Clazz> result = new HashSet<Clazz>();
        for (Clazz c : this.getClassspace().values()) {
            if (c.getClassName().getPackageRef() != source) continue;
            result.add(c);
        }
        return result;
    }

    public Map<Clazz.Def, List<Descriptors.TypeRef>> getXRef(Descriptors.PackageRef source, final Collection<Descriptors.PackageRef> dest, final int sourceModifiers) throws Exception {
        final MultiMap<Clazz.Def, Descriptors.TypeRef> xref = new MultiMap<Clazz.Def, Descriptors.TypeRef>(Clazz.Def.class, Descriptors.TypeRef.class, true);
        for (final Clazz clazz : this.getClassspace().values()) {
            if ((clazz.accessx & sourceModifiers) == 0 || source != null && source != clazz.getClassName().getPackageRef()) continue;
            clazz.parseClassFileWithCollector(new ClassDataCollector(){
                Clazz.Def member;

                public void extendsClass(Descriptors.TypeRef zuper) throws Exception {
                    if (dest.contains(zuper.getPackageRef())) {
                        xref.add(clazz.getExtends(zuper), zuper);
                    }
                }

                public void implementsInterfaces(Descriptors.TypeRef[] interfaces) throws Exception {
                    for (Descriptors.TypeRef i : interfaces) {
                        if (!dest.contains(i.getPackageRef())) continue;
                        xref.add(clazz.getImplements(i), i);
                    }
                }

                public void referTo(Descriptors.TypeRef to, int modifiers) {
                    if (to.isJava()) {
                        return;
                    }
                    if (!dest.contains(to.getPackageRef())) {
                        return;
                    }
                    if (this.member != null && (modifiers & sourceModifiers) != 0) {
                        xref.add(this.member, to);
                    }
                }

                public void method(Clazz.MethodDef defined) {
                    this.member = defined;
                }

                public void field(Clazz.FieldDef defined) {
                    this.member = defined;
                }
            });
        }
        return xref;
    }

    static {
        df = new SimpleDateFormat("EEE MMM dd hh:mm:ss z yyyy");
        OBJECT_REFERENCE = Pattern.compile("L([^/]+/)*([^;]+);");
        fuzzyVersion = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);
        fuzzyVersionRange = Pattern.compile("(\\(|\\[)\\s*([-\\da-zA-Z.]+)\\s*,\\s*([-\\da-zA-Z.]+)\\s*(\\]|\\))", 32);
        fuzzyModifier = Pattern.compile("(\\d+[.-])*(.*)", 32);
        nummeric = Pattern.compile("\\d*");
        _classesHelp = "${classes;'implementing'|'extending'|'importing'|'named'|'version'|'any';<pattern>}, Return a list of class fully qualified class names that extend/implement/import any of the contained classes matching the pattern\n";
        _md5Help = "${md5;path}";
        _sha1Help = "${sha1;path}";
    }
}

