/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.boot;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;

public class KarafMBeanServerBuilder
extends MBeanServerBuilder {
    private static volatile InvocationHandler guard;

    public static InvocationHandler getGuard() {
        return guard;
    }

    public static void setGuard(InvocationHandler guardHandler) {
        guard = guardHandler;
    }

    public MBeanServer newMBeanServer(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate) {
        MBeanInvocationHandler handler = new MBeanInvocationHandler(super.newMBeanServer(defaultDomain, outer, delegate));
        return (MBeanServer)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{MBeanServer.class}, (InvocationHandler)handler);
    }

    private static final class MBeanInvocationHandler
    implements InvocationHandler {
        private final MBeanServer wrapped;
        private final List<String> guarded = Collections.unmodifiableList(Arrays.asList("invoke", "getAttribute", "getAttributes", "setAttribute", "setAttributes"));

        MBeanInvocationHandler(MBeanServer mbeanServer) {
            this.wrapped = mbeanServer;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.guarded.contains(method.getName())) {
                if (guard == null) {
                    throw new IllegalStateException("KarafMBeanServerBuilder not initialized");
                }
                guard.invoke(proxy, method, args);
            }
            try {
                return method.invoke((Object)this.wrapped, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
    }
}

