/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.TransactionManagerMonitor;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class GeronimoPlatformTransactionManager
extends GeronimoTransactionManager
implements PlatformTransactionManager {
    private final PlatformTransactionManager platformTransactionManager;
    private final Map<Transaction, SuspendedResourcesHolder> suspendedResources = new ConcurrentHashMap<Transaction, SuspendedResourcesHolder>();

    public GeronimoPlatformTransactionManager() throws XAException {
        this.platformTransactionManager = new JtaTransactionManager((UserTransaction)this, (TransactionManager)this);
        this.registerTransactionAssociationListener();
    }

    public GeronimoPlatformTransactionManager(int defaultTransactionTimeoutSeconds) throws XAException {
        super(defaultTransactionTimeoutSeconds);
        this.platformTransactionManager = new JtaTransactionManager((UserTransaction)this, (TransactionManager)this);
        this.registerTransactionAssociationListener();
    }

    public GeronimoPlatformTransactionManager(int defaultTransactionTimeoutSeconds, TransactionLog transactionLog) throws XAException {
        super(defaultTransactionTimeoutSeconds, transactionLog);
        this.platformTransactionManager = new JtaTransactionManager((UserTransaction)this, (TransactionManager)this);
        this.registerTransactionAssociationListener();
    }

    public GeronimoPlatformTransactionManager(int defaultTransactionTimeoutSeconds, XidFactory xidFactory, TransactionLog transactionLog) throws XAException {
        super(defaultTransactionTimeoutSeconds, xidFactory, transactionLog);
        this.platformTransactionManager = new JtaTransactionManager((UserTransaction)this, (TransactionManager)this);
        this.registerTransactionAssociationListener();
    }

    public TransactionStatus getTransaction(TransactionDefinition definition) throws TransactionException {
        return this.platformTransactionManager.getTransaction(definition);
    }

    public void commit(TransactionStatus status) throws TransactionException {
        this.platformTransactionManager.commit(status);
    }

    public void rollback(TransactionStatus status) throws TransactionException {
        this.platformTransactionManager.rollback(status);
    }

    protected void registerTransactionAssociationListener() {
        this.addTransactionAssociationListener(new TransactionManagerMonitor(){

            public void threadAssociated(Transaction transaction) {
                try {
                    SuspendedResourcesHolder holder;
                    if (transaction.getStatus() == 0 && (holder = (SuspendedResourcesHolder)GeronimoPlatformTransactionManager.this.suspendedResources.remove(transaction)) != null && holder.getSuspendedSynchronizations() != null) {
                        TransactionSynchronizationManager.setActualTransactionActive((boolean)true);
                        TransactionSynchronizationManager.setCurrentTransactionReadOnly((boolean)holder.isReadOnly());
                        TransactionSynchronizationManager.setCurrentTransactionName((String)holder.getName());
                        TransactionSynchronizationManager.initSynchronization();
                        for (TransactionSynchronization synchronization : holder.getSuspendedSynchronizations()) {
                            synchronization.resume();
                            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)synchronization);
                        }
                    }
                }
                catch (SystemException e) {
                    return;
                }
            }

            public void threadUnassociated(Transaction transaction) {
                try {
                    if (transaction.getStatus() == 0 && TransactionSynchronizationManager.isSynchronizationActive()) {
                        List suspendedSynchronizations = TransactionSynchronizationManager.getSynchronizations();
                        Iterator it = suspendedSynchronizations.iterator();
                        while (it.hasNext()) {
                            ((TransactionSynchronization)it.next()).suspend();
                        }
                        TransactionSynchronizationManager.clearSynchronization();
                        String name = TransactionSynchronizationManager.getCurrentTransactionName();
                        TransactionSynchronizationManager.setCurrentTransactionName(null);
                        boolean readOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
                        TransactionSynchronizationManager.setCurrentTransactionReadOnly((boolean)false);
                        TransactionSynchronizationManager.setActualTransactionActive((boolean)false);
                        SuspendedResourcesHolder holder = new SuspendedResourcesHolder(null, suspendedSynchronizations, name, readOnly);
                        GeronimoPlatformTransactionManager.this.suspendedResources.put(transaction, holder);
                    }
                }
                catch (SystemException e) {
                    return;
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SuspendedResourcesHolder {
        private final Object suspendedResources;
        private final List<?> suspendedSynchronizations;
        private final String name;
        private final boolean readOnly;

        public SuspendedResourcesHolder(Object suspendedResources, List<?> suspendedSynchronizations, String name, boolean readOnly) {
            this.suspendedResources = suspendedResources;
            this.suspendedSynchronizations = suspendedSynchronizations;
            this.name = name;
            this.readOnly = readOnly;
        }

        public Object getSuspendedResources() {
            return this.suspendedResources;
        }

        public List<?> getSuspendedSynchronizations() {
            return this.suspendedSynchronizations;
        }

        public String getName() {
            return this.name;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }
    }
}

