/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.scr.impl.helper.Logger;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.PropertyMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.apache.felix.scr.impl.metadata.ServiceMetadata;
import org.apache.felix.scr.impl.parser.KXml2SAXHandler;
import org.apache.felix.scr.impl.parser.ParseException;
import org.osgi.framework.Bundle;

public class XmlHandler
implements KXml2SAXHandler {
    public static final String NAMESPACE_URI_EMPTY = "";
    public static final String NAMESPACE_URI = "http://www.osgi.org/xmlns/scr/v1.0.0";
    public static final String NAMESPACE_URI_1_1 = "http://www.osgi.org/xmlns/scr/v1.1.0";
    public static final String NAMESPACE_URI_1_1_FELIX = "http://felix.apache.org/xmlns/scr/v1.1.0-felix";
    public static final String NAMESPACE_URI_1_2 = "http://www.osgi.org/xmlns/scr/v1.2.0";
    public static final String NAMESPACE_URI_1_2_FELIX = "http://felix.apache.org/xmlns/scr/v1.2.0-felix";
    public static final int DS_VERSION_NONE = -1;
    public static final int DS_VERSION_1_0 = 0;
    public static final int DS_VERSION_1_1 = 1;
    public static final int DS_VERSION_1_1_FELIX = 2;
    public static final int DS_VERSION_1_2 = 3;
    public static final int DS_VERSION_1_2_FELIX = 4;
    private static final Map NAMESPACE_CODE_MAP = new HashMap();
    private final Bundle m_bundle;
    private final Logger m_logger;
    private ComponentMetadata m_currentComponent;
    private ServiceMetadata m_currentService;
    private List m_components = new ArrayList();
    private PropertyMetadata m_pendingProperty;
    protected boolean firstElement = true;
    protected String overrideNamespace;
    protected boolean isComponent = false;

    public XmlHandler(Bundle bundle, Logger logger) {
        this.m_bundle = bundle;
        this.m_logger = logger;
    }

    public List getComponentMetadataList() {
        return this.m_components;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String uri, String localName, Properties attrib) throws ParseException {
        Integer namespaceCode;
        if (this.firstElement) {
            this.firstElement = false;
            if (localName.equals("component") && NAMESPACE_URI_EMPTY.equals(uri)) {
                this.overrideNamespace = NAMESPACE_URI;
            }
        }
        if (this.overrideNamespace != null && NAMESPACE_URI_EMPTY.equals(uri)) {
            uri = this.overrideNamespace;
        }
        if (this.isComponent && NAMESPACE_URI_EMPTY.equals(uri)) {
            uri = NAMESPACE_URI;
        }
        if ((namespaceCode = (Integer)NAMESPACE_CODE_MAP.get(uri)) != null) {
            try {
                if (localName.equals("component")) {
                    this.isComponent = true;
                    this.m_currentComponent = new ComponentMetadata(namespaceCode);
                    if (attrib.getProperty("name") != null) {
                        this.m_currentComponent.setName(attrib.getProperty("name"));
                    }
                    if (attrib.getProperty("enabled") != null) {
                        this.m_currentComponent.setEnabled(attrib.getProperty("enabled").equals("true"));
                    }
                    if (attrib.getProperty("immediate") != null) {
                        this.m_currentComponent.setImmediate(attrib.getProperty("immediate").equals("true"));
                    }
                    if (attrib.getProperty("factory") != null) {
                        this.m_currentComponent.setFactoryIdentifier(attrib.getProperty("factory"));
                    }
                    if (attrib.getProperty("configuration-policy") != null) {
                        this.m_currentComponent.setConfigurationPolicy(attrib.getProperty("configuration-policy"));
                    }
                    if (attrib.getProperty("activate") != null) {
                        this.m_currentComponent.setActivate(attrib.getProperty("activate"));
                    }
                    if (attrib.getProperty("deactivate") != null) {
                        this.m_currentComponent.setDeactivate(attrib.getProperty("deactivate"));
                    }
                    if (attrib.getProperty("modified") != null) {
                        this.m_currentComponent.setModified(attrib.getProperty("modified"));
                    }
                    if (attrib.getProperty("configuration-pid") != null) {
                        this.m_currentComponent.setConfigurationPid(attrib.getProperty("configuration-pid"));
                    }
                    this.m_components.add(this.m_currentComponent);
                    return;
                }
                if (!this.isComponent) {
                    this.m_logger.log(4, "Not currently parsing a component; ignoring element {0} (bundle {1})", new Object[]{localName, this.m_bundle.getLocation()}, null, null, null);
                    return;
                }
                if (localName.equals("implementation")) {
                    this.m_currentComponent.setImplementationClassName(attrib.getProperty("class"));
                    return;
                }
                if (localName.equals("property")) {
                    PropertyMetadata prop = new PropertyMetadata();
                    prop.setName(attrib.getProperty("name"));
                    if (attrib.getProperty("type") != null) {
                        prop.setType(attrib.getProperty("type"));
                    }
                    if (attrib.getProperty("value") != null) {
                        prop.setValue(attrib.getProperty("value"));
                        this.m_currentComponent.addProperty(prop);
                        return;
                    }
                    this.m_pendingProperty = prop;
                    return;
                }
                if (localName.equals("properties")) {
                    this.readPropertiesEntry(attrib.getProperty("entry"));
                    return;
                }
                if (localName.equals("service")) {
                    this.m_currentService = new ServiceMetadata();
                    if (attrib.getProperty("servicefactory") != null) {
                        this.m_currentService.setServiceFactory(attrib.getProperty("servicefactory").equals("true"));
                    }
                    this.m_currentComponent.setService(this.m_currentService);
                    return;
                }
                if (localName.equals("provide")) {
                    this.m_currentService.addProvide(attrib.getProperty("interface"));
                    return;
                }
                if (localName.equals("reference")) {
                    ReferenceMetadata ref = new ReferenceMetadata();
                    if (attrib.getProperty("name") != null) {
                        ref.setName(attrib.getProperty("name"));
                    }
                    ref.setInterface(attrib.getProperty("interface"));
                    if (attrib.getProperty("cardinality") != null) {
                        ref.setCardinality(attrib.getProperty("cardinality"));
                    }
                    if (attrib.getProperty("policy") != null) {
                        ref.setPolicy(attrib.getProperty("policy"));
                    }
                    if (attrib.getProperty("policy-option") != null) {
                        ref.setPolicyOption(attrib.getProperty("policy-option"));
                    }
                    ref.setTarget(attrib.getProperty("target"));
                    ref.setBind(attrib.getProperty("bind"));
                    ref.setUpdated(attrib.getProperty("updated"));
                    ref.setUnbind(attrib.getProperty("unbind"));
                    this.m_currentComponent.addDependency(ref);
                    return;
                }
                if (localName.equals("components")) return;
                this.m_logger.log(4, "Ignoring unsupported element {0} (bundle {1})", new Object[]{localName, this.m_bundle.getLocation()}, null, null, null);
                return;
            }
            catch (Exception ex) {
                throw new ParseException("Exception during parsing", ex);
            }
        } else {
            if (localName.equals("components")) return;
            this.m_logger.log(4, "Ignoring unsupported element '{'{0}'}'{1} (bundle {2})", new Object[]{uri, localName, this.m_bundle.getLocation()}, null, null, null);
        }
    }

    public void endElement(String uri, String localName) {
        if (this.overrideNamespace != null && NAMESPACE_URI_EMPTY.equals(uri)) {
            uri = this.overrideNamespace;
        }
        if (this.isComponent && NAMESPACE_URI_EMPTY.equals(uri)) {
            uri = NAMESPACE_URI;
        }
        if (NAMESPACE_URI.equals(uri)) {
            if (localName.equals("component")) {
                this.isComponent = false;
            } else if (localName.equals("property") && this.m_pendingProperty != null) {
                this.m_pendingProperty = null;
            }
        }
    }

    public void characters(String text) {
        if (this.m_pendingProperty != null) {
            this.m_pendingProperty.setValues(text);
            this.m_currentComponent.addProperty(this.m_pendingProperty);
            this.m_pendingProperty = null;
        }
    }

    public void processingInstruction(String target, String data) {
    }

    public void setLineNumber(int lineNumber) {
    }

    public void setColumnNumber(int columnNumber) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPropertiesEntry(String entryName) throws ParseException {
        Properties props;
        block10: {
            if (entryName == null) {
                throw new ParseException("Missing entry attribute of properties element", null);
            }
            URL entryURL = this.m_bundle.getEntry(entryName);
            if (entryURL == null) {
                throw new ParseException("Missing bundle entry " + entryName, null);
            }
            props = new Properties();
            InputStream entryStream = null;
            try {
                try {
                    entryStream = entryURL.openStream();
                    props.load(entryStream);
                }
                catch (IOException ioe) {
                    throw new ParseException("Failed to read properties entry " + entryName, ioe);
                }
                Object var7_5 = null;
                if (entryStream == null) break block10;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (entryStream == null) throw throwable;
                try {
                    entryStream.close();
                    throw throwable;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ignore) {}
            entryStream.close();
        }
        Iterator<Map.Entry<Object, Object>> pi = props.entrySet().iterator();
        while (pi.hasNext()) {
            Map.Entry<Object, Object> pEntry = pi.next();
            PropertyMetadata prop = new PropertyMetadata();
            prop.setName(String.valueOf(pEntry.getKey()));
            prop.setValue(String.valueOf(pEntry.getValue()));
            this.m_currentComponent.addProperty(prop);
        }
    }

    static {
        NAMESPACE_CODE_MAP.put(NAMESPACE_URI_EMPTY, 0);
        NAMESPACE_CODE_MAP.put(NAMESPACE_URI, 0);
        NAMESPACE_CODE_MAP.put(NAMESPACE_URI_1_1, 1);
        NAMESPACE_CODE_MAP.put(NAMESPACE_URI_1_1_FELIX, 2);
        NAMESPACE_CODE_MAP.put(NAMESPACE_URI_1_2, 3);
        NAMESPACE_CODE_MAP.put(NAMESPACE_URI_1_2_FELIX, 4);
    }
}

