/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.osgi.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.switchyard.deploy.osgi.base.Extension;

public abstract class AbstractExtender
implements BundleActivator,
BundleTrackerCustomizer<Bundle>,
SynchronousBundleListener {
    private final ConcurrentMap<Bundle, Extension> _extensions = new ConcurrentHashMap<Bundle, Extension>();
    private final ConcurrentMap<Bundle, FutureTask> _destroying = new ConcurrentHashMap<Bundle, FutureTask>();
    private volatile boolean _stopping;
    private boolean _synchronous;
    private boolean _preemptiveShutdown;
    private BundleContext _context;
    private ExecutorService _executors;
    private BundleTracker _tracker;

    public boolean isSynchronous() {
        return this._synchronous;
    }

    public boolean isPreemptiveShutdown() {
        return this._preemptiveShutdown;
    }

    public BundleContext getBundleContext() {
        return this._context;
    }

    public ExecutorService getExecutors() {
        return this._executors;
    }

    public void setSynchronous(boolean synchronous) {
        this._synchronous = synchronous;
    }

    public void setPreemptiveShutdown(boolean preemptiveShutdown) {
        this._preemptiveShutdown = preemptiveShutdown;
    }

    public void start(BundleContext context) throws Exception {
        this._context = context;
        this._context.addBundleListener((BundleListener)this);
        this._tracker = new BundleTracker(this._context, 40, (BundleTrackerCustomizer)this);
        if (!this._synchronous) {
            this._executors = this.createExecutor();
        }
        this.doStart();
    }

    public void stop(BundleContext context) throws Exception {
        this._stopping = true;
        while (!this._extensions.isEmpty()) {
            Collection<Bundle> toDestroy = this.chooseBundlesToDestroy(this._extensions.keySet());
            if (toDestroy == null || toDestroy.isEmpty()) {
                toDestroy = new ArrayList(this._extensions.keySet());
            }
            for (Bundle bundle : toDestroy) {
                this.destroyExtension(bundle);
            }
        }
        this.doStop();
        if (this._executors != null) {
            this._executors.shutdown();
            try {
                this._executors.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.getMessage();
            }
            this._executors = null;
        }
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (bundle.getState() != 32 && bundle.getState() != 8 && bundle != this._context.getBundle()) {
            this.destroyExtension(bundle);
        }
    }

    public Bundle addingBundle(Bundle bundle, BundleEvent event) {
        this.modifiedBundle(bundle, event, bundle);
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        String activationPolicyHeader;
        if (bundle.getBundleId() == 0L && bundle.getState() == 16 && this._preemptiveShutdown) {
            try {
                this.stop(this._context);
            }
            catch (Exception e) {
                this.error("Error while performing preemptive shutdown", e);
            }
            return;
        }
        if (bundle.getState() != 32 && bundle.getState() != 8) {
            if (bundle != this._context.getBundle()) {
                this.destroyExtension(bundle);
            }
            return;
        }
        if (this._stopping) {
            return;
        }
        if (!(bundle.getState() != 8 || (activationPolicyHeader = (String)bundle.getHeaders().get("Bundle-ActivationPolicy")) != null && activationPolicyHeader.startsWith("lazy"))) {
            return;
        }
        this.createExtension(bundle);
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        this.destroyExtension(bundle);
    }

    protected void doStart() throws Exception {
        this.startTracking();
    }

    protected void doStop() throws Exception {
        this.stopTracking();
    }

    protected void startTracking() {
        this._tracker.open();
    }

    protected void stopTracking() {
        this._tracker.close();
    }

    protected ExecutorService createExecutor() {
        return Executors.newScheduledThreadPool(3);
    }

    protected Collection<Bundle> chooseBundlesToDestroy(Set<Bundle> bundles) {
        return null;
    }

    protected abstract Extension doCreateExtension(Bundle var1) throws Exception;

    protected abstract void debug(Bundle var1, String var2);

    protected abstract void warn(Bundle var1, String var2, Throwable var3);

    protected abstract void error(String var1, Throwable var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExtension(final Bundle bundle) {
        try {
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext == null) {
                return;
            }
            final Extension extension = this.doCreateExtension(bundle);
            if (extension == null) {
                return;
            }
            ConcurrentMap<Bundle, Extension> concurrentMap = this._extensions;
            synchronized (concurrentMap) {
                if (this._extensions.putIfAbsent(bundle, extension) != null) {
                    return;
                }
            }
            if (this._synchronous) {
                this.debug(bundle, "Starting extension synchronously");
                extension.start();
            } else {
                this.debug(bundle, "Scheduling asynchronous start of extension");
                this.getExecutors().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            extension.start();
                        }
                        catch (Throwable t) {
                            AbstractExtender.this.warn(bundle, "Error starting extension", t);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            this.warn(bundle, "Error while creating extension", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyExtension(final Bundle bundle) {
        FutureTask<Object> future;
        ConcurrentMap<Bundle, Extension> concurrentMap = this._extensions;
        synchronized (concurrentMap) {
            this.debug(bundle, "Starting destruction process");
            future = (FutureTask<Object>)this._destroying.get(bundle);
            if (future == null) {
                final Extension extension = (Extension)this._extensions.remove(bundle);
                if (extension != null) {
                    this.debug(bundle, "Scheduling extension destruction");
                    future = new FutureTask<Object>(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            AbstractExtender.this.debug(bundle, "Destroying extension");
                            try {
                                extension.destroy();
                            }
                            catch (Throwable t) {
                                AbstractExtender.this.warn(bundle, "Error while destroying extension", t);
                            }
                            finally {
                                AbstractExtender.this.debug(bundle, "Finished destroying extension");
                                ConcurrentMap concurrentMap = AbstractExtender.this._extensions;
                                synchronized (concurrentMap) {
                                    AbstractExtender.this._destroying.remove(bundle);
                                }
                            }
                        }
                    }, null);
                    this._destroying.put(bundle, future);
                } else {
                    this.debug(bundle, "Not an extended bundle or destruction of extension already finished");
                }
            } else {
                this.debug(bundle, "Destruction already scheduled");
            }
        }
        if (future != null) {
            try {
                this.debug(bundle, "Waiting for extension destruction");
                future.run();
                future.get();
            }
            catch (Throwable t) {
                this.warn(bundle, "Error while destroying extension", t);
            }
        }
    }
}

