/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.osgi.base;

import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.switchyard.deploy.osgi.base.Extension;

public abstract class SimpleExtension
implements Extension {
    protected final Bundle _bundle;
    protected final BundleContext _bundleContext;
    protected final AtomicBoolean _destroyed = new AtomicBoolean(false);

    public SimpleExtension(Bundle bundle) {
        this._bundle = bundle;
        this._bundleContext = bundle.getBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        Object object = this.getLock();
        synchronized (object) {
            return this._destroyed.get();
        }
    }

    public Bundle getBundle() {
        return this._bundle;
    }

    public BundleContext getBundleContext() {
        return this._bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Object object = this.getLock();
        synchronized (object) {
            if (this._destroyed.get()) {
                return;
            }
            if (this._bundle.getState() != 32) {
                return;
            }
            if (this._bundle.getBundleContext() != this._bundleContext) {
                return;
            }
            this.doStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws Exception {
        Object object = this.getLock();
        synchronized (object) {
            this._destroyed.set(true);
        }
        this.doDestroy();
    }

    protected Object getLock() {
        return this;
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doDestroy() throws Exception;
}

