/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.osgi.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.switchyard.deploy.osgi.SwitchYardEvent;
import org.switchyard.deploy.osgi.SwitchYardListener;
import org.switchyard.deploy.osgi.internal.SwitchYardThreadFactory;

public class SwitchYardEventDispatcher
implements SwitchYardListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchYardEventDispatcher.class);
    private final Set<SwitchYardListener> _listeners = new CopyOnWriteArraySet<SwitchYardListener>();
    private final Map<Bundle, SwitchYardEvent> _states = new ConcurrentHashMap<Bundle, SwitchYardEvent>();
    private final ExecutorService _executor;
    private final ExecutorService _sharedExecutor;
    private final EventAdminListener _eventAdminListener;
    private final ServiceTracker<SwitchYardListener, SwitchYardListener> _containerListenerTracker;

    SwitchYardEventDispatcher(final BundleContext bundleContext, ExecutorService sharedExecutor) {
        assert (bundleContext != null);
        assert (sharedExecutor != null);
        this._executor = Executors.newSingleThreadExecutor(new SwitchYardThreadFactory("Switchyard Event Dispatcher"));
        this._sharedExecutor = sharedExecutor;
        EventAdminListener listener = null;
        try {
            this.getClass().getClassLoader().loadClass("org.osgi.service.event.EventAdmin");
            listener = new EventAdminListener(bundleContext);
        }
        catch (Throwable t) {
            LOGGER.debug("EventAdmin package is not available, just don't use it");
        }
        this._eventAdminListener = listener;
        this._containerListenerTracker = new ServiceTracker(bundleContext, SwitchYardListener.class.getName(), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<SwitchYardListener, SwitchYardListener>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SwitchYardListener addingService(ServiceReference<SwitchYardListener> reference) {
                SwitchYardListener listener = (SwitchYardListener)bundleContext.getService(reference);
                Set set = SwitchYardEventDispatcher.this._listeners;
                synchronized (set) {
                    SwitchYardEventDispatcher.this.sendInitialEvents(listener);
                    SwitchYardEventDispatcher.this._listeners.add(listener);
                }
                return listener;
            }

            public void modifiedService(ServiceReference<SwitchYardListener> reference, SwitchYardListener service) {
            }

            public void removedService(ServiceReference<SwitchYardListener> reference, SwitchYardListener service) {
                SwitchYardEventDispatcher.this._listeners.remove(service);
                bundleContext.ungetService(reference);
            }
        });
        this._containerListenerTracker.open();
    }

    private void sendInitialEvents(SwitchYardListener listener) {
        for (Map.Entry<Bundle, SwitchYardEvent> entry : this._states.entrySet()) {
            try {
                this.callListener(listener, new SwitchYardEvent(entry.getValue(), true));
            }
            catch (RejectedExecutionException ree) {
                LOGGER.warn("Executor shut down", (Throwable)ree);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchyardEvent(final SwitchYardEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending switchyard container event {} for bundle {}", (Object)SwitchYardEventDispatcher.toString(event), (Object)event.getBundle().getSymbolicName());
        }
        Set<SwitchYardListener> set = this._listeners;
        synchronized (set) {
            this.callListeners(event);
            this._states.put(event.getBundle(), event);
        }
        if (this._eventAdminListener != null) {
            try {
                this._sharedExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        SwitchYardEventDispatcher.this._eventAdminListener.switchyardEvent(event);
                    }
                });
            }
            catch (RejectedExecutionException ree) {
                LOGGER.warn("Executor shut down", (Throwable)ree);
            }
        }
    }

    private static String toString(SwitchYardEvent event) {
        return "SwitchyardEvent[type=" + SwitchYardEventDispatcher.getEventType(event.getType()) + (event.getDependencies() != null ? ", dependencies=" + Arrays.asList(event.getDependencies()) : "") + (event.getCause() != null ? ", exception=" + event.getCause().getMessage() : "") + "]";
    }

    private static String getEventType(int type) {
        switch (type) {
            case 1: {
                return "CREATING";
            }
            case 2: {
                return "CREATED";
            }
            case 3: {
                return "DESTROYING";
            }
            case 4: {
                return "DESTROYED";
            }
            case 5: {
                return "FAILURE";
            }
            case 6: {
                return "GRACE_PERIOD";
            }
        }
        return "UNKNOWN";
    }

    private void callListeners(SwitchYardEvent event) {
        for (SwitchYardListener listener : this._listeners) {
            try {
                this.callListener(listener, event);
            }
            catch (RejectedExecutionException ree) {
                LOGGER.warn("Executor shut down", (Throwable)ree);
                break;
            }
        }
    }

    private void callListener(final SwitchYardListener listener, final SwitchYardEvent event) throws RejectedExecutionException {
        try {
            this._executor.invokeAny(Collections.singleton(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    listener.switchyardEvent(event);
                    return null;
                }
            }), 60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            LOGGER.warn("Thread interrupted", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException te) {
            LOGGER.warn("Listener timed out, will be ignored", (Throwable)te);
            this._listeners.remove(listener);
        }
        catch (ExecutionException ee) {
            LOGGER.warn("Listener caused an exception, will be ignored", (Throwable)ee);
            this._listeners.remove(listener);
        }
    }

    void destroy() {
        this._executor.shutdown();
        try {
            this._executor.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._containerListenerTracker.close();
        if (this._eventAdminListener != null) {
            this._eventAdminListener.destroy();
        }
    }

    public void removeSwitchyardBundle(Bundle bundle) {
        this._states.remove(bundle);
    }

    private static class EventAdminListener
    implements SwitchYardListener {
        private final ServiceTracker tracker;

        EventAdminListener(BundleContext context) {
            this.tracker = new ServiceTracker(context, EventAdmin.class.getName(), null);
            this.tracker.open();
        }

        @Override
        public void switchyardEvent(SwitchYardEvent event) {
            String topic;
            EventAdmin eventAdmin = (EventAdmin)this.tracker.getService();
            if (eventAdmin == null) {
                return;
            }
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("type", event.getType());
            ((Dictionary)props).put("event", event);
            ((Dictionary)props).put("timestamp", event.getTimestamp());
            ((Dictionary)props).put("bundle", event.getBundle());
            ((Dictionary)props).put("bundle.symbolicName", event.getBundle().getSymbolicName());
            ((Dictionary)props).put("bundle.id", event.getBundle().getBundleId());
            ((Dictionary)props).put("bundle.version", event.getBundle().getVersion());
            ((Dictionary)props).put("extender.bundle", event.getExtenderBundle());
            ((Dictionary)props).put("extender.bundle.id", event.getExtenderBundle().getBundleId());
            ((Dictionary)props).put("extender.bundle.symbolicName", event.getExtenderBundle().getSymbolicName());
            ((Dictionary)props).put("extender.bundle.version", event.getExtenderBundle().getVersion());
            if (event.getCause() != null) {
                ((Dictionary)props).put("cause", event.getCause());
            }
            if (event.getDependencies() != null) {
                ((Dictionary)props).put("dependencies", event.getDependencies());
            }
            switch (event.getType()) {
                case 1: {
                    topic = "org/switchyard/container/CREATING";
                    break;
                }
                case 2: {
                    topic = "org/switchyard/container/CREATED";
                    break;
                }
                case 3: {
                    topic = "org/switchyard/container/DESTROYING";
                    break;
                }
                case 4: {
                    topic = "org/switchyard/container/DESTROYED";
                    break;
                }
                case 5: {
                    topic = "org/switchyard/container/FAILURE";
                    break;
                }
                case 6: {
                    topic = "org/switchyard/container/GRACE_PERIOD";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown switchyard event type: " + event.getType());
                }
            }
            eventAdmin.postEvent(new Event(topic, props));
        }

        public void destroy() {
            this.tracker.close();
        }
    }
}

